/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easycommons.soap.handler;

import com.ebmwebsourcing.easycommons.soap.handler.SOAPException;
import com.ebmwebsourcing.easycommons.soap.handler.SOAPMessageGenerator;
import java.util.logging.Logger;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Namespace;
import org.petalslink.abslayer.service.api.Binding;
import org.petalslink.abslayer.service.api.BindingOperation;
import org.petalslink.abslayer.service.api.Description;
import org.petalslink.abslayer.service.api.Operation;

public class SOAPAdapter {
    private Logger log = Logger.getLogger(SOAPAdapter.class.getName());
    private final Description desc;

    public SOAPAdapter(Description desc) {
        this.desc = desc;
    }

    public Document format(Document msg, BindingOperation bOp, SOAPMessageGenerator.Direction direction) throws SOAPException {
        Document formattedMessage = null;
        if (bOp == null) {
            throw new SOAPException("Binding operation cannot be null!!!");
        }
        if (bOp.getStyle() == Binding.BindingStyle.DOCUMENT) {
            this.log.finest("format as document");
            formattedMessage = this.formatAsDocument(msg, bOp, direction);
        } else if (bOp.getStyle() == Binding.BindingStyle.RPC) {
            this.log.finest("format as rpc");
            formattedMessage = this.formatAsRpc(msg, bOp, direction);
        }
        return formattedMessage;
    }

    private Document formatAsRpc(Document msg, BindingOperation bOp, SOAPMessageGenerator.Direction direction) {
        Document formattedMessage = null;
        if (msg != null) {
            Element elmt = (Element)msg.getRootElement().clone();
            String operationName = bOp.inferQName().getLocalPart();
            if (SOAPMessageGenerator.Direction.RESPONSE.equals((Object)direction)) {
                operationName = String.valueOf(operationName) + "Response";
            }
            elmt.setName(operationName);
            if (!elmt.getNamespaceURI().equals(bOp.inferQName().getNamespaceURI())) {
                elmt.setNamespace(Namespace.getNamespace((String)bOp.inferQName().getNamespaceURI()));
            }
            Document doc = new Document(elmt);
            formattedMessage = new Document((Element)doc.getRootElement().detach());
        } else {
            String operationName = bOp.inferQName().getLocalPart();
            if (SOAPMessageGenerator.Direction.RESPONSE.equals((Object)direction)) {
                operationName = String.valueOf(operationName) + "Response";
            }
            Element elmt = new Element(operationName, bOp.inferQName().getNamespaceURI());
            Document doc = new Document(elmt);
            formattedMessage = new Document((Element)doc.getRootElement().detach());
        }
        return formattedMessage;
    }

    private Document formatAsDocument(Document msg, BindingOperation bop, SOAPMessageGenerator.Direction direction) {
        Document formattedMessage = null;
        Operation op = bop.findOperation();
        if (msg != null) {
            Element elmt = null;
            elmt = msg.getRootElement().getChildren() != null && msg.getRootElement().getChildren().size() == 1 && (op.getInput().getMessageName().getLocalPart().equals(msg.getRootElement().getName()) || op.getOutput() != null && op.getOutput().getMessageName().getLocalPart().equals(msg.getRootElement().getName())) ? (Element)((Element)msg.getRootElement().getChildren().get(0)).clone() : (Element)msg.getRootElement().clone();
            if (SOAPMessageGenerator.Direction.REQUEST.equals((Object)direction) && op.getInput() != null && op.getInput().getParts() != null && op.getInput().getParts()[0].getType() != null && op.getInput().getParts()[0].getQName() != null) {
                elmt.setName(op.getInput().getParts()[0].getQName().getLocalPart());
            }
            if (elmt.getNamespaceURI() == null || elmt.getNamespaceURI().trim().length() == 0) {
                String prefix = null;
                prefix = (String)op.getParentInterface().getParentDescription().getNamespaces().get(op.inferQName().getNamespaceURI());
                if (prefix == null || prefix.trim().length() == 0) {
                    for (Namespace ns : elmt.getAdditionalNamespaces()) {
                        if (!ns.getURI().equals(op.inferQName().getNamespaceURI())) continue;
                        prefix = ns.getPrefix();
                        break;
                    }
                }
                if (prefix != null) {
                    elmt.setNamespace(Namespace.getNamespace((String)prefix, (String)op.inferQName().getNamespaceURI()));
                } else {
                    elmt.setNamespace(Namespace.getNamespace((String)op.inferQName().getNamespaceURI()));
                }
            }
            if (op.getInput().getParts() != null && op.getInput().getParts()[0].getType() != null) {
                elmt.setNamespace(null);
            }
            Document doc = new Document(elmt);
            formattedMessage = new Document((Element)doc.getRootElement().detach());
        } else {
            Element elmt = null;
            if (SOAPMessageGenerator.Direction.REQUEST.equals((Object)direction)) {
                if (op.getInput() != null) {
                    if (op.getInput().getElement() != null) {
                        elmt = new Element(op.getInput().getElement().inferQName().getLocalPart(), op.getInput().getElement().inferQName().getNamespaceURI());
                    } else if (op.getInput().getMessageName() != null) {
                        elmt = new Element(op.getInput().getMessageName().getLocalPart(), op.getInput().getMessageName().getNamespaceURI());
                    }
                }
            } else if (op.getOutput() != null) {
                if (op.getOutput().getElement() != null) {
                    elmt = new Element(op.getOutput().getElement().inferQName().getLocalPart(), op.getOutput().getElement().inferQName().getNamespaceURI());
                } else if (op.getOutput().getMessageName() != null) {
                    elmt = new Element(op.getOutput().getMessageName().getLocalPart(), op.getOutput().getMessageName().getNamespaceURI());
                }
            }
            if (elmt != null) {
                Document doc = new Document(elmt);
                formattedMessage = new Document((Element)doc.getRootElement().detach());
            }
        }
        return formattedMessage;
    }
}

