/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easycommons.soap.handler;

import com.ebmwebsourcing.easycommons.research.util.dom.DOMUtil;
import com.ebmwebsourcing.easycommons.soap.handler.SOAPException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class SOAPHandler {
    public static boolean isSoapFault(Document soapEnveloppe) throws SOAPException {
        Element fault;
        NodeList bodies;
        boolean res = false;
        if (soapEnveloppe != null && (bodies = soapEnveloppe.getElementsByTagNameNS("http://schemas.xmlsoap.org/soap/envelope/", "Body")) != null && bodies.getLength() > 0 && (fault = DOMUtil.getInstance().getFirstElement((Element)bodies.item(0))) != null && fault.getNamespaceURI() != null && fault.getNamespaceURI().equals("http://schemas.xmlsoap.org/soap/envelope/") && fault.getLocalName().equals("Fault")) {
            res = true;
        }
        return res;
    }

    public static Document createSoapFault(Document businessFault) throws SOAPException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        Document root = null;
        try {
            root = factory.newDocumentBuilder().newDocument();
            Element fault = root.createElementNS("http://schemas.xmlsoap.org/soap/envelope/", "Fault");
            fault.setPrefix("soapenv");
            root.appendChild(fault);
            Element faultcode = root.createElement("faultcode");
            faultcode.setNodeValue("soapenv:Server");
            fault.appendChild(faultcode);
            Element faultstring = root.createElement("faultstring");
            faultstring.setNodeValue("Server Error");
            fault.appendChild(faultstring);
            Element detail = root.createElement("detail");
            detail.appendChild(root.importNode(businessFault.getDocumentElement().cloneNode(true), true));
            fault.appendChild(detail);
        }
        catch (ParserConfigurationException e) {
            throw new SOAPException(e);
        }
        return root;
    }

    public static Element getBody(Document soapRequest) {
        NodeList bodies;
        Element body = null;
        if (soapRequest != null && (bodies = soapRequest.getElementsByTagNameNS("http://schemas.xmlsoap.org/soap/envelope/", "Body")) != null && bodies.getLength() == 1) {
            body = (Element)bodies.item(0);
        }
        return body;
    }

    public static Element getHeader(Document soapRequest) {
        Element header = null;
        NodeList headers = soapRequest.getElementsByTagNameNS("http://schemas.xmlsoap.org/soap/envelope/", "Header");
        if (headers != null && headers.getLength() == 1) {
            header = (Element)headers.item(0);
        }
        return header;
    }

    public static List<Element> getFaultDetails(Document soapFault) {
        Element body;
        NodeList details;
        ArrayList<Element> res = new ArrayList<Element>();
        if (soapFault != null && (details = (body = SOAPHandler.getBody(soapFault)).getElementsByTagName("detail")) != null && details.getLength() == 1) {
            Element detail = (Element)details.item(0);
            NodeList nl = detail.getChildNodes();
            for (int i = 0; i < nl.getLength(); ++i) {
                if (nl.item(i).getNodeType() != 1) continue;
                res.add((Element)nl.item(i));
            }
        }
        return res;
    }
}

