/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easycommons.soap.handler;

import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easybox.api.XmlContextFactory;
import com.ebmwebsourcing.easybox.api.XmlObject;
import com.ebmwebsourcing.easybox.api.XmlObjectFactory;
import com.ebmwebsourcing.easycommons.soap.handler.SOAPAdapter;
import com.ebmwebsourcing.easycommons.soap.handler.SOAPException;
import com.ebmwebsourcing.easycommons.soap.handler.SOAPSender;
import com.ebmwebsourcing.easyschema.xsd2xml.XSD2XML;
import com.ebmwebsourcing.easyschema10.api.SchemaHelper;
import com.ebmwebsourcing.easyschema10.api.SchemaOfSchemas;
import com.ebmwebsourcing.easyschema10.api.element.ComplexType;
import com.ebmwebsourcing.easyschema10.api.element.Schema;
import com.ebmwebsourcing.easyschema10.api.element.SimpleType;
import com.ebmwebsourcing.easyschema10.api.type.Type;
import com.ebmwebsourcing.easywsdl11.api.element.Binding;
import com.ebmwebsourcing.soapbinding11.api.SoapBindingHelper;
import java.util.ArrayList;
import java.util.Map;
import javax.xml.namespace.QName;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.output.DOMOutputter;
import org.petalslink.abslayer.service.api.BindingOperation;
import org.petalslink.abslayer.service.api.Description;
import org.petalslink.abslayer.service.api.Message;
import org.petalslink.abslayer.service.api.Part;

public class SOAPMessageGenerator {
    private Description desc;
    private SOAPAdapter adapter;
    private Map<Type, Object> defaultType = XSD2XML.createDefaultMap((Object)"?");

    public SOAPMessageGenerator(Description desc) {
        this.desc = desc;
        this.adapter = new SOAPAdapter(desc);
        this.defaultType.put(SchemaHelper.findTypeByQName((XmlObject)SchemaOfSchemas.getSchema(), (QName)new QName(SchemaOfSchemas.getSchema().getTargetNamespace(), "int")), "-1");
        this.defaultType.put(SchemaHelper.findTypeByQName((XmlObject)SchemaOfSchemas.getSchema(), (QName)new QName(SchemaOfSchemas.getSchema().getTargetNamespace(), "long")), "-1");
        this.defaultType.put(SchemaHelper.findTypeByQName((XmlObject)SchemaOfSchemas.getSchema(), (QName)new QName(SchemaOfSchemas.getSchema().getTargetNamespace(), "boolean")), "true");
        this.defaultType.put(SchemaHelper.findTypeByQName((XmlObject)SchemaOfSchemas.getSchema(), (QName)new QName(SchemaOfSchemas.getSchema().getTargetNamespace(), "date")), "2002-09-24");
        this.defaultType.put(SchemaHelper.findTypeByQName((XmlObject)SchemaOfSchemas.getSchema(), (QName)new QName(SchemaOfSchemas.getSchema().getTargetNamespace(), "time")), "09:00:00");
        this.defaultType.put(SchemaHelper.findTypeByQName((XmlObject)SchemaOfSchemas.getSchema(), (QName)new QName(SchemaOfSchemas.getSchema().getTargetNamespace(), "dateTime")), "2002-05-30T09:00:00");
    }

    public org.w3c.dom.Document generateSoapRequest(BindingOperation bop) throws SOAPException {
        org.w3c.dom.Document res = null;
        Binding wsdl11Binding = (Binding)bop.getBinding().getModel();
        if (bop.getBindingOperationInput() != null && SoapBindingHelper.getSoapBinding((Binding)wsdl11Binding).getTransport().equals("http://schemas.xmlsoap.org/soap/http")) {
            res = this.generateSoapMessage(bop, Direction.REQUEST);
        }
        return res;
    }

    public org.w3c.dom.Document generateSoapResponse(BindingOperation bop) throws SOAPException {
        org.w3c.dom.Document res = null;
        Binding wsdl11Binding = (Binding)bop.getBinding().getModel();
        if (bop.getBindingOperationOutput() != null && SoapBindingHelper.getSoapBinding((Binding)wsdl11Binding).getTransport().equals("http://schemas.xmlsoap.org/soap/http")) {
            res = this.generateSoapMessage(bop, Direction.RESPONSE);
        }
        return res;
    }

    public org.w3c.dom.Document generateSoapMessage(BindingOperation bop, Direction direction) throws SOAPException {
        org.w3c.dom.Document res = null;
        Document jdom = this.createGenericMessage(bop, direction);
        if (jdom != null) {
            jdom = this.adapter.format(jdom, bop, direction);
            try {
                DOMOutputter converter = new DOMOutputter();
                res = converter.output(jdom);
                res = SOAPSender.createSOAPMessageRequest(res);
            }
            catch (JDOMException e) {
                throw new SOAPException(e);
            }
        }
        return res;
    }

    private Document createGenericMessage(BindingOperation bop, Direction direction) throws SOAPException {
        Document message = null;
        QName messageName = null;
        messageName = Direction.REQUEST.equals((Object)direction) ? bop.findOperation().getInput().getMessageName() : bop.findOperation().getOutput().getMessageName();
        Message msg = this.desc.findMessage(messageName);
        if (msg == null) {
            throw new SOAPException("the message cannot be null: " + messageName);
        }
        ArrayList<Element> elmts = new ArrayList<Element>();
        for (Part part : msg.getParts()) {
            if (part.getElement() != null) {
                com.ebmwebsourcing.easyschema10.api.element.Element elmt = part.getElement();
                Element content = XSD2XML.newInstance().generateElement(elmt, (XmlObject)SchemaHelper.findParentSchema((XmlObject)elmt), this.defaultType, SchemaHelper.findParentSchema((XmlObject)elmt).getElementFormDefault(), 1, true, true);
                elmts.add(content);
                continue;
            }
            if (part.getType() == null) continue;
            XmlContextFactory xmlContextFactory = new XmlContextFactory();
            XmlContext xmlContext = xmlContextFactory.newContext();
            XmlObjectFactory xmlObjectFactory = xmlContext.getXmlObjectFactory();
            Schema[] schemas = (Schema[])this.desc.getTypes().findXmlAnyObjects(Schema.class);
            Schema selectedSchema = null;
            for (Schema s : schemas) {
                ComplexType ct = s.getComplexTypeByName(part.getType().getLocalPart());
                if (ct != null) {
                    selectedSchema = s;
                    break;
                }
                SimpleType st = s.getSimpleTypeByName(part.getType().getLocalPart());
                if (st == null) continue;
                selectedSchema = s;
                break;
            }
            com.ebmwebsourcing.easyschema10.api.element.Element elmt = (com.ebmwebsourcing.easyschema10.api.element.Element)xmlObjectFactory.create(com.ebmwebsourcing.easyschema10.api.element.Element.class);
            elmt.setName(part.getQName().getLocalPart());
            elmt.setType(part.getType());
            selectedSchema.addElement(elmt);
            Element content = XSD2XML.newInstance().generateElement(elmt, (XmlObject)SchemaHelper.findParentSchema((XmlObject)elmt), this.defaultType, SchemaHelper.findParentSchema((XmlObject)elmt).getElementFormDefault(), 1, true, true);
            content.setNamespace(null);
            elmts.add(content);
            selectedSchema.removeElement(elmt);
        }
        Element rootMessage = new Element(messageName.getLocalPart());
        Document doc = new Document(rootMessage);
        if (messageName.getNamespaceURI() != null) {
            rootMessage.setNamespace(Namespace.getNamespace((String)messageName.getPrefix(), (String)messageName.getNamespaceURI()));
        }
        for (Element elmt : elmts) {
            if (rootMessage.getNamespacePrefix() != null && elmt.getNamespace(rootMessage.getNamespacePrefix()) != null && !elmt.getNamespace(rootMessage.getNamespacePrefix()).getURI().equals(rootMessage.getNamespaceURI())) {
                int i = 0;
                Namespace nsAlreadyUsed = elmt.getNamespace("cns" + i);
                while (nsAlreadyUsed != null) {
                    nsAlreadyUsed = elmt.getNamespace("cns" + ++i);
                }
                rootMessage.setNamespace(Namespace.getNamespace((String)("cns" + i), (String)rootMessage.getNamespaceURI()));
            }
            rootMessage.addContent(elmt.detach());
        }
        message = new Document((Element)doc.getRootElement().detach());
        return message;
    }

    public static enum Direction {
        REQUEST("request"),
        RESPONSE("response");

        private final String value;

        private Direction(String value) {
            this.value = value;
        }

        public String value() {
            return this.value;
        }

        public boolean equals(String val) {
            return this.toString().equals(val);
        }

        public String toString() {
            return this.value;
        }
    }
}

