/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easyesb.component.bpel.test;

import com.ebmwebsourcing.easycommons.research.util.easybox.Framework;
import com.ebmwebsourcing.easycommons.research.util.easybox.SOAUtil;
import com.ebmwebsourcing.easycommons.research.util.jaxb.SOAJAXBContext;
import com.ebmwebsourcing.easycommons.xml.XMLPrettyPrinter;
import com.ebmwebsourcing.easyesb.component.bpel.api.BPELComponent;
import com.ebmwebsourcing.easyesb.component.bpel.impl.BPELComponentBehaviourImpl;
import com.ebmwebsourcing.easyesb.component.bpel.impl.BPELComponentImpl;
import com.ebmwebsourcing.easyesb.constant.EasyESBFramework;
import com.ebmwebsourcing.easyesb.exchange10.api.element.Exchange;
import com.ebmwebsourcing.easyesb.exchange10.api.type.PatternType;
import com.ebmwebsourcing.easyesb.exchange10.api.type.StatusType;
import com.ebmwebsourcing.easyesb.external.protocol.soap.impl.server.SoapServer;
import com.ebmwebsourcing.easyesb.soa.api.ESBException;
import com.ebmwebsourcing.easyesb.soa.api.config.Configuration;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.ClientEndpoint;
import com.ebmwebsourcing.easyesb.soa.api.node.Node;
import com.ebmwebsourcing.easyesb.soa.api.node.NodeBehaviour;
import com.ebmwebsourcing.easyesb.soa.api.util.MessageUtil;
import com.ebmwebsourcing.easyesb.soa.impl.config.ConfigurationImpl;
import com.ebmwebsourcing.easyesb.soa.impl.endpoint.ClientProxyEndpointImpl;
import com.ebmwebsourcing.easyesb.soa.impl.endpoint.behaviour.specific.ClientProxyBehaviourImpl;
import com.ebmwebsourcing.easyesb.soa.impl.endpoint.behaviour.specific.TechnicalEndpointInfosBehaviourImpl;
import com.ebmwebsourcing.easyesb.soa.impl.factory.ESBCoreFactoryImpl;
import com.ebmwebsourcing.easyesb.soa10.api.element.EndpointInitialContext;
import com.ebmwebsourcing.easyesb.soa10.api.element.ListenerInitialisation;
import easyesb.ebmwebsourcing.com.soa.model.endpoint.GetDescription;
import easyesb.ebmwebsourcing.com.soa.model.endpoint.GetDescriptionResponse;
import easyesb.petalslink.com.component.bpel.data._1.StoreBpel;
import easyesb.petalslink.com.component.bpel.data._1.StoreBpelResponse;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.LogManager;
import javax.xml.namespace.QName;
import junit.framework.Assert;
import org.junit.Test;

public class BPELComponentBehaviourTest {
    private EndpointInitialContext context = (EndpointInitialContext)SOAUtil.getInstance().getXmlContext((Framework)EasyESBFramework.getInstance()).getXmlObjectFactory().create(EndpointInitialContext.class);

    public BPELComponentBehaviourTest() throws Exception {
        this.context.setNumberOfThreads(5);
    }

    private Node createNode(QName name, String host, int port, final int soap_port) throws ESBException {
        ESBCoreFactoryImpl factory = new ESBCoreFactoryImpl(new String[0]);
        ConfigurationImpl conf = new ConfigurationImpl(host, port, (Map)new HashMap<String, String>(){
            {
                this.put(SoapServer.PORT_PROPERTY_NAME, String.valueOf(soap_port));
            }
        });
        Node node = factory.createNode(name, (Configuration)conf);
        return node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testStoreBpelMethod() throws Exception {
        Node node = this.createNode(new QName("http://com.ebmwebsourcing.easyesb", "node0"), "localhost", 9001, 8084);
        try {
            BPELComponent component = (BPELComponent)((NodeBehaviour)node.findBehaviour(NodeBehaviour.class)).createComponent("BPELEngine", BPELComponentImpl.class);
            component.addBehaviourClass(BPELComponentBehaviourImpl.class);
            ClientEndpoint clientEndpoint = ((NodeBehaviour)node.findBehaviour(NodeBehaviour.class)).createClientEndpoint(new QName("http://org.petalslink.easyesb/bpel/client", "myBPELComponentClient"), ClientProxyEndpointImpl.class, ClientProxyBehaviourImpl.class, this.context, new ListenerInitialisation[0]);
            System.out.println("clientEndpoint  = " + clientEndpoint);
            Exchange exchange = clientEndpoint.createExchange();
            exchange.setDestinationReference(component.getReference());
            exchange.setPattern(PatternType.IN_OUT);
            exchange.setStatus(StatusType.ACTIVE);
            exchange.setOperation(new QName("http://com.petalslink.easyesb/component/bpel/1.0", "storeBpel").toString());
            MessageUtil.getInstance().createInMessageStructure(exchange);
            StoreBpel request = new StoreBpel();
            request.setBpelUrl(Thread.currentThread().getContextClassLoader().getResource("travelagency/travelagency.bpel").toString());
            exchange.getMessageIn().getBody().setPayload(SOAJAXBContext.getInstance().unmarshallAnyElement((Object)request));
            System.out.println("Exchange = " + exchange);
            Exchange response = clientEndpoint.sendSync(exchange, 0L);
            StoreBpelResponse resp = (StoreBpelResponse)SOAJAXBContext.getInstance().marshallAnyType(exchange.getMessageOut().getBody().getPayload(), StoreBpelResponse.class);
            System.out.println("eps = " + resp.getBpelEndpointAddress());
            Assert.assertEquals((int)1, (int)resp.getBpelEndpointAddress().size());
        }
        finally {
            node.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBpelDescriptionMethod() throws Exception {
        Node node = this.createNode(new QName("http://com.ebmwebsourcing.easyesb", "node0"), "localhost", 9001, 8084);
        try {
            BPELComponent component = (BPELComponent)((NodeBehaviour)node.findBehaviour(NodeBehaviour.class)).createComponent("BPELEngine", BPELComponentImpl.class);
            component.addBehaviourClass(BPELComponentBehaviourImpl.class);
            component.addBehaviourClass(TechnicalEndpointInfosBehaviourImpl.class);
            ClientEndpoint clientEndpoint = ((NodeBehaviour)node.findBehaviour(NodeBehaviour.class)).createClientEndpoint(new QName("http://org.petalslink.easyesb/bpel/client", "myBPELComponentClient"), ClientProxyEndpointImpl.class, ClientProxyBehaviourImpl.class, this.context, new ListenerInitialisation[0]);
            System.out.println("clientEndpoint  = " + clientEndpoint);
            Exchange exchange = clientEndpoint.createExchange();
            exchange.setDestinationReference(component.getReference());
            exchange.setPattern(PatternType.IN_OUT);
            exchange.setStatus(StatusType.ACTIVE);
            exchange.setOperation(new QName("http://com.ebmwebsourcing.easyesb/soa/model/endpoint", "getDescription").toString());
            MessageUtil.getInstance().createInMessageStructure(exchange);
            GetDescription request = new GetDescription();
            exchange.getMessageIn().getBody().setPayload(SOAJAXBContext.getInstance().unmarshallAnyElement((Object)request));
            System.out.println("Exchange = " + exchange);
            Exchange response = clientEndpoint.sendSync(exchange, 0L);
            GetDescriptionResponse resp = (GetDescriptionResponse)SOAJAXBContext.getInstance().marshallAnyType(exchange.getMessageOut().getBody().getPayload(), GetDescriptionResponse.class);
            System.out.println("description = " + resp.getAny());
            Assert.assertNotNull((Object)resp.getAny());
            System.out.println("description = " + XMLPrettyPrinter.prettyPrint((org.w3c.dom.Node)((org.w3c.dom.Node)resp.getAny())));
        }
        finally {
            node.stop();
        }
    }

    static {
        try {
            InputStream configFile = Thread.currentThread().getContextClassLoader().getResourceAsStream("easycommons-logging.properties");
            LogManager.getLogManager().readConfiguration(configFile);
        }
        catch (IOException ex) {
            System.out.println("WARNING: Could not open configuration file");
            System.out.println("WARNING: Logging not configured (console output only)");
        }
    }
}

