/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easyesb.component.bpel.impl;

import com.ebmwebsourcing.easybpel.extended.service.activity.api.ExtendedActivityService;
import com.ebmwebsourcing.easybpel.extended.service.activity.impl.ExtendedActivityServiceImpl;
import com.ebmwebsourcing.easybpel.model.bpel.api.BPELException;
import com.ebmwebsourcing.easybpel.model.bpel.impl.BPELFactoryImpl;
import com.ebmwebsourcing.easycommons.sca.helper.impl.SCAHelper;
import com.ebmwebsourcing.easyesb.component.bpel.api.BPELComponent;
import com.ebmwebsourcing.easyesb.component.bpel.impl.env.ESBReceiverImpl;
import com.ebmwebsourcing.easyesb.component.bpel.impl.env.ESBSenderImpl;
import com.ebmwebsourcing.easyesb.external.protocol.soap.impl.server.SoapServer;
import com.ebmwebsourcing.easyesb.soa.api.ESBException;
import com.ebmwebsourcing.easyesb.soa.api.SOAElement;
import com.ebmwebsourcing.easyesb.soa.api.config.Configuration;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.behaviour.EndpointBehaviour;
import com.ebmwebsourcing.easyesb.soa.api.node.NodeBehaviour;
import com.ebmwebsourcing.easyesb.soa.impl.component.ComponentImpl;
import com.ebmwebsourcing.easyesb.soa10.api.type.ComponentType;
import com.ebmwebsourcing.easyviper.core.api.Core;
import com.ebmwebsourcing.easyviper.core.api.engine.configuration.ConfigurationEngine;
import com.ebmwebsourcing.easyviper.core.impl.engine.configuration.ConfigurationEngineImpl;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.oasisopen.sca.annotation.PolicySets;
import org.oasisopen.sca.annotation.Scope;
import org.oasisopen.sca.annotation.Service;

@Scope(value="COMPOSITE")
@Service(value={BPELComponent.class}, names={"service"})
@PolicySets(value={"frascati:scaEasyCompositeWithContent"})
public class BPELComponentImpl
extends ComponentImpl<ComponentType>
implements BPELComponent {
    private static final long serialVersionUID = 1L;
    private static Logger log = Logger.getLogger(BPELComponentImpl.class.getName());
    private Core core = null;

    public BPELComponentImpl() {
    }

    public BPELComponentImpl(QName name, ComponentType model, List<Class<? extends EndpointBehaviour>> behaviourClass, SOAElement<?> parent) throws ESBException {
        super(model, parent);
    }

    @Override
    public Core getCore() throws ESBException {
        if (this.core == null) {
            this.createCore();
        }
        return this.core;
    }

    private void createCore() throws ESBException {
        try {
            List<URL> extendedBPELactivitiesURL;
            List<String> services;
            log.finest("Core Intialization...");
            ConfigurationEngineImpl conf = new ConfigurationEngineImpl();
            conf.setAutoFlushMessageFrequency(Integer.valueOf(5000));
            conf.setAutoTrashProcessFreqeuency(Integer.valueOf(5000));
            this.core = BPELFactoryImpl.getInstance().newBPELEngine((ConfigurationEngine)conf, 10, ESBReceiverImpl.class, 10, ESBSenderImpl.class, null);
            SCAHelper.getSCAHelper().addComponent(this.core.getComponent(), this.getComponent(), null);
            NodeBehaviour nodeBehaviour = (NodeBehaviour)this.getNode().findBehaviour(NodeBehaviour.class);
            Configuration confNode = nodeBehaviour.getConfiguration();
            List<String> behaviours = this.findBPELComponentBehaviours(confNode.getProperties());
            if (behaviours.size() > 0) {
                for (String beh : behaviours) {
                    try {
                        log.info("behaviour : " + beh);
                        Class<?> c = Class.forName(beh);
                        log.info("behaviour.class : " + c);
                        this.addBehaviourClass(c);
                    }
                    catch (ClassNotFoundException e) {
                        log.warning("Class not found for : " + beh + " (" + e.getMessage() + ").");
                    }
                }
            }
            if ((services = this.findCoreService(confNode.getProperties())).size() > 0) {
                for (String service : services) {
                    try {
                        this.core.getEngine().getServiceManager().addService(Class.forName(service));
                    }
                    catch (ClassNotFoundException e) {
                        log.warning("Class not found for : " + service + " (" + e.getMessage() + ").");
                    }
                }
            }
            if ((extendedBPELactivitiesURL = this.findBPELExtendedActivities(confNode.getProperties())).size() > 0) {
                ExtendedActivityService service = (ExtendedActivityService)this.core.getEngine().getServiceManager().getService(ExtendedActivityServiceImpl.class);
                for (URL extendedActivityURL : extendedBPELactivitiesURL) {
                    service.loadExtendedActivitiesConfigure(extendedActivityURL);
                }
            }
            this.core.getExternalEnvironment().setHost(nodeBehaviour.getHost());
            SoapServer soapServer = (SoapServer)nodeBehaviour.getExternalServer("soap-server");
            if (soapServer != null) {
                this.core.getExternalEnvironment().setPort(String.valueOf(soapServer.getPort()));
            }
        }
        catch (BPELException e) {
            log.severe("ERROR e : " + e.getMessage());
            e.printStackTrace();
            throw new ESBException((Throwable)e);
        }
        catch (Exception e) {
            log.severe("ERROR e : " + e.getMessage());
            e.printStackTrace();
            throw new ESBException((Throwable)e);
        }
    }

    private List<String> findBPELComponentBehaviours(Map<String, String> properties) {
        ArrayList<String> res = new ArrayList<String>();
        for (String prop : properties.keySet()) {
            if (!prop.startsWith("bpel-component-behaviour")) continue;
            res.add(properties.get(prop));
        }
        return res;
    }

    private List<String> findCoreService(Map<String, String> properties) {
        ArrayList<String> res = new ArrayList<String>();
        for (String prop : properties.keySet()) {
            if (!prop.startsWith("bpel-service")) continue;
            res.add(properties.get(prop));
        }
        return res;
    }

    private List<URL> findBPELExtendedActivities(Map<String, String> properties) {
        ArrayList<URL> res = new ArrayList<URL>();
        for (String prop : properties.keySet()) {
            if (!prop.startsWith("extended-bpel-activity")) continue;
            URL url = Thread.currentThread().getContextClassLoader().getResource(properties.get(prop));
            if (url != null) {
                res.add(url);
                continue;
            }
            log.warning("Failed to retrieve extended activity configuration file for " + prop + ".");
        }
        return res;
    }

    public Object getContext() {
        try {
            return this.getCore();
        }
        catch (ESBException e) {
            log.warning("Context not retrieved for the BPEL component. (core)");
            return null;
        }
    }
}

