/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easyesb.component.bpel.impl;

import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easybox.api.XmlObjectReadException;
import com.ebmwebsourcing.easybox.api.XmlObjectReader;
import com.ebmwebsourcing.easybpel.model.bpel.api.BPELProcess;
import com.ebmwebsourcing.easybpel.model.bpel.api.partnerLink.PartnerLink;
import com.ebmwebsourcing.easybpel.model.bpel.api.wsdlImports.Descriptions;
import com.ebmwebsourcing.easycommons.research.util.SOAException;
import com.ebmwebsourcing.easycommons.research.util.easybox.Framework;
import com.ebmwebsourcing.easycommons.research.util.easybox.SOAUtil;
import com.ebmwebsourcing.easycommons.research.util.easybox.resolver.URIMemoryMultipleResolvers;
import com.ebmwebsourcing.easycommons.research.util.esb.ESBUtil;
import com.ebmwebsourcing.easycommons.research.util.esb.EndpointAddress;
import com.ebmwebsourcing.easycommons.research.util.esb.QueryParam;
import com.ebmwebsourcing.easycommons.research.util.io.ErrorUtil;
import com.ebmwebsourcing.easycommons.research.util.jaxb.SOAJAXBContext;
import com.ebmwebsourcing.easycommons.soap.handler.SOAPException;
import com.ebmwebsourcing.easycommons.soap.handler.SOAPHandler;
import com.ebmwebsourcing.easycommons.xml.XMLPrettyPrinter;
import com.ebmwebsourcing.easyesb.component.bpel.api.BPELComponent;
import com.ebmwebsourcing.easyesb.component.bpel.api.BPELComponentBehaviour;
import com.ebmwebsourcing.easyesb.component.bpel.api.BPELProviderEndpoint;
import com.ebmwebsourcing.easyesb.component.bpel.api.BPELProviderEndpointBehaviour;
import com.ebmwebsourcing.easyesb.component.bpel.impl.BPELProviderEndpointBehaviourImpl;
import com.ebmwebsourcing.easyesb.component.bpel.impl.BPELProviderEndpointImpl;
import com.ebmwebsourcing.easyesb.component.bpel.impl.StoreResponse;
import com.ebmwebsourcing.easyesb.constant.EasyESBFramework;
import com.ebmwebsourcing.easyesb.exchange10.api.element.Exchange;
import com.ebmwebsourcing.easyesb.external.protocol.soap.impl.SOAPListenerImpl;
import com.ebmwebsourcing.easyesb.external.protocol.soap.impl.SOAPSenderImpl;
import com.ebmwebsourcing.easyesb.external.protocol.soap.impl.server.SoapServer;
import com.ebmwebsourcing.easyesb.soa.api.ESBException;
import com.ebmwebsourcing.easyesb.soa.api.component.Component;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.ClientProxyEndpoint;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.ProviderProxyEndpoint;
import com.ebmwebsourcing.easyesb.soa.api.node.NodeBehaviour;
import com.ebmwebsourcing.easyesb.soa.api.registry.RegistryEndpoint;
import com.ebmwebsourcing.easyesb.soa.api.registry.RegistryEndpointBehaviour;
import com.ebmwebsourcing.easyesb.soa.api.service.Service;
import com.ebmwebsourcing.easyesb.soa.api.service.ServiceBehaviour;
import com.ebmwebsourcing.easyesb.soa.api.util.MessageUtil;
import com.ebmwebsourcing.easyesb.soa.impl.component.AbstractComponentBehaviourImpl;
import com.ebmwebsourcing.easyesb.soa.impl.endpoint.ClientProxyEndpointImpl;
import com.ebmwebsourcing.easyesb.soa.impl.endpoint.ProviderProxyEndpointImpl;
import com.ebmwebsourcing.easyesb.soa.impl.endpoint.behaviour.specific.ClientProxyBehaviourImpl;
import com.ebmwebsourcing.easyesb.soa.impl.endpoint.behaviour.specific.ProviderProxyBehaviourImpl;
import com.ebmwebsourcing.easyesb.soa.impl.service.BusinessServiceImpl;
import com.ebmwebsourcing.easyesb.soa10.api.element.EndpointInitialContext;
import com.ebmwebsourcing.easyesb.soa10.api.element.ListenerInitialisation;
import com.ebmwebsourcing.easyesb.soa10.api.element.SenderInitialisation;
import com.ebmwebsourcing.easyesb.soa10.api.type.ComponentType;
import com.ebmwebsourcing.easyesb.soa10.api.type.ProviderEndpointType;
import com.ebmwebsourcing.easyesb.transporter.api.transport.TransportException;
import com.ebmwebsourcing.easyviper.core.api.Core;
import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.model.registry.definition.ProcessContextDefinition;
import com.ebmwebsourcing.easyviper.core.impl.model.registry.ProcessContextDefinitionImpl;
import com.ebmwebsourcing.easywsdl11.api.element.Definitions;
import easybox.esstar.petalslink.com.management.model.datatype._1.EJaxbBpelReport;
import easybox.esstar.petalslink.com.management.model.datatype._1.EJaxbDeploy;
import easybox.esstar.petalslink.com.management.model.datatype._1.EJaxbDeployResponse;
import easybox.esstar.petalslink.com.management.model.datatype._1.EJaxbDeployementReport;
import easybox.esstar.petalslink.com.management.model.datatype._1.EJaxbFault;
import easybox.esstar.petalslink.com.management.model.datatype._1.EJaxbUndeploy;
import easybox.esstar.petalslink.com.management.model.datatype._1.EJaxbUndeployResponse;
import easyesb.petalslink.com.component.bpel._1_0.BpelComponentExceptionMsg;
import easyesb.petalslink.com.component.bpel.data._1.ObjectFactory;
import easyesb.petalslink.com.component.bpel.data._1.StoreBpel;
import easyesb.petalslink.com.component.bpel.data._1.StoreBpelResponse;
import easyesb.petalslink.com.component.bpel.data._1.UnstoreBpel;
import easyesb.petalslink.com.component.bpel.data._1.UnstoreBpelResponse;
import esstar.petalslink.com.service.management._1_0.ManagementException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.transform.URIResolver;
import org.jdom.Document;
import org.jdom.input.DOMBuilder;
import org.petalslink.abslayer.Factory;
import org.petalslink.abslayer.service.api.Binding;
import org.petalslink.abslayer.service.api.Description;
import org.petalslink.abslayer.service.api.Endpoint;
import org.petalslink.abslayer.service.api.Import;
import org.petalslink.abslayer.service.api.Interface;
import org.petalslink.abslayer.service.api.PartnerLinkType;
import org.petalslink.abslayer.service.api.Role;
import org.petalslink.abslayer.service.impl.wsdl11.DescriptionImpl;

public class BPELComponentBehaviourImpl
extends AbstractComponentBehaviourImpl
implements BPELComponentBehaviour {
    private static final long serialVersionUID = 1L;
    private static Logger log = Logger.getLogger(BPELComponentBehaviourImpl.class.getName());
    private static Binding b;

    static {
        try {
            SOAJAXBContext.getInstance().addOtherObjectFactory(new Class[]{ObjectFactory.class});
        }
        catch (SOAException e) {
            e.printStackTrace();
        }
        try {
            URL url = Thread.currentThread().getContextClassLoader().getResource("wsdl/bpel-component10.wsdl");
            Description desc = (Description)Factory.getInstance().wrap(((XmlObjectReader)SOAUtil.getInstance().getReader((Framework)EasyESBFramework.getInstance()).get()).readDocument(url, Definitions.class));
            b = (Binding)desc.getBindings().iterator().next();
        }
        catch (XmlObjectReadException e) {
            e.printStackTrace();
            throw new RuntimeException();
        }
    }

    public BPELComponentBehaviourImpl(Component<? extends ComponentType> ep) {
        super(ep);
        this.setBinding(b);
    }

    public void execute(Exchange exchange) throws TransportException {
        try {
            if (exchange.getMessageIn().getBody().getPayload() == null) {
                throw new TransportException("the message in cannot be null");
            }
            DOMBuilder builder = new DOMBuilder();
            Document doc = builder.build(exchange.getMessageIn().getBody().getPayload());
            if (doc.getRootElement() != null && doc.getRootElement().getName().equals("storeBpel")) {
                log.finest("Store Bpel");
                StoreBpel storeBpelRequest = (StoreBpel)SOAJAXBContext.getInstance().marshallAnyType(exchange.getMessageIn().getBody().getPayload(), StoreBpel.class);
                List<String> eps = this.storeBpel(storeBpelRequest.getBpelUrl());
                StoreBpelResponse storeBpelResponse = new StoreBpelResponse();
                for (String ep : eps) {
                    storeBpelResponse.getBpelEndpointAddress().add(ep);
                }
                org.w3c.dom.Document docResp = SOAJAXBContext.getInstance().unmarshallAnyElement((Object)storeBpelResponse);
                MessageUtil.getInstance().createOutMessageStructure(exchange);
                exchange.getMessageOut().getBody().setPayload(docResp);
            } else if (doc.getRootElement() != null && doc.getRootElement().getName().equals("unstoreBpel")) {
                log.finest("UnStore Bpel");
                UnstoreBpel unstoreBpelRequest = (UnstoreBpel)SOAJAXBContext.getInstance().marshallAnyType(exchange.getMessageIn().getBody().getPayload(), UnstoreBpel.class);
                UnstoreBpelResponse storeBpelResponse = this.unstoreBpel(unstoreBpelRequest);
                org.w3c.dom.Document docResp = SOAJAXBContext.getInstance().unmarshallAnyElement((Object)storeBpelResponse);
                MessageUtil.getInstance().createOutMessageStructure(exchange);
                exchange.getMessageOut().getBody().setPayload(docResp);
            }
        }
        catch (BpelComponentExceptionMsg e) {
            try {
                org.w3c.dom.Document docEx = SOAJAXBContext.getInstance().unmarshallAnyElement((Object)e.getFaultInfo());
                org.w3c.dom.Document fault = SOAPHandler.createSoapFault((org.w3c.dom.Document)docEx);
                MessageUtil.getInstance().createErrorMessageStructure(exchange);
                exchange.getMessageError().getBody().setPayload(fault);
                log.severe("ERROR EX: " + XMLPrettyPrinter.prettyPrint((org.w3c.dom.Document)exchange.getMessageError().getBody().getPayload()));
            }
            catch (SOAException ex) {
                throw new TransportException((Throwable)ex);
            }
            catch (SOAPException ex) {
                throw new TransportException((Throwable)ex);
            }
        }
        catch (SOAException e) {
            throw new TransportException((Throwable)e);
        }
    }

    @Override
    public StoreResponse store(URL bpelurl) throws ESBException {
        ArrayList<ProviderEndpointType> res = new ArrayList<ProviderEndpointType>();
        QName bpelProcessQName = null;
        try {
            log.finest("store method");
            BPELComponent bpelComponent = (BPELComponent)this.getEndpoint();
            Core core = bpelComponent.getCore();
            BPELProcess definition = (BPELProcess)core.getModel().getRegistry().storeProcessDefinition(bpelurl.toURI(), (ProcessContextDefinition)new ProcessContextDefinitionImpl());
            bpelProcessQName = definition.getQName();
            ArrayList<Endpoint> endpoints = new ArrayList<Endpoint>();
            for (Interface itf : definition.getProcessInterfaces()) {
                for (Endpoint ep : definition.getImports().findEndpointsImplementingInterface(itf)) {
                    if (this.endpointNotExist(ep, endpoints)) continue;
                    endpoints.add(ep);
                }
            }
            for (Endpoint endpoint : endpoints) {
                Service service = this.createService(endpoint.getService().getQName(), BusinessServiceImpl.class);
                EndpointInitialContext context = (EndpointInitialContext)SOAUtil.getInstance().getXmlContext((Framework)EasyESBFramework.getInstance()).getXmlObjectFactory().create(EndpointInitialContext.class);
                context.setNumberOfThreads(5);
                BPELProviderEndpoint providerEndpoint = (BPELProviderEndpoint)((ServiceBehaviour)service.findBehaviour(ServiceBehaviour.class)).createProviderEndpoint(endpoint.getName(), BPELProviderEndpointImpl.class, BPELProviderEndpointBehaviourImpl.class, context, new SenderInitialisation[0]);
                providerEndpoint.setCore(core);
                BPELProviderEndpointBehaviour bpelProviderEndpointBehaviour = (BPELProviderEndpointBehaviour)providerEndpoint.findBehaviour(BPELProviderEndpointBehaviour.class);
                bpelProviderEndpointBehaviour.setBinding(endpoint.getBinding());
                providerEndpoint.refreshDescription();
                URI wsdlLocation = this.findLocationFromEndpoint(endpoint, definition);
                if (wsdlLocation == null) {
                    throw new ESBException("Wsdl location of endpoint \"" + endpoint.getName() + "\" cannot be null!!!");
                }
                providerEndpoint.setWSDLDescriptionAddress(this.createURIFromLocation(bpelurl, wsdlLocation));
                bpelProviderEndpointBehaviour.setCore(core);
                res.add((ProviderEndpointType)providerEndpoint.getModel());
            }
            ArrayList<Endpoint> partnerEndpoints = new ArrayList<Endpoint>();
            for (PartnerLink pl : definition.getPartnerLinks()) {
                Interface itf;
                Role role;
                PartnerLinkType plt;
                if (pl.getPartnerRole() == null || pl.getPartnerRole().trim().length() <= 0 || pl.getPartnerLinkType() == null || (plt = definition.getImports().getPartnerLinkType(pl.getPartnerLinkType())) == null || (role = plt.getRole(pl.getPartnerRole())) == null || (itf = role.findInterface(role.getInterfaceQName())) == null) continue;
                for (Endpoint ep : definition.getImports().findEndpointsImplementingInterface(itf)) {
                    if (partnerEndpoints.contains(ep)) continue;
                    partnerEndpoints.add(ep);
                }
            }
            RegistryEndpoint registryEndpoint = this.getEndpoint().getNode().getRegistryEndpoint();
            if (registryEndpoint == null) {
                throw new ESBException("Impossible to find registry... Impossible to store bpel: " + bpelurl);
            }
            for (Endpoint endpoint : partnerEndpoints) {
                if (((RegistryEndpointBehaviour)registryEndpoint.findBehaviour(RegistryEndpointBehaviour.class)).getEndpoint(ESBUtil.generateURI((EndpointAddress)new EndpointAddress(endpoint.getService().getQName(), endpoint.getName(), new QueryParam[0]))) != null) continue;
                Service service = ((NodeBehaviour)this.getEndpoint().getNode().findBehaviour(NodeBehaviour.class)).createService(endpoint.getService().getQName(), BusinessServiceImpl.class);
                EndpointInitialContext context = (EndpointInitialContext)SOAUtil.getInstance().getXmlContext((Framework)EasyESBFramework.getInstance()).getXmlObjectFactory().create(EndpointInitialContext.class);
                context.setNumberOfThreads(5);
                SenderInitialisation senderInit = (SenderInitialisation)SOAUtil.getInstance().getXmlContext((Framework)EasyESBFramework.getInstance()).getXmlObjectFactory().create(SenderInitialisation.class);
                senderInit.setClassName(SOAPSenderImpl.class.getName());
                senderInit.setExternalProviderAddress(endpoint.getAddress());
                ProviderProxyEndpoint providerEndpoint = (ProviderProxyEndpoint)((ServiceBehaviour)service.findBehaviour(ServiceBehaviour.class)).createProviderEndpoint(endpoint.getName(), ProviderProxyEndpointImpl.class, ProviderProxyBehaviourImpl.class, context, new SenderInitialisation[]{senderInit});
                URI wsdlLocation = this.findLocationFromEndpoint(endpoint, definition);
                if (wsdlLocation == null) {
                    throw new ESBException("Wsdl location of endpoint \"" + endpoint.getName() + "\" cannot be null!!!");
                }
                providerEndpoint.setWSDLDescriptionAddress(this.createURIFromLocation(bpelurl, wsdlLocation));
                log.finest("*************** create partner: " + providerEndpoint.getName());
            }
        }
        catch (CoreException e) {
            log.severe("ERROR e : " + e.getMessage());
            e.printStackTrace();
            throw new ESBException((Throwable)e);
        }
        catch (URISyntaxException e) {
            log.severe("ERROR e : " + e.getMessage());
            e.printStackTrace();
            throw new ESBException((Throwable)e);
        }
        catch (Exception e) {
            log.severe("ERROR +e : " + e.getMessage());
            e.printStackTrace();
            throw new ESBException((Throwable)e);
        }
        StoreResponse storeResponse = new StoreResponse(res, bpelProcessQName);
        return storeResponse;
    }

    private URI createURIFromLocation(URL bpelurl, URI location) {
        URI res = null;
        String path = bpelurl.toString().substring(0, bpelurl.toString().lastIndexOf("/") + 1);
        res = URI.create(String.valueOf(path) + location.toString());
        return res;
    }

    private URI findLocationFromEndpoint(Endpoint ep, BPELProcess def) {
        URI res = null;
        Description desc = ep.getService().getDescription();
        DescriptionImpl.setXmlContext((XmlContext)SOAUtil.getInstance().getXmlContext((Framework)EasyESBFramework.getInstance()));
        if (def != null) {
            for (com.ebmwebsourcing.easybpel.model.bpel.api.wsdlImports.Import impt : def.getImports().getBPELImports()) {
                if (impt.getDescription() == null) continue;
                Description d = impt.getDescription();
                if (impt.getNamespace().toString().equals(desc.getTargetNamespace().toString()) && d.findEndpoint(ep.getName()) != null) {
                    res = impt.getLocation();
                    break;
                }
                if (res != null) continue;
                res = this.findLocationFromEndpoint(ep, impt.getDescription());
            }
        }
        if (res == null) {
            for (com.ebmwebsourcing.easybpel.model.bpel.api.wsdlImports.Import impt : def.getImports().getBPELImports()) {
                if (!impt.getNamespace().toString().equals(desc.getTargetNamespace().toString())) continue;
                res = impt.getLocation();
                break;
            }
        }
        return res;
    }

    private URI findLocationFromEndpoint(Endpoint ep, Description parentDescription) {
        URI res = null;
        Description desc = ep.getService().getDescription();
        DescriptionImpl.setXmlContext((XmlContext)SOAUtil.getInstance().getXmlContext((Framework)EasyESBFramework.getInstance()));
        for (Import impt : parentDescription.getImports()) {
            if (impt.getNamespace().equals(desc.getTargetNamespace())) {
                res = URI.create(impt.getLocation());
                break;
            }
            if (res != null || impt.getImportDescription() == null) continue;
            res = this.findLocationFromEndpoint(ep, impt.getImportDescription());
        }
        return res;
    }

    private boolean endpointNotExist(Endpoint ep, List<Endpoint> endpoints) {
        boolean res = false;
        for (Endpoint tmp : endpoints) {
            if (!tmp.getName().equals(ep.getName()) || !tmp.getService().getQName().getNamespaceURI().equals(ep.getService().getQName().getNamespaceURI()) || !tmp.getService().getQName().getLocalPart().equals(ep.getService().getQName().getLocalPart())) continue;
            res = true;
            break;
        }
        return res;
    }

    @Override
    public List<ProviderEndpointType> unstore(URL bpel) throws ESBException {
        throw new ESBException("NotImplememented");
    }

    public UnstoreBpelResponse unstoreBpel(UnstoreBpel parameters) throws BpelComponentExceptionMsg {
        UnstoreBpelResponse res = new UnstoreBpelResponse();
        try {
            List<ProviderEndpointType> eps = this.unstore(URI.create(parameters.getBpelUrl()).toURL());
            for (ProviderEndpointType ep : eps) {
                res.getBpelEndpointAddress().add(ep.getReference().toString());
            }
        }
        catch (MalformedURLException e) {
            throw new BpelComponentExceptionMsg("StoreBpel operation error", (Throwable)e);
        }
        catch (ESBException e) {
            throw new BpelComponentExceptionMsg("StoreBpel operation error", (Throwable)e);
        }
        return res;
    }

    public List<String> storeBpel(String bpelUrl) throws BpelComponentExceptionMsg {
        ArrayList<String> res = null;
        try {
            List<ProviderEndpointType> eps = this.store(URI.create(bpelUrl).toURL()).getEndpointList();
            res = new ArrayList<String>();
            for (ProviderEndpointType ep : eps) {
                res.add(ep.getReference().toString());
            }
        }
        catch (MalformedURLException e) {
            throw new BpelComponentExceptionMsg("StoreBpel operation error", (Throwable)e);
        }
        catch (ESBException e) {
            throw new BpelComponentExceptionMsg("StoreBpel operation error", (Throwable)e);
        }
        return res;
    }

    public EJaxbDeployResponse deploy(EJaxbDeploy deploy) throws ManagementException {
        EJaxbDeployResponse result = new EJaxbDeployResponse();
        try {
            URIMemoryMultipleResolvers resolvers = (URIMemoryMultipleResolvers)SOAUtil.getInstance().getXmlContext((Framework)EasyESBFramework.getInstance()).getURIResolver();
            SOAUtil.getInstance().getXmlContext((Framework)EasyESBFramework.getInstance()).setURIResolver((URIResolver)resolvers);
            DescriptionImpl.setXmlContext((XmlContext)SOAUtil.getInstance().getXmlContext((Framework)EasyESBFramework.getInstance()));
            Descriptions.setXmlContext((XmlContext)SOAUtil.getInstance().getXmlContext((Framework)EasyESBFramework.getInstance()));
            String bpelURL = deploy.getMainResource().getFileURI();
            if (deploy.getMainResource().getAttachment() != null) {
                throw new ManagementException("Unsupported!!! Use deploy from URL instead");
            }
            StoreResponse sr = this.store(new URL(bpelURL));
            List<ProviderEndpointType> endpoints = sr.getEndpointList();
            EJaxbBpelReport bpelReport = new EJaxbBpelReport();
            SoapServer soapServer = (SoapServer)((NodeBehaviour)this.endpoint.getNode().findBehaviour(NodeBehaviour.class)).getExternalServer(SoapServer.DEFAULT_NAME);
            for (ProviderEndpointType providerEndpointType : endpoints) {
                EndpointAddress eprP = ESBUtil.analyzeURI((URI)providerEndpointType.getReference());
                QName clientName = new QName(eprP.getNamespace(), String.valueOf(eprP.getEndpointname()) + "_proxy");
                EndpointInitialContext context = (EndpointInitialContext)SOAUtil.getInstance().getXmlContext((Framework)EasyESBFramework.getInstance()).getXmlObjectFactory().create(EndpointInitialContext.class);
                context.setNumberOfThreads(5);
                ListenerInitialisation listenerInit = (ListenerInitialisation)SOAUtil.getInstance().getXmlContext((Framework)EasyESBFramework.getInstance()).getXmlObjectFactory().create(ListenerInitialisation.class);
                listenerInit.setClassName(SOAPListenerImpl.class.getName());
                listenerInit.setServerName(SoapServer.DEFAULT_NAME);
                ClientProxyEndpoint proxyClientEndpoint = (ClientProxyEndpoint)((NodeBehaviour)this.endpoint.getNode().findBehaviour(NodeBehaviour.class)).createClientEndpoint(clientName, ClientProxyEndpointImpl.class, ClientProxyBehaviourImpl.class, context, new ListenerInitialisation[]{listenerInit});
                proxyClientEndpoint.addBehaviourClass(ClientProxyBehaviourImpl.class);
                proxyClientEndpoint.setProviderServiceName(endpoints.get(0).getServiceName());
                EndpointAddress epr = ESBUtil.analyzeURI((URI)endpoints.get(0).getReference());
                proxyClientEndpoint.setProviderEndpointName(epr.getEndpointname());
                bpelReport.getExternalEndpointsAddressesCreated().add(proxyClientEndpoint.getExternalListeners()[0].getExposedAddress());
            }
            EJaxbDeployementReport deploymentReport = new EJaxbDeployementReport();
            deploymentReport.setAny((Object)bpelReport);
            deploymentReport.setID(sr.getBpelProcessQName().toString());
            result.setDeployementReport(deploymentReport);
        }
        catch (Exception e) {
            log.severe(e.getMessage());
            EJaxbFault f = new EJaxbFault();
            f.setMessage(e.getMessage());
            f.setStacktrace(ErrorUtil.printStackTrace((Throwable)e));
            ManagementException resourcesFault = new ManagementException(e.getMessage(), f);
            throw resourcesFault;
        }
        return result;
    }

    public List<String> getSupportedResourcesExtensions() {
        ArrayList<String> res = new ArrayList<String>();
        res.add("bpel");
        return res;
    }

    public void start() throws ESBException {
    }

    public void stop() throws ESBException {
    }

    public EJaxbUndeployResponse undeploy(EJaxbUndeploy parameters) throws ManagementException {
        throw new UnsupportedOperationException();
    }
}

