/*******************************************************************************
 * Copyright (c) 2011 EBM Websourcing.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v2.1
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * 
 * Contributors:
 *     EBM Websourcing - initial API and implementation
 ******************************************************************************/
package com.ebmwebsourcing.easyesb.resources.interceptor.initialization;


import javax.xml.namespace.QName;

import org.w3c.dom.Document;

import com.ebmwebsourcing.easycommons.research.util.SOAException;
import com.ebmwebsourcing.easycommons.research.util.esb.ESBUtil;
import com.ebmwebsourcing.easycommons.research.util.esb.EndpointAddress;
import com.ebmwebsourcing.easycommons.research.util.jaxb.SOAJAXBContext;
import com.ebmwebsourcing.easyesb.soa.api.ESBException;
import com.ebmwebsourcing.easyesb.soa.api.config.Configuration;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.Endpoint;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.ProviderEndpoint;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.behaviour.specific.NotificationProducerEndpointBehaviour;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.behaviour.specific.SubscriptionManagerEndpointBehaviour;
import com.ebmwebsourcing.easyesb.soa.api.interceptors.AbstractEndpointInitializationInterceptor;
import com.ebmwebsourcing.easyesb.soa.api.interceptors.EndpointInitializationInterceptor;
import com.ebmwebsourcing.easyesb.soa.api.node.NodeBehaviour;
import com.ebmwebsourcing.easyesb.soa.api.registry.RegistryEndpointBehaviour;
import com.ebmwebsourcing.easyesb.soa.impl.endpoint.behaviour.specific.NotificationProducerEndpointBehaviourImpl;
import com.ebmwebsourcing.easyesb.soa.impl.endpoint.behaviour.specific.SubscriptionManagerEndpointBehaviourImpl;
import com.ebmwebsourcing.easyesb.soa.impl.endpoint.thread.NotificationProducerThreadImpl;

import easybox.esstar.petalslink.com.management.model.datatype._1.EJaxbResourceIdentifier;

public class CreationInitializationResourcesInterceptor extends AbstractEndpointInitializationInterceptor implements EndpointInitializationInterceptor {


	public CreationInitializationResourcesInterceptor(Endpoint ep) {
		super(ep);
	}


	public void processingCreation() throws ESBException {

		Configuration conf = ((NodeBehaviour)this.endpoint.getNode().findBehaviour(NodeBehaviour.class)).getConfiguration();
		try {
			// Create resourceIdentifier
			if(this.endpoint instanceof ProviderEndpoint) {
				EJaxbResourceIdentifier rid = new EJaxbResourceIdentifier();
				String serviceName = null;
				if(this.endpoint instanceof ProviderEndpoint && ((ProviderEndpoint)this.endpoint).getServiceProvider() != null) {
					serviceName = ((ProviderEndpoint)this.endpoint).getServiceProvider().getQName().getLocalPart();
				}
				
				rid.setId(ESBUtil.generateURI(new EndpointAddress(this.endpoint.getQName().getNamespaceURI(), serviceName, this.endpoint.getQName().getLocalPart())).toString());
				rid.setResourceType("endpoint");

				Document notifPayload = SOAJAXBContext.getInstance().unmarshallAnyElement(rid);

				QName topicUsed = new QName("http://www.petalslink.org/resources/event/1.0", "CreationResourcesTopic","tns");
				String dialect = "http://docs.oasis-open.org/wsn/t-1/TopicExpression/Concrete";

				RegistryEndpointBehaviour registry = (RegistryEndpointBehaviour) this.endpoint.getNode().getRegistryEndpoint().findBehaviour(RegistryEndpointBehaviour.class);

				QName creationResourcesEndpointName = new QName(this.endpoint.getNode().getQName().getNamespaceURI(), "creationResourcesEndpoint_" + this.endpoint.getNode().getQName().getLocalPart());
				ProviderEndpoint creationResourcesEndpoint = (ProviderEndpoint) registry.getLocalEndpoint(creationResourcesEndpointName);

				if(!creationResourcesEndpointName.equals(this.endpoint.getQName())) {

					if(creationResourcesEndpoint == null) {
						throw new ESBException("Impossible to find " + creationResourcesEndpointName + " when creating " + this.endpoint.getQName()); 
					}

					NotificationProducerEndpointBehaviour producerBehaviour = (NotificationProducerEndpointBehaviour) creationResourcesEndpoint.findBehaviour(NotificationProducerEndpointBehaviourImpl.class);
					if(producerBehaviour == null) {
						throw new ESBException("Internal Error: This endpoint " + this.endpoint.getQName() + " has no producer behaviour to send notification");

					}
					SubscriptionManagerEndpointBehaviour subscriptionManagerBehaviour = (SubscriptionManagerEndpointBehaviour) creationResourcesEndpoint.findBehaviour(SubscriptionManagerEndpointBehaviourImpl.class);
					if(subscriptionManagerBehaviour == null) {
						throw new ESBException("Internal Error: This endpoint " + this.endpoint.getQName() + " has no producer behaviour to send notification");

					}

					final NotificationProducerThreadImpl notifier = new NotificationProducerThreadImpl(
							producerBehaviour, subscriptionManagerBehaviour, notifPayload, topicUsed, dialect);
					notifier.start();
				}
			}
		} catch (SOAException e) {
			throw new ESBException(e);
		}
	}

}
