/*******************************************************************************
 * Copyright (c) 2011 EBM Websourcing.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v2.1
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * 
 * Contributors:
 *     EBM Websourcing - initial API and implementation
 ******************************************************************************/
package com.ebmwebsourcing.easyesb.esb.impl;

import java.util.logging.Logger;

import javax.xml.namespace.QName;

import com.ebmwebsourcing.easyesb.component.bpel.BpelComponentExtensionFactory;
import com.ebmwebsourcing.easyesb.esb.api.ESBFactory;
import com.ebmwebsourcing.easyesb.external.protocol.soap.impl.server.SoapServer;
import com.ebmwebsourcing.easyesb.external.protocol.soap.impl.server.SoapServerConfig;
import com.ebmwebsourcing.easyesb.rawreport.RawReportExtensionFactory;
import com.ebmwebsourcing.easyesb.resources.CreationResourcesExtensionFactory;
import com.ebmwebsourcing.easyesb.soa.ESBKernelFactoryImpl;
import com.ebmwebsourcing.easyesb.soa.api.ESBException;
import com.ebmwebsourcing.easyesb.soa.api.config.Configuration;
import com.ebmwebsourcing.easyesb.soa.api.node.Node;
import com.ebmwebsourcing.easyesb.soa.api.node.NodeBehaviour;
import com.ebmwebsourcing.easyesb.technical.service.admin.api.endpoint.AdminEndpoint;
import com.ebmwebsourcing.easyesb.technical.service.admin.api.service.AdminService;
import com.ebmwebsourcing.easyesb.technical.service.admin.impl.AdminExtensionFactory;
import com.ebmwebsourcing.easyesb.technical.service.registry.RegistryServiceBehaviourImpl;
import com.ebmwebsourcing.easyesb.technical.service.registry.RegistryServiceImpl;

public class ESBFactoryImpl extends ESBKernelFactoryImpl implements ESBFactory {

	private static Logger log = Logger.getLogger(ESBFactoryImpl.class.getName());

	private AdminEndpoint<?> adminEndpoint = null;
	private AdminExtensionFactory adminFactory = null;


	public Node createNode(QName name, Configuration conf) throws ESBException {

		Node node = createDefaultNode(name, conf);

		this.addSpecificElements(name, node, conf);

		return node;
	}

	public Node createDefaultNode(QName name, Configuration conf)
			throws ESBException {
		// set default registry if not exist
		if(conf.getRegistryServiceClass() == null) {
			conf.setRegistryServiceClass(RegistryServiceImpl.class);
		}
		if(conf.getRegistryServiceBehaviourClass() == null) {
			conf.setRegistryServiceBehaviourClass(RegistryServiceBehaviourImpl.class);
		}

		Node node = super.createNode(name, conf);
		
		// Add soap listener
		if(conf.getProperties().get(Configuration.SOAP_EXTERNAL_PORT) != null) {
			log.finest("conf.getProperties().get(Configuration.SOAP_EXTERNAL_PORT) = " + conf.getProperties().get(Configuration.SOAP_EXTERNAL_PORT));
			((NodeBehaviour)node.findBehaviour(NodeBehaviour.class)).addExternalServer(new SoapServer(new SoapServerConfig(Integer.valueOf(conf.getProperties().get(Configuration.SOAP_EXTERNAL_PORT)))));
		}

		adminFactory = new AdminExtensionFactory();
		adminFactory.addSpecificElements(name, node, conf);
		this.adminEndpoint = adminFactory.getAdminEndpoint();
		

		
		
		return node;
	}

	public void addSpecificElements(QName name, Node node, Configuration conf) throws ESBException {
		
		
		new BpelComponentExtensionFactory().addSpecificElements(name, node, conf);
		new CreationResourcesExtensionFactory().addSpecificElements(name, node, conf); 
		new RawReportExtensionFactory().addSpecificElements(name, node, conf); 



		
		
		adminFactory.exposeAdminService(node);
	}

	@Override
	public AdminEndpoint<?> getAdminEndpoint() {
		return this.adminEndpoint;
	}





}
