/*******************************************************************************
 * Copyright (c) 2011 EBM Websourcing.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v2.1
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * 
 * Contributors:
 *     EBM Websourcing - initial API and implementation
 ******************************************************************************/
package com.ebmwebsourcing.easyesb.exchange10.api.util;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;

import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;

import org.w3c.dom.Document;

import com.ebmwebsourcing.easybox.api.XmlObjectValidationException;

public class Util {

	
	public static InputStream convertDocumentToInputStream(Document doc)
	throws XmlObjectValidationException {
		InputStream inputStream = null;
		try {
			DOMSource source = new DOMSource(doc);   
			StringWriter xmlAsWriter = new StringWriter();   
			StreamResult result = new StreamResult(xmlAsWriter);   

			TransformerFactory.newInstance().newTransformer().transform(source, result);
			// write changes   
			inputStream = new ByteArrayInputStream(xmlAsWriter.toString().getBytes("UTF-8"));  

		} catch (TransformerConfigurationException e) {
			throw new XmlObjectValidationException(e.getMessage(), e);
		} catch (TransformerException e) {
			throw new XmlObjectValidationException(e.getMessage(), e);
		} catch (TransformerFactoryConfigurationError e) {
			throw new XmlObjectValidationException(e.getMessage(), e);
		} catch (UnsupportedEncodingException e) {
			throw new XmlObjectValidationException(e.getMessage(), e);
		}
		return inputStream;
	}
}
