/*******************************************************************************
 * Copyright (c) 2011 EBM Websourcing.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v2.1
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * 
 * Contributors:
 *     EBM Websourcing - initial API and implementation
 ******************************************************************************/
package com.ebmwebsourcing.easyesb.exchange10.impl;



import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easybox.impl.AbstractJaxbXmlObjectImpl;
import com.ebmwebsourcing.easyesb.exchange10.api.type.BodyType;

import easybox.easyesb.ebmwebsourcing.com.exchange._1.EJaxbBodyType;


class BodyTypeImpl extends AbstractJaxbXmlObjectImpl<EJaxbBodyType> implements
BodyType {

	protected BodyTypeImpl(XmlContext xmlContext, EJaxbBodyType jaxbModel) {
		super(xmlContext, jaxbModel);
	}


	@Override
	protected Class<? extends EJaxbBodyType> getCompliantModelClass() {
		return EJaxbBodyType.class;
	}


	@Override
	public Document getPayload() {
		Document doc = null;
		if(this.getModelObject().getAny() != null) {
			doc = ((Element)this.getModelObject().getAny()).getOwnerDocument();
		}
		return doc;
	}


	@Override
	public void setPayload(Document doc) {
		if(doc != null) {
			this.getModelObject().setAny(doc.getDocumentElement());
		} else {
			this.getModelObject().setAny(null);
		}
	}


	@Override
	public boolean hasPayload() {
		return this.getPayload() != null;
	}




}
