/*******************************************************************************
 * Copyright (c) 2011 EBM Websourcing.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v2.1
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * 
 * Contributors:
 *     EBM Websourcing - initial API and implementation
 ******************************************************************************/
package com.ebmwebsourcing.easyesb.external.protocol.soap.impl;

import java.util.logging.Logger;

import org.w3c.dom.Document;

import com.ebmwebsourcing.easycommons.soap.handler.SOAPException;
import com.ebmwebsourcing.easycommons.soap.handler.SOAPSender;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.external.ExternalSender;
import com.ebmwebsourcing.easyesb.transporter.api.transport.TransportException;

public class SOAPSenderImpl implements ExternalSender {

	/**
	 * The logger
	 */
	private Logger log = Logger.getLogger(SOAPSenderImpl.class.getName());

	
	private SOAPSender sender = null;
	
	
	public SOAPSenderImpl() throws SOAPException {
		this.sender = new SOAPSender();
	}

	public Document sendSoapRequest(Document request, String address, String soapAction) throws TransportException {
		Document response = null;
		try {
			response = this.sender.sendSoapRequest(request, address, soapAction);
		} catch (SOAPException e) {
			throw new TransportException("Impossible to send on address: " + address + " with soapAction:" + soapAction, e);
		}
		return response;
	}


}
