/*******************************************************************************
 * Copyright (c) 2011 EBM Websourcing.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v2.1
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * 
 * Contributors:
 *     EBM Websourcing - initial API and implementation
 ******************************************************************************/
package com.ebmwebsourcing.easyesb.external.protocol.soap.impl.behaviour.proxy;

import java.util.List;
import java.util.logging.Logger;

import javax.xml.namespace.QName;

import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.input.DOMBuilder;
import org.jdom.output.DOMOutputter;
import org.petalslink.abslayer.service.api.BindingOperation;
import org.petalslink.abslayer.service.api.Description;
import org.petalslink.abslayer.service.api.Endpoint;
import org.w3c.dom.Document;

import com.ebmwebsourcing.easycommons.research.util.easybox.SOAUtil;
import com.ebmwebsourcing.easycommons.soap.handler.SOAPException;
import com.ebmwebsourcing.easycommons.soap.handler.SOAPSender;
import com.ebmwebsourcing.easyesb.constant.EasyESBFramework;
import com.ebmwebsourcing.easyesb.exchange10.api.element.Body;
import com.ebmwebsourcing.easyesb.exchange10.api.element.Exchange;
import com.ebmwebsourcing.easyesb.exchange10.api.element.Header;
import com.ebmwebsourcing.easyesb.exchange10.api.element.MessageOut;
import com.ebmwebsourcing.easyesb.exchange10.api.type.PatternType;
import com.ebmwebsourcing.easyesb.soa.api.ESBException;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.ProviderProxyEndpoint;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.behaviour.AbstractEndpointBehaviourImpl;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.behaviour.specific.ProviderProxyBehaviour;
import com.ebmwebsourcing.easyesb.soa.api.util.MessageUtil;
import com.ebmwebsourcing.easyesb.transporter.api.transport.TransportException;
import com.ebmwebsourcing.soapbinding11.api.SoapBindingHelper;



public class SoapProviderProxyBehaviourImpl extends AbstractEndpointBehaviourImpl implements ProviderProxyBehaviour {

	private static Logger log = Logger.getLogger(SoapProviderProxyBehaviourImpl.class.getName());



	public SoapProviderProxyBehaviourImpl(ProviderProxyEndpoint ep) throws SOAPException {
		super(ep);
	}


	public void execute(Exchange exchange) throws TransportException {
		try {
			this.sendExchange2ExternalProviderEndpoint(exchange);
		} catch (TransportException e) {
			log.severe("Impossiblle to send message to: " + ((ProviderProxyEndpoint)this.endpoint).getExternalAddress() + "\nendpoint: " + ((ProviderProxyEndpoint)this.endpoint).getQName() +"\nDescription:" + endpoint.getDescription().getDocumentBaseURI());
			throw new TransportException(e);
		}
	}


	public Exchange sendExchange2ExternalProviderEndpoint(Exchange exchange)
	throws TransportException {
		try {

			Document request = SOAPSender.createSOAPMessageRequest(exchange.getMessageIn().getBody().getPayload());
			String soapAction = findSoapAction(this.getEndpoint().getDescription(), exchange);
			
			SOAPSender sender = new SOAPSender();
			Document response = sender.sendSoapRequest(request, ((ProviderProxyEndpoint)this.endpoint).getExternalAddress(), soapAction);

			if(exchange.getPattern().equals(PatternType.IN_OUT)) {
				this.setExchangeFromSoapResponse(exchange, response);
			}
		} catch (UnsupportedOperationException e) {
			log.severe("Impossiblle to send message to: " + ((ProviderProxyEndpoint)this.endpoint).getExternalAddress());
			throw new TransportException(e);
		} catch (ESBException e) {
			log.severe("Impossiblle to send message to: " + ((ProviderProxyEndpoint)this.endpoint).getExternalAddress());
			throw new TransportException(e);
		} catch (JDOMException e) {
			log.severe("Impossiblle to send message to: " + ((ProviderProxyEndpoint)this.endpoint).getExternalAddress());
			throw new TransportException(e);
		} catch (SOAPException e) {
			log.severe("Impossiblle to send message to: " + ((ProviderProxyEndpoint)this.endpoint).getExternalAddress());
			throw new TransportException(e);
		}
		return exchange;
	}

	private String findSoapAction(Description description, Exchange exchange) throws ESBException {
		String soapAction = null;
		
		List<Endpoint> eps =  description.findEndpointsImplementingInterface(description.findInterface(exchange.getInterfaceName()));
		if(eps.size() != 1) {
			throw new ESBException("Impossible to find endpoint corresponding to this interface: " + exchange.getInterfaceName());
		}
		BindingOperation bop = eps.get(0).getBinding().getOperationByName(QName.valueOf(exchange.getOperation()).getLocalPart());
		soapAction = SoapBindingHelper.getSoapOperation((com.ebmwebsourcing.easywsdl11.api.element.BindingOperation)bop.getModel()).getSoapAction();
		
		return soapAction;
	}


	private void setExchangeFromSoapResponse(Exchange exchange, Document soapResponse) throws ESBException {
		try {

			DOMBuilder builder = new DOMBuilder();
			org.jdom.Document soapResp = builder.build(soapResponse);

			if(exchange.getMessageOut() == null) {
				MessageOut msgOut = SOAUtil.getInstance().getXmlContext(EasyESBFramework.getInstance()).getXmlObjectFactory().create(MessageOut.class);
				exchange.setMessageOut(msgOut);
			}
			
			
			// set the header
			DOMOutputter converter = new DOMOutputter();
			List<Element> headers = soapResp.getRootElement().getChildren("Header", Namespace.getNamespace("http://schemas.xmlsoap.org/soap/envelope/") );
			if((headers != null)&&(headers.size() == 1)) {
				if(exchange.getMessageOut().getHeader() == null) {
					Header headerE = SOAUtil.getInstance().getXmlContext(EasyESBFramework.getInstance()).getXmlObjectFactory().create(Header.class);
					exchange.getMessageOut().setHeader(headerE);
				}
				for(Element elmt: headers) {
					org.w3c.dom.Document domHeader = converter.output(new org.jdom.Document((Element) elmt.detach()));
					exchange.getMessageOut().getHeader().addProperty(domHeader);
				}
			} else {
				headers = soapResp.getRootElement().getChildren("Header");
				if((headers != null)&&(headers.size() == 1)) {
					if(exchange.getMessageOut().getHeader() == null) {
						Header headerE = SOAUtil.getInstance().getXmlContext(EasyESBFramework.getInstance()).getXmlObjectFactory().create(Header.class);
						exchange.getMessageOut().setHeader(headerE);
					}
					for(Element elmt: headers) {
						org.w3c.dom.Document domHeader = converter.output(new org.jdom.Document((Element) elmt.detach()));
						exchange.getMessageOut().getHeader().addProperty(domHeader);
					}
				}
			}


			// set the body
			List<Element> bodies = soapResp.getRootElement().getChildren("Body", Namespace.getNamespace("http://schemas.xmlsoap.org/soap/envelope/") );

			if(((bodies != null)&&(bodies.size() == 1))&&(((Element) bodies.get(0)).getChildren().size() >= 1)&&
					((Element) bodies.get(0)).getChildren("Fault", Namespace.getNamespace("http://schemas.xmlsoap.org/soap/envelope/") ).size() > 0) {
				
				if(exchange.getMessageOut().getBody() == null) {
					Body bodyE = SOAUtil.getInstance().getXmlContext(EasyESBFramework.getInstance()).getXmlObjectFactory().create(Body.class);
					exchange.getMessageOut().setBody(bodyE);
				}
				
				// handle error
				Element fault = (Element) ((Element) bodies.get(0)).getChildren("Fault", Namespace.getNamespace("http://schemas.xmlsoap.org/soap/envelope/") ).get(0);
				org.w3c.dom.Document domError = converter.output(new org.jdom.Document((Element)fault.detach()));
				MessageUtil.getInstance().createErrorMessageStructure(exchange);
				exchange.getMessageError().getBody().setPayload(domError);

			} else {
				// handle payload
				if((bodies != null)&&(bodies.size() == 1)) {
					if(((Element) bodies.get(0)).getChildren().size() >= 1) {
						
						if(exchange.getMessageOut().getBody() == null) {
							Body bodyE = SOAUtil.getInstance().getXmlContext(EasyESBFramework.getInstance()).getXmlObjectFactory().create(Body.class);
							exchange.getMessageOut().setBody(bodyE);
						}
						
						org.w3c.dom.Document domBody = converter.output(new org.jdom.Document((Element)((Element) bodies.get(0).getChildren().get(0)).detach()));
						exchange.getMessageOut().getBody().setPayload(domBody);
					}
				} else {
					bodies = soapResp.getRootElement().getChildren("Body");
					if(((Element) bodies.get(0)).getChildren().size() >= 1) {
						
						if(exchange.getMessageOut().getBody() == null) {
							Body bodyE = SOAUtil.getInstance().getXmlContext(EasyESBFramework.getInstance()).getXmlObjectFactory().create(Body.class);
							exchange.getMessageOut().setBody(bodyE);
						}
						
						org.w3c.dom.Document domBody = converter.output(new org.jdom.Document((Element)((Element) bodies.get(0).getChildren().get(0)).detach()));
						exchange.getMessageOut().getBody().setPayload(domBody);
					}
				}
			}

		} catch (JDOMException e) {
			throw new ESBException(e);
		}
	}




}
