/*******************************************************************************
 * Copyright (c) 2011 EBM Websourcing.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v2.1
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * 
 * Contributors:
 *     EBM Websourcing - initial API and implementation
 ******************************************************************************/
package com.ebmwebsourcing.easyesb.rawreport.interceptor.timestamp;

import java.util.Date;
import java.util.logging.Logger;

import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

import com.ebmwebsourcing.easycommons.research.util.dom.DOMUtil;
import com.ebmwebsourcing.easycommons.research.util.easybox.SOAUtil;
import com.ebmwebsourcing.easyesb.constant.EasyESBFramework;
import com.ebmwebsourcing.easyesb.exchange10.api.element.Exchange;
import com.ebmwebsourcing.easyesb.exchange10.api.element.Header;
import com.ebmwebsourcing.easyesb.exchange10.api.element.MessageOut;
import com.ebmwebsourcing.easyesb.soa.api.util.MessageUtil;
import com.ebmwebsourcing.easyesb.transporter.api.transport.TransportException;


public class TimeStamperImpl implements TimeStamper {

	private Exchange me = null;

	private Logger log = Logger.getLogger(this.getClass().getCanonicalName());


	public TimeStamperImpl() {
	}


	public Date getDateClientIn() {
		Date res = null;
		if(this.me != null) {
			if(this.me.getMessageIn() != null && this.me.getMessageIn().getHeader() != null) {
				Document doc = this.me.getMessageIn().getHeader().getProperty(TimeStamper.DATE_CLIENT_IN_PROPERTY);
				if(doc != null && doc.getDocumentElement() != null && doc.getDocumentElement().getFirstChild() != null) {
					Long dateClientIn = Long.parseLong(doc.getDocumentElement().getFirstChild().getNodeValue());
					if(dateClientIn != null) {
						res = new Date(dateClientIn);
					}
				}
			}
		}
		return res;
	}

	public Date getDateClientOut() {
		Date res = null;
		if(this.me != null) {
			if(this.me.getMessageOut() != null && this.me.getMessageOut().getHeader() != null) {
				Document doc = this.me.getMessageOut().getHeader().getProperty(TimeStamper.DATE_CLIENT_OUT_PROPERTY);
				if(doc != null && doc.getDocumentElement() != null && doc.getDocumentElement().getFirstChild() != null) {
					Long dateClientOut = Long.parseLong(doc.getDocumentElement().getFirstChild().getNodeValue());
					if(dateClientOut != null) {
						res = new Date(dateClientOut);
					}
				}
			}
		}
		return res;
	}

	public Date getDateProviderIn() {
		Date res = null;
		if(this.me != null) {
			if(this.me.getMessageIn() != null && this.me.getMessageIn().getHeader() != null) {
				Document doc = this.me.getMessageIn().getHeader().getProperty(DATE_PROVIDER_IN_PROPERTY);
				if(doc != null && doc.getDocumentElement() != null && doc.getDocumentElement().getFirstChild() != null) {
					Long dateProviderIn = Long.parseLong(doc.getDocumentElement().getFirstChild().getNodeValue());
					if(dateProviderIn != null) {
						res = new Date(dateProviderIn);
					}
				}
			}
		}
		return res;
	}

	public Date getDateProviderOut() {
		Date res = null;
		if(this.me != null) {
			if(this.me.getMessageOut() != null && this.me.getMessageOut().getHeader() != null) {
				Document doc = this.me.getMessageOut().getHeader().getProperty(DATE_PROVIDER_OUT_PROPERTY);
				if(doc != null && doc.getDocumentElement() != null && doc.getDocumentElement().getFirstChild() != null) {
					Long dateProviderOut = Long.parseLong(doc.getDocumentElement().getFirstChild().getNodeValue());
					if(dateProviderOut != null) {
						res = new Date(dateProviderOut);
					}
				}
			}
		}
		return res;
	}

	public void setDateClientIn(Date date) throws TransportException {
		if(this.me != null) {
			synchronized(this.me) {
				if(this.me.getMessageIn().getHeader() == null) {
					Header header = SOAUtil.getInstance().getXmlContext(EasyESBFramework.getInstance()).getXmlObjectFactory().create(Header.class);
					header.getProperties();
					this.me.getMessageIn().setHeader(header);

				}
				if(date != null) {
					Document doc = this.createTimeStampProperty(TimeStamper.DATE_CLIENT_IN_PROPERTY, new Long(date.getTime()));
					this.me.getMessageIn().getHeader().addProperty(doc);
				} else {
					Document doc = this.createTimeStampProperty(TimeStamper.DATE_CLIENT_IN_PROPERTY, null);
					this.me.getMessageIn().getHeader().addProperty(doc);
				}
			}
		}
	}


	public void setDateClientOut(Date date) throws TransportException {
		if(this.me != null) {
			synchronized(this.me) {
				if(this.me.getMessageOut() == null) {
					MessageOut msgOut = SOAUtil.getInstance().getXmlContext(EasyESBFramework.getInstance()).getXmlObjectFactory().create(MessageOut.class);
					this.me.setMessageOut(msgOut);
				}
				if(this.me.getMessageOut().getHeader() == null) {
					Header header = SOAUtil.getInstance().getXmlContext(EasyESBFramework.getInstance()).getXmlObjectFactory().create(Header.class);
					this.me.getMessageOut().setHeader(header);
					this.me.getMessageOut().getHeader().getProperties();
				}
				if(date != null) {
					Document doc = this.createTimeStampProperty(TimeStamper.DATE_CLIENT_OUT_PROPERTY, new Long(date.getTime()));
					this.me.getMessageOut().getHeader().addProperty(doc);
				} else {
					Document doc = this.createTimeStampProperty(TimeStamper.DATE_CLIENT_OUT_PROPERTY, null);
					this.me.getMessageOut().getHeader().addProperty(doc);
				}
			}
		}
	}

	public void setDateProviderIn(Date date) throws TransportException {
		if(this.me != null) {
			synchronized(this.me) {
				if(this.me.getMessageIn().getHeader() == null) {
					Header header = SOAUtil.getInstance().getXmlContext(EasyESBFramework.getInstance()).getXmlObjectFactory().create(Header.class);
					this.me.getMessageIn().setHeader(header);
					this.me.getMessageIn().getHeader().getProperties();
				}
				if(date != null) {
					Document doc = this.createTimeStampProperty(TimeStamper.DATE_PROVIDER_IN_PROPERTY, new Long(date.getTime()));
					this.me.getMessageIn().getHeader().addProperty(doc);
				} else {
					Document doc = this.createTimeStampProperty(TimeStamper.DATE_PROVIDER_IN_PROPERTY, null);
					this.me.getMessageIn().getHeader().addProperty(doc);
				}
			}
		}
	}

	public void setDateProviderOut(Date date) throws TransportException {
		if(this.me != null) {
			synchronized(this.me) {
				if(this.me.getMessageOut() == null) {
					MessageOut msgOut = SOAUtil.getInstance().getXmlContext(EasyESBFramework.getInstance()).getXmlObjectFactory().create(MessageOut.class);
					this.me.setMessageOut(msgOut);
				}
				if(this.me.getMessageOut().getHeader() == null) {
					Header header = SOAUtil.getInstance().getXmlContext(EasyESBFramework.getInstance()).getXmlObjectFactory().create(Header.class);
					this.me.getMessageOut().setHeader(header);
					this.me.getMessageOut().getHeader().getProperties();
					if(header == null){
						this.log.severe("Header was null, was generated but still null !! ");
					}
				}

				if(date != null) {
					Document doc = this.createTimeStampProperty(TimeStamper.DATE_PROVIDER_OUT_PROPERTY, new Long(date.getTime()));
					this.me.getMessageOut().getHeader().addProperty(doc);
				} else {
					Document doc = this.createTimeStampProperty(TimeStamper.DATE_PROVIDER_OUT_PROPERTY, null);
					this.me.getMessageOut().getHeader().addProperty(doc);
				}
			}
		}
	}

	public Exchange getExchange() {
		return me;
	}


	public void setExchange(Exchange me) {
		this.me = me;
	}


	private Document createTimeStampProperty(QName qName, Long value) throws TransportException {
		Document res = null;
		try {
			res = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
			Element timestamp = res.createElementNS(qName.getNamespaceURI(), qName.getLocalPart());
			Text txt = res.createTextNode(value.toString());
			timestamp.appendChild(txt);
			res.appendChild(timestamp);
		} catch (ParserConfigurationException e) {
			throw new TransportException(e);
		} 

		return res;
	}

}
