/*******************************************************************************
 * Copyright (c) 2011 EBM Websourcing.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v2.1
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * 
 * Contributors:
 *     EBM Websourcing - initial API and implementation
 ******************************************************************************/
package com.ebmwebsourcing.easyesb.rawreport.interceptor.timestamp;

import java.util.Date;

import javax.xml.namespace.QName;

import com.ebmwebsourcing.easyesb.exchange10.api.element.Exchange;
import com.ebmwebsourcing.easyesb.transporter.api.transport.TransportException;

public interface TimeStamper {
    
    public static final QName DATE_CLIENT_IN_PROPERTY = new QName("http://petals.ow2.org/date/client/in", "timestamp-client-in");
    
    public static final QName DATE_PROVIDER_IN_PROPERTY = new QName("http://petals.ow2.org/date/provider/in", "timestamp-provider-in");
    
    public static final QName DATE_PROVIDER_OUT_PROPERTY = new QName("http://petals.ow2.org/date/provider/out", "timestamp-provider-out");
    
    public static final QName DATE_CLIENT_OUT_PROPERTY = new QName("http://petals.ow2.org/date/client/out", "timestamp-client-out");
    
    
    

    void setDateClientIn(Date date) throws TransportException;
    
    void setDateClientOut(Date date) throws TransportException;
    
    void setDateProviderIn(Date date) throws TransportException;
    
    void setDateProviderOut(Date date) throws TransportException;
    
    Date getDateClientIn();
    
    Date getDateClientOut();
    
    Date getDateProviderIn();
    
    Date getDateProviderOut();
    
    Exchange getExchange();

	void setExchange(Exchange me);
}
