/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easyesb.rawreport.interceptor.timestamp;

import com.ebmwebsourcing.easyesb.exchange10.api.element.Exchange;
import com.ebmwebsourcing.easyesb.exchange10.api.type.RoleType;
import com.ebmwebsourcing.easyesb.rawreport.interceptor.timestamp.TimeStamper;
import com.ebmwebsourcing.easyesb.rawreport.interceptor.timestamp.TimeStamperImpl;
import com.ebmwebsourcing.easyesb.transporter.api.transport.TransportException;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.logging.Logger;

public class TimeStamperHandler {
    private static Logger log = Logger.getLogger(TimeStamperHandler.class.getCanonicalName());
    private TimeStamper ts = new TimeStamperImpl();
    private static TimeStamperHandler instance = null;

    public static TimeStamperHandler getInstance() {
        if (instance == null) {
            instance = new TimeStamperHandler();
        }
        return instance;
    }

    public TimeStamper getTimeStamp(Exchange me) {
        this.ts.setExchange(me);
        return this.ts;
    }

    public static void setTimeStamp(Exchange exchange) throws TransportException {
        log.finest("setTimeStamp (1)");
        Date date = GregorianCalendar.getInstance().getTime();
        log.finest("Date to be put in report : " + date.toString() + " for exchange " + exchange.getUuid());
        if (RoleType.CONSUMER.equals((Object)exchange.getRole())) {
            log.finest("setTimeStamp (2) CONSUMER");
            if (TimeStamperHandler.getInstance().getTimeStamp(exchange).getDateClientIn() == null) {
                log.finest("setTimeStamp (3) CONSUMER client-in");
                TimeStamperHandler.getInstance().getTimeStamp(exchange).setDateClientIn(date);
            } else if (TimeStamperHandler.getInstance().getTimeStamp(exchange).getDateClientOut() == null) {
                log.finest("setTimeStamp (3) CONSUMER client-out");
                TimeStamperHandler.getInstance().getTimeStamp(exchange).setDateClientOut(date);
            }
        }
        if (RoleType.PROVIDER.equals((Object)exchange.getRole())) {
            log.finest("setTimeStamp (2) PROVIDER");
            if (TimeStamperHandler.getInstance().getTimeStamp(exchange).getDateProviderIn() == null) {
                log.finest("setTimeStamp (3) PROVIDER provider-in");
                TimeStamperHandler.getInstance().getTimeStamp(exchange).setDateProviderIn(date);
            } else if (TimeStamperHandler.getInstance().getTimeStamp(exchange).getDateProviderOut() == null) {
                log.finest("setTimeStamp (3) PROVIDER provider-out");
                TimeStamperHandler.getInstance().getTimeStamp(exchange).setDateProviderOut(date);
            }
        }
    }
}

