package com.ebmwebsourcing.easyesb.rawreport;

import java.util.logging.Logger;

import javax.xml.namespace.QName;

import com.ebmwebsourcing.easycommons.research.util.easybox.SOAUtil;
import com.ebmwebsourcing.easyesb.constant.EasyESBFramework;
import com.ebmwebsourcing.easyesb.external.protocol.soap.impl.server.SoapServer;
import com.ebmwebsourcing.easyesb.rawreport.endpoint.RawReportSubscriptionEndpoint;
import com.ebmwebsourcing.easyesb.rawreport.interceptor.initialization.RawReportIntializationInterceptor;
import com.ebmwebsourcing.easyesb.rawreport.service.RawReportSubscriptionServiceBehaviour;
import com.ebmwebsourcing.easyesb.rawreport.service.RawReportSubscriptionServiceBehaviourImpl;
import com.ebmwebsourcing.easyesb.rawreport.service.RawReportSubscriptionServiceImpl;
import com.ebmwebsourcing.easyesb.soa.api.ESBException;
import com.ebmwebsourcing.easyesb.soa.api.config.Configuration;
import com.ebmwebsourcing.easyesb.soa.api.node.Node;
import com.ebmwebsourcing.easyesb.soa.api.node.NodeBehaviour;
import com.ebmwebsourcing.easyesb.soa.api.registry.RegistryEndpointBehaviour;
import com.ebmwebsourcing.easyesb.soa.api.registry.RegistryServiceBehaviour;
import com.ebmwebsourcing.easyesb.soa.api.service.Service;
import com.ebmwebsourcing.easyesb.soa10.api.element.BehavioursList;
import com.ebmwebsourcing.easyesb.soa10.api.element.EndpointInitialContext;
import com.ebmwebsourcing.easyesb.soa10.api.element.ProviderEndpointsGroupList;
import com.ebmwebsourcing.easyesb.soa10.api.element.TechnicalService;
import com.ebmwebsourcing.easyesb.soa10.api.type.EndpointInitialContextType;
import com.ebmwebsourcing.easyesb.soa10.api.type.TechnicalServiceType;

import easybox.easyesb.petalslink.com.soa.model.datatype._1.EJaxbEndpointType;
import easyesb.ebmwebsourcing.com.soa.model.registry.RegistryFault_Exception;

public class RawReportExtensionFactory {

	private static Logger log = Logger.getLogger(RawReportExtensionFactory.class.getName());
	
	private RawReportSubscriptionEndpoint<?> rawReportEndpoint = null;
	
	public void addSpecificElements(QName name, Node node, Configuration conf) throws ESBException {

		// create rawreport service
		EndpointInitialContextType context = SOAUtil.getInstance().getXmlContext(EasyESBFramework.getInstance()).getXmlObjectFactory().create(EndpointInitialContext.class);
		context.setNumberOfThreads(5);
		Service rawReportService = this.createRawReportService(node, name.getLocalPart() + "_rawreport", conf, context);

		
		this.rawReportEndpoint = ((RawReportSubscriptionServiceBehaviour)rawReportService.findBehaviour(RawReportSubscriptionServiceBehaviour.class)).getRawReportSubscriptionEndpoint();


		
		SoapServer soapServer = (SoapServer) ((NodeBehaviour)node.findBehaviour(NodeBehaviour.class)).getExternalServer("soap-server");
		if(soapServer == null) {
			throw new ESBException("Soap server cannot be null");
		}

		
		// Add resources interceptor on endpoint 
		conf.addEndpointInitializationInterceptorClassName(RawReportIntializationInterceptor.class.getName());
		
	}

	public Service createRawReportService(Node node, String name, Configuration conf, EndpointInitialContextType context) throws ESBException {
		Service rawReportService = null;
		try {

			// create model
			TechnicalService model = SOAUtil.getInstance().getXmlContext(EasyESBFramework.getInstance()).getXmlObjectFactory().create(TechnicalService.class);

			((TechnicalServiceType)model).setComponentParent(node.getQName());

			model.setBehavioursList(SOAUtil.getInstance().getXmlContext(EasyESBFramework.getInstance()).getXmlObjectFactory().create(BehavioursList.class));
			model.getBehavioursList().addBehaviour(RawReportSubscriptionServiceBehaviourImpl.class.getName());
			model.setType(RawReportSubscriptionServiceImpl.class.getName());
			model.setEndpointInitialContext(SOAUtil.getInstance().getXmlContext(EasyESBFramework.getInstance()).getXmlObjectFactory().create(EndpointInitialContext.class));

			model.setName(new QName(node.getQName().getNamespaceURI(),name));

			model.setNode(node.getQName());
			model.setBasicNodeInformations(node.getModel().getBasicNodeInformations());

			model.setProviderEndpointsGroupList(SOAUtil.getInstance().getXmlContext(EasyESBFramework.getInstance()).getXmlObjectFactory().create(ProviderEndpointsGroupList.class));

			
			// add service in registry
			boolean res = ((RegistryEndpointBehaviour)((RegistryServiceBehaviour)((NodeBehaviour)node.findBehaviour(NodeBehaviour.class)).getRegistryService().findBehaviour(RegistryServiceBehaviour.class)).getRegistryEndpoint().findBehaviour(RegistryEndpointBehaviour.class)).addEndpoint((EJaxbEndpointType) model.getModelObject());

			if(res) {
				// get component
				rawReportService = (Service) ((RegistryEndpointBehaviour) ((RegistryServiceBehaviour)((NodeBehaviour)node.findBehaviour(NodeBehaviour.class)).getRegistryService().findBehaviour(RegistryServiceBehaviour.class)).getRegistryEndpoint().findBehaviour(RegistryEndpointBehaviour.class)).getLocalEndpoint(model.getName());
			}
		} catch (RegistryFault_Exception e) {
			throw new ESBException(e);
		}
		log.fine("registryService " + name + " created and started");

		// create admin endpoint
		((RawReportSubscriptionServiceBehaviour)	rawReportService.findBehaviour(RawReportSubscriptionServiceBehaviour.class)).createRawReportSubscriptionEndpoint("rawReportEndpoint_" + node.getQName().getLocalPart(), (EndpointInitialContext) context);

		return rawReportService;
	}
	
	
	public RawReportSubscriptionEndpoint<?> getRawReportSubscriptionEndpoint() {
		return this.rawReportEndpoint;
	}
}
