/*******************************************************************************
 * Copyright (c) 2011 EBM Websourcing.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v2.1
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * 
 * Contributors:
 *     EBM Websourcing - initial API and implementation
 ******************************************************************************/
package com.ebmwebsourcing.easyesb.rawreport.interceptor.report;

import java.net.URI;
import java.util.Date;
import java.util.logging.Logger;

import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;

import org.w3c.dom.Document;

import com.ebmwebsourcing.easybox.api.XmlObjectWriteException;
import com.ebmwebsourcing.easycommons.research.util.SOAException;
import com.ebmwebsourcing.easycommons.research.util.dom.DOMUtil;
import com.ebmwebsourcing.easycommons.research.util.easybox.SOAUtil;
import com.ebmwebsourcing.easycommons.research.util.esb.ESBUtil;
import com.ebmwebsourcing.easycommons.research.util.esb.EndpointAddress;
import com.ebmwebsourcing.easycommons.xml.XMLPrettyPrinter;
import com.ebmwebsourcing.easyesb.constant.EasyESBFramework;
import com.ebmwebsourcing.easyesb.exchange10.api.element.Exchange;
import com.ebmwebsourcing.easyesb.exchange10.api.type.PatternType;
import com.ebmwebsourcing.easyesb.exchange10.api.type.RoleType;
import com.ebmwebsourcing.easyesb.rawreport.endpoint.RawReportSubscriptionEndpoint;
import com.ebmwebsourcing.easyesb.rawreport.interceptor.timestamp.TimeStamperHandler;
import com.ebmwebsourcing.easyesb.rawreport.service.RawReportSubscriptionServiceBehaviour;
import com.ebmwebsourcing.easyesb.rawreport10.api.element.Report;
import com.ebmwebsourcing.easyesb.rawreport10.api.element.ReportList;
import com.ebmwebsourcing.easyesb.rawreport10.api.type.TimeStampType;
import com.ebmwebsourcing.easyesb.soa.api.ESBException;
import com.ebmwebsourcing.easyesb.soa.api.config.Configuration;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.Endpoint;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.ProviderEndpoint;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.behaviour.specific.NotificationProducerEndpointBehaviour;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.behaviour.specific.SubscriptionManagerEndpointBehaviour;
import com.ebmwebsourcing.easyesb.soa.api.interceptors.EndpointInvocationInterceptor;
import com.ebmwebsourcing.easyesb.soa.api.node.NodeBehaviour;
import com.ebmwebsourcing.easyesb.soa.api.registry.RegistryEndpointBehaviour;
import com.ebmwebsourcing.easyesb.soa.api.registry.RegistryServiceBehaviour;
import com.ebmwebsourcing.easyesb.soa.api.service.TechnicalService;
import com.ebmwebsourcing.easyesb.soa.impl.endpoint.behaviour.specific.NotificationProducerEndpointBehaviourImpl;
import com.ebmwebsourcing.easyesb.soa.impl.endpoint.behaviour.specific.SubscriptionManagerEndpointBehaviourImpl;
import com.ebmwebsourcing.easyesb.soa.impl.endpoint.thread.NotificationProducerThreadImpl;
import com.ebmwebsourcing.easyesb.soa10.api.type.ProviderEndpointType;
import com.ebmwebsourcing.easyesb.transporter.api.transport.TransportException;

public abstract class AbstractReportInterceptor implements EndpointInvocationInterceptor {



	private static Logger log = Logger.getLogger(AbstractReportInterceptor.class.getName());

	private Endpoint endpoint;
	private Configuration conf = null;

	private RawReportSubscriptionEndpoint rawReportEndpoint;

	protected String address = null;

	public AbstractReportInterceptor(Endpoint endpoint) throws ESBException {
		this.endpoint = endpoint;
		conf = ((NodeBehaviour)this.endpoint.getNode().findBehaviour(NodeBehaviour.class)).getConfiguration();

		// find raw report subscription endpoint
		URI rawReportReference = ESBUtil.generateURI(new EndpointAddress(new QName(this.endpoint.getNode().getQName().getNamespaceURI(), this.endpoint.getNode().getQName().getLocalPart() + "_rawreport"), "rawReportEndpoint_" + this.endpoint.getNode().getQName().getLocalPart()));

		if(((NodeBehaviour)this.endpoint.getNode().findBehaviour(NodeBehaviour.class)).getRegistryService() != null) {
			rawReportEndpoint = (RawReportSubscriptionEndpoint) ((RegistryEndpointBehaviour) ((RegistryServiceBehaviour)((NodeBehaviour)this.endpoint.getNode().findBehaviour(NodeBehaviour.class)).getRegistryService().findBehaviour(RegistryServiceBehaviour.class)).getRegistryEndpoint().findBehaviour(RegistryEndpointBehaviour.class)).getLocalEndpoint(rawReportReference);
			if(rawReportEndpoint == null) {
				throw new ESBException("Impossible to find rawReport endpoint in registry: " + this.endpoint.getNode().getQName());
			}
		} else {
			TechnicalService reportService = (TechnicalService) ((NodeBehaviour)this.endpoint.getNode().findBehaviour(NodeBehaviour.class)).getService(ESBUtil.generateURI(new EndpointAddress(new QName(this.endpoint.getNode().getQName().getNamespaceURI(), this.endpoint.getNode().getQName().getLocalPart() + "_rawreport"), null)));
			rawReportEndpoint = (RawReportSubscriptionEndpoint) ((RawReportSubscriptionServiceBehaviour)reportService.findBehaviour(RawReportSubscriptionServiceBehaviour.class)).getProviderEndpoint(ESBUtil.generateURI(new EndpointAddress(new QName(this.endpoint.getNode().getQName().getNamespaceURI(), this.endpoint.getNode().getQName().getLocalPart() + "_rawreport"), "rawReportEndpoint_" + this.endpoint.getNode().getQName().getLocalPart())));
			if(rawReportEndpoint == null) {
				throw new ESBException("Impossible to find rawReport endpoint in node: " + this.endpoint.getNode().getQName());
			}
		}

	}

	protected void sendReport(ReportList reports) throws ESBException {
		try {

			// NEW METHOD USING SUBSCRIPTION

			Document notifPayload = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();

			SOAUtil.getInstance().getWriter(EasyESBFramework.getInstance()).get().writeDocument(reports, notifPayload);
			QName topicUsed = new QName("http://www.petalslink.org/rawreport/1.0", "RawReportTopic","tns");
			String dialect = "http://docs.oasis-open.org/wsn/t-1/TopicExpression/Concrete";

			NotificationProducerEndpointBehaviour producerBehaviour = (NotificationProducerEndpointBehaviour) rawReportEndpoint.findBehaviour(NotificationProducerEndpointBehaviourImpl.class);
			if(producerBehaviour == null) {
				throw new ESBException("Internal Error: This endpoint " + rawReportEndpoint.getReference() + " has no producer behaviour to send notification");

			}
			SubscriptionManagerEndpointBehaviour subscriptionManagerBehaviour = (SubscriptionManagerEndpointBehaviour) rawReportEndpoint.findBehaviour(SubscriptionManagerEndpointBehaviourImpl.class);
			if(subscriptionManagerBehaviour == null) {
				throw new ESBException("Internal Error: This endpoint " + rawReportEndpoint.getReference() + " has no producer behaviour to send notification");

			}

			final NotificationProducerThreadImpl notifier = new NotificationProducerThreadImpl(
					producerBehaviour, subscriptionManagerBehaviour, notifPayload, topicUsed, dialect);

			notifier.start();

		} catch (ParserConfigurationException e) {
			throw new ESBException(e);
		} catch (XmlObjectWriteException e) {
			throw new ESBException(e);
		}
	}



	protected ReportList createReportListFromExchangeT3T4(Exchange exchange) throws TransportException {
		ReportList res = null;

		res = SOAUtil.getInstance().getXmlContext(EasyESBFramework.getInstance()).getXmlObjectFactory().create(ReportList.class);

		// flash on request in
		if(RoleType.CONSUMER.equals(exchange.getRole())) {

			// handle done request
			if(PatternType.IN_ONLY.equals(exchange.getPattern())) {


				// create date provider out
				Report report3 = SOAUtil.getInstance().getXmlContext(EasyESBFramework.getInstance()).getXmlObjectFactory().create(Report.class);
				this.setSOACommonInformation(exchange, report3);
				Date date = null;
				date = TimeStamperHandler.getInstance().getTimeStamp(exchange).getDateProviderOut();
				if(date != null){
					report3.setDateInGMT(date);
				}else{
					log.severe("report3 failed to set timestamp ... for exchange "+exchange.getUuid());
				}
				report3.setTimeStamp(TimeStampType.t3);
				report3.setContentLength(0);
				report3.setDoesThisResponseIsAnException(false);
				res.addReport(report3);

				// create date client out
				Report report4 = SOAUtil.getInstance().getXmlContext(EasyESBFramework.getInstance()).getXmlObjectFactory().create(Report.class);
				this.setSOACommonInformation(exchange, report4);
				date = null;
				date = TimeStamperHandler.getInstance().getTimeStamp(exchange).getDateClientOut();
				if(date != null){
					report4.setDateInGMT(date);
				}else{
					log.severe("report4 failed to set timestamp ... for exchange "+exchange.getUuid());
				}
				report4.setTimeStamp(TimeStampType.t4);
				report4.setContentLength(0);
				report4.setDoesThisResponseIsAnException(false);
				res.addReport(report4);
			} 

			// handle out request
			if(PatternType.IN_OUT.equals(exchange.getPattern())) {

				// create date provider out
				Report report3 = SOAUtil.getInstance().getXmlContext(EasyESBFramework.getInstance()).getXmlObjectFactory().create(Report.class);
				this.setSOACommonInformation(exchange, report3);

				Date date = null;
				date = TimeStamperHandler.getInstance().getTimeStamp(exchange).getDateProviderOut();
				if(date != null){
					report3.setDateInGMT(date);
				}else{
					log.severe("report3 failed to set timestamp ... for exchange "+exchange.getUuid());
				}

				report3.setTimeStamp(TimeStampType.t3);

				report3.setContentLength(XMLPrettyPrinter.prettyPrint(exchange.getMessageIn().printMessage()).length());

				if(exchange.getMessageError() != null && exchange.getMessageError().getBody() != null && exchange.getMessageError().getBody().getPayload() != null) {
					report3.setDoesThisResponseIsAnException(true);
				} else {
					report3.setDoesThisResponseIsAnException(false);
				}
				res.addReport(report3);

				// create date client out
				Report report4 = SOAUtil.getInstance().getXmlContext(EasyESBFramework.getInstance()).getXmlObjectFactory().create(Report.class);
				this.setSOACommonInformation(exchange, report4);

				date = null;
				date = TimeStamperHandler.getInstance().getTimeStamp(exchange).getDateProviderOut();
				if(date != null){
					report4.setDateInGMT(date);
				}else{
					log.severe("report4 failed to set timestamp ... for exchange "+exchange.getUuid());
				}
				report4.setTimeStamp(TimeStampType.t4);
				if(exchange.getMessageOut() != null && exchange.getMessageOut().getBody() != null && exchange.getMessageOut().getBody().getPayload() != null) {
					report4.setContentLength(XMLPrettyPrinter.prettyPrint(exchange.getMessageOut().printMessage()).length());
				}else{
					report4.setContentLength(0);
				}
				if(exchange.getMessageError() != null && exchange.getMessageError().getBody() != null && exchange.getMessageError().getBody().getPayload() != null) {
					report4.setDoesThisResponseIsAnException(true);
				} else {
					report4.setDoesThisResponseIsAnException(false);
				}
				res.addReport(report4);
			}

		}


		return res;
	}

	protected ReportList createReportListFromExchangeT1T2(Exchange exchange) throws TransportException {
		ReportList res = null;

		res = SOAUtil.getInstance().getXmlContext(EasyESBFramework.getInstance()).getXmlObjectFactory().create(ReportList.class);


		// flash on request in
		if(RoleType.PROVIDER.equals(exchange.getRole())) {

			// handle done request
			if(PatternType.IN_ONLY.equals(exchange.getPattern())) {


				// create date client in
				Report report1 = SOAUtil.getInstance().getXmlContext(EasyESBFramework.getInstance()).getXmlObjectFactory().create(Report.class);
				this.setSOACommonInformation(exchange, report1);
				Date date = TimeStamperHandler.getInstance().getTimeStamp(exchange).getDateClientIn();
				if(date != null){
					report1.setDateInGMT(date);
				}else{
					log.severe("report1 failed to set timestamp ... for exchange "+exchange.getUuid());
				}

				report1.setContentLength(XMLPrettyPrinter.prettyPrint(exchange.getMessageIn().printMessage()).length());

				report1.setTimeStamp(TimeStampType.t1);

				res.addReport(report1);

				// create date provider in
				Report report2 = SOAUtil.getInstance().getXmlContext(EasyESBFramework.getInstance()).getXmlObjectFactory().create(Report.class);
				this.setSOACommonInformation(exchange, report2);
				date = null;
				date = TimeStamperHandler.getInstance().getTimeStamp(exchange).getDateProviderIn();
				if(date != null){
					report2.setDateInGMT(date);
				}else{
					log.severe("report2 failed to set timestamp ... for exchange "+exchange.getUuid());
				}

				report2.setTimeStamp(TimeStampType.t2);
				report2.setContentLength(0);
				res.addReport(report2);

			} 

			// handle out request
			if(PatternType.IN_OUT.equals(exchange.getPattern())) {



				// create date client in
				Report report1 = SOAUtil.getInstance().getXmlContext(EasyESBFramework.getInstance()).getXmlObjectFactory().create(Report.class);
				this.setSOACommonInformation(exchange, report1);

				Date date = null;
				date = TimeStamperHandler.getInstance().getTimeStamp(exchange).getDateClientIn();
				if(date != null){
					report1.setDateInGMT(date);
				}else{
					log.severe("report1 failed to set timestamp ... for exchange "+exchange.getUuid());
				}
				report1.setContentLength(XMLPrettyPrinter.prettyPrint(exchange.getMessageIn().printMessage()).length());
				report1.setTimeStamp(TimeStampType.t1);
				res.addReport(report1);

				// create date provider in
				Report report2 = SOAUtil.getInstance().getXmlContext(EasyESBFramework.getInstance()).getXmlObjectFactory().create(Report.class);
				this.setSOACommonInformation(exchange, report2);
				date = null;
				date = TimeStamperHandler.getInstance().getTimeStamp(exchange).getDateProviderIn();
				if(date != null){
					report2.setDateInGMT(date);
				}else{
					log.severe("Date set failed (client-in) for exchange "+exchange.getUuid());
				}

				report2.setTimeStamp(TimeStampType.t2);
				report2.setContentLength(report1.getContentLength());
				res.addReport(report2);


			} 
		}

		return res;
	}

	protected void setSOACommonInformation(Exchange exchange,
			Report report) {
		report.setExchangeId(exchange.getUuid().toString());
		try {
			EndpointAddress epr = ESBUtil.analyzeURI(exchange.getDestinationReference());
			if(exchange.getDestinationReference() != null) {
				report.setEndpointName(epr.getEndpointname());
			}
			if(exchange.getOperation() != null) {
				report.setOperationName(exchange.getOperation().toString());
			}
			if(exchange.getInterfaceName() != null) {
				report.setInterfaceQName(exchange.getInterfaceName());
			}
			if(exchange.getServiceName() != null) {
				report.setServiceQName(exchange.getServiceName());
			}
			if(exchange.getSourceReference() != null) {
				report.setConsumerEndpointAddress(exchange.getSourceReference().toString());
			} 
			if(exchange.getDestinationReference() != null) {
				report.setProviderEndpointAddress(exchange.getDestinationReference().toString());
			}
		} catch (SOAException e) {
			// do nothing
			e.printStackTrace();
		}
	}
}
