/*******************************************************************************
 * Copyright (c) 2011 EBM Websourcing.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v2.1
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * 
 * Contributors:
 *     EBM Websourcing - initial API and implementation
 ******************************************************************************/
package com.ebmwebsourcing.easyesb.rawreport.interceptor.timestamp;

import java.util.logging.Logger;

import com.ebmwebsourcing.easyesb.exchange10.api.element.Exchange;
import com.ebmwebsourcing.easyesb.soa.api.interceptors.ClientEndpointInvocationInterceptor;
import com.ebmwebsourcing.easyesb.transporter.api.transport.TransportException;

public class ClientTimeStampInterceptor implements ClientEndpointInvocationInterceptor {

    private static Logger log = Logger.getLogger(ClientTimeStampInterceptor.class.getName());

   

    public void processingExchangeAfterReceiving(Exchange exchange)
    throws TransportException {
        log.info("t4: timestamp the messageExchange (" + exchange.getUuid() + ")");
        TimeStamperHandler.setTimeStamp(exchange);
    }

 

    public void processingExchangeBeforeSending(Exchange exchange)
    throws TransportException {
        TimeStamperHandler.setTimeStamp(exchange);
        log.info("t1: timestamp the messageExchange (" + exchange.getUuid() + ")");
    }




}
