/*******************************************************************************
 * Copyright (c) 2011 EBM Websourcing.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v2.1
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * 
 * Contributors:
 *     EBM Websourcing - initial API and implementation
 ******************************************************************************/
package com.ebmwebsourcing.easyesb.soa.api.node;

import java.util.List;
import java.util.Map;

import javax.xml.namespace.QName;

import com.ebmwebsourcing.easyesb.soa.api.ESBException;
import com.ebmwebsourcing.easyesb.soa.api.component.Component;
import com.ebmwebsourcing.easyesb.soa.api.component.ComponentBehaviour;
import com.ebmwebsourcing.easyesb.soa.api.config.Configuration;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.ClientEndpoint;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.Endpoint;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.behaviour.EndpointBehaviour;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.external.ExternalServer;
import com.ebmwebsourcing.easyesb.soa.api.interceptors.Interceptor;
import com.ebmwebsourcing.easyesb.soa.api.registry.RegistryService;
import com.ebmwebsourcing.easyesb.soa.api.registry.RegistryServiceBehaviour;
import com.ebmwebsourcing.easyesb.soa.api.transport.TransportersManager;
import com.ebmwebsourcing.easyesb.soa10.api.element.EndpointInitialContext;
import com.ebmwebsourcing.easyesb.soa10.api.type.ClientEndpointType;
import com.ebmwebsourcing.easyesb.soa10.api.type.ComponentType;
import com.ebmwebsourcing.easyesb.soa10.api.type.RegistryServiceType;
import com.ebmwebsourcing.wsstar.topics.datatypes.api.abstraction.TopicSetType;

import easyesb.ebmwebsourcing.com.soa.model.node.NodeEndpointBehaviourItf;

public interface NodeBehaviour extends ComponentBehaviour, NodeEndpointBehaviourItf {
	
	public static String DESCRIPTION_NODE_URL = "wsdl/nodeEndpointBehaviour.wsdl";

	
	// client endpoint methods
	<CE extends ClientEndpoint<? extends ClientEndpointType>> CE createClientEndpoint(QName name, Class<CE> clientEndpointClass, Class<? extends EndpointBehaviour> clientEndpointBehaviourClass, EndpointInitialContext context) throws ESBException;
	List<ClientEndpoint<? extends ClientEndpointType>> getClientEndpoints();
	ClientEndpoint<? extends ClientEndpointType> getClientEndpoint(QName name);
	ClientEndpoint<? extends ClientEndpointType> removeClientEndpoint(ClientEndpoint<? extends ClientEndpointType> ce) throws ESBException;
	
	
	// component method
	<C extends Component<? extends ComponentType>> C createComponent(QName name, Class<C> componentClassName) throws ESBException;
	List<Component<? extends ComponentType>> getComponents();
	Component<? extends ComponentType> getComponent(QName name);
	Component<? extends ComponentType> removeComponent(Component<? extends ComponentType> ce) throws ESBException;
	
	Map<String, Component> getDeployableResourcesByComponent();

	
	// registry methods
	RegistryService<RegistryServiceType> createRegistryService(String name, Class<? extends RegistryService> serviceRegistryClass, Class<? extends RegistryServiceBehaviour> serviceRegistryBehaviourClass, EndpointInitialContext context) throws ESBException ;
	RegistryService<RegistryServiceType> getRegistryService();
	

	// transporter methods
	TransportersManager createTransportersManager(String name) throws ESBException ;
	TransportersManager getTransportersManager();
	
	
	// commons methods
	String getHost();
	void setHost(String ip);
	String getPort();
	void setPort(String port);
	Configuration getConfiguration();
	void setConfiguration(Configuration conf);
	String getSOAPTransporterAddress();
	void addExternalServer(ExternalServer server);
	ExternalServer getExternalServer(String name);
	List<ExternalServer> getExternalServers();
	void setTransportersManager(TransportersManager tm);
	boolean isStopped();
	void setAdminExternalEndpoint(String endpoint);
	String getAdminExternalEndpoint();
	
	
	// for EDA
	Map<TopicSetType, Interceptor> getInterceptorSubscribers(); 
	Map<TopicSetType, Endpoint<?>> getEndpointSubscribers(); 
	Endpoint<?> getEndpointFromTopicQName(QName topic);
	
	
	Endpoint<?>[] findEndpointsByBehaviour(Class<? extends EndpointBehaviour> clazz) throws ESBException;
 	
}
