/*******************************************************************************
 * Copyright (c) 2011 EBM Websourcing.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v2.1
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * 
 * Contributors:
 *     EBM Websourcing - initial API and implementation
 ******************************************************************************/
package com.ebmwebsourcing.easyesb.soa.api.service;

import javax.xml.namespace.QName;

import com.ebmwebsourcing.easyesb.soa.api.ESBException;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.ProviderEndpoint;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.behaviour.EndpointBehaviour;
import com.ebmwebsourcing.easyesb.soa10.api.element.EndpointInitialContext;
import com.ebmwebsourcing.easyesb.soa10.api.type.ProviderEndpointType;

import easyesb.ebmwebsourcing.com.soa.model.service.ServiceBehaviourItf;

public interface ServiceBehaviour extends EndpointBehaviour, ServiceBehaviourItf {
	
	public static String DESCRIPTION_URL = "wsdl/serviceEndpointBehaviour.wsdl";
	
	
	<P extends ProviderEndpoint<? extends ProviderEndpointType>> P createProviderEndpoint(String name, Class<P> endpointClass, EndpointInitialContext context) throws ESBException;
	
	ProviderEndpoint<? extends ProviderEndpointType>[] getProviderEndpoints();
	
	void addProviderEndpoints(ProviderEndpoint<? extends ProviderEndpointType>... endpoints);

	void removeProviderEndpoints(ProviderEndpoint<? extends ProviderEndpointType>... endpoints);
	
	ProviderEndpoint<? extends ProviderEndpointType> getProviderEndpoint(QName name);
	
	ProviderEndpoint<? extends ProviderEndpointType> removeProviderEndpoint(ProviderEndpoint<? extends ProviderEndpointType> pe) throws ESBException;
	
}
