/*******************************************************************************
 * Copyright (c) 2011 EBM Websourcing.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v2.1
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * 
 * Contributors:
 *     EBM Websourcing - initial API and implementation
 ******************************************************************************/
package com.ebmwebsourcing.easyesb.soa.api.transport;

import java.util.List;

import javax.xml.namespace.QName;

import org.petalslink.abslayer.service.api.Description;

import com.ebmwebsourcing.easyesb.exchange10.api.ExchangeException;
import com.ebmwebsourcing.easyesb.exchange10.api.element.Exchange;
import com.ebmwebsourcing.easyesb.soa.api.ESBException;
import com.ebmwebsourcing.easyesb.soa.api.interceptors.ClientEndpointInvocationInterceptor;
import com.ebmwebsourcing.easyesb.transporter.api.transport.TransportException;


public interface Stub {

	TransportersManager getTransportersManager() throws ESBException;
	
	Exchange createExchange()  throws ExchangeException;
	
	void send(Exchange message) throws TransportException;
	
	// for asynchronous invocation
	Exchange pull(QName providerEndpointName, QName nodeEndpointName) throws TransportException;

	Exchange sendSync(Exchange message, long timeout) throws TransportException;

	Description getDescriptionOfProviderEndpoint(QName name) throws ESBException;


	void addClientEndpointInvocationInterceptor(ClientEndpointInvocationInterceptor i);
	
	ClientEndpointInvocationInterceptor removeClientEndpointInvocationInterceptor(ClientEndpointInvocationInterceptor i);
	
	ClientEndpointInvocationInterceptor[] getClientEndpointInvocationInterceptors();

}
