/*******************************************************************************
 * Copyright (c) 2011 EBM Websourcing.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v2.1
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * 
 * Contributors:
 *     EBM Websourcing - initial API and implementation
 ******************************************************************************/
package com.ebmwebsourcing.easyesb.soa.api.component;

import java.net.URI;
import java.util.Map;

import javax.xml.namespace.QName;

import com.ebmwebsourcing.easyesb.soa.api.ESBException;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.Endpoint;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.ProviderEndpoint;
import com.ebmwebsourcing.easyesb.soa.api.transport.listener.ListenersManager;
import com.ebmwebsourcing.easyesb.soa10.api.type.ComponentType;
import com.ebmwebsourcing.easyesb.soa10.api.type.EndpointType;
import com.ebmwebsourcing.easyesb.transporter.api.transport.lifecycle.LifeCycle;

public interface Component<M extends ComponentType> extends ProviderEndpoint<M>, LifeCycle {
	
	ListenersManager getListenersManager();
	
	Map<URI, Endpoint<? extends EndpointType>> getListenedEndpoints();
	
	void setListenedEndpoints(Map<URI, Endpoint<? extends EndpointType>> endpoints);
	
	QName getQName() throws ESBException;
	
	/**
	 * Utility method to retrieve internal context of the component.
	 * For instance, allows to retrieve the EasyVIPER core from BPEL and COS components. 
	 */
	Object getContext();

}
