package com.ebmwebsourcing.easyesb.soa.api.endpoint.external;

import java.util.logging.Logger;

import com.ebmwebsourcing.easyesb.soa.api.ESBException;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.ClientProxyEndpoint;
import com.ebmwebsourcing.easyesb.soa10.api.type.ClientProxyEndpointType;


public abstract class AbstractExternalListener implements ExternalListener {

	private Logger log = Logger.getLogger(AbstractExternalListener.class.getName());
	
	private ClientProxyEndpoint<? extends ClientProxyEndpointType> clientEndpoint;
	
	private ExternalServer server;
	
	
	public AbstractExternalListener(ClientProxyEndpoint<? extends ClientProxyEndpointType> clientEndpoint, ExternalServer server) throws ESBException {
		this.clientEndpoint = clientEndpoint;
		this.server = server;
		
		if(!listenerExit(this)) {
			this.server.addExternalListener(this);
		} else {
			throw new ESBException("Listener already exist!!! : " + this.clientEndpoint.getReference());
		}

		log.info("new service deployed at: " + this.getExposedAddress());
	}

	private boolean listenerExit(ExternalListener listener) throws ESBException {
		boolean res = false;
		for(ExternalListener l: server.getExternalListeners()) {
			if(l.getEndpoint().getReference().equals(listener.getEndpoint().getReference())) {
				res = true;
				break;
			}
		}
		return res;
	}
	
	@Override
	public ClientProxyEndpoint<? extends ClientProxyEndpointType> getEndpoint() {
		return this.clientEndpoint;
	}

	@Override
	public abstract String getExposedAddress() throws ESBException;

	@Override
	public ExternalServer getExternalServer() {
		return this.server;
	}
	
}
