/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easyesb.soa.api.endpoint.external;

import com.ebmwebsourcing.easyesb.soa.api.ESBException;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.ClientProxyEndpoint;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.external.ExternalListener;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.external.ExternalServer;
import com.ebmwebsourcing.easyesb.soa10.api.type.ClientProxyEndpointType;
import java.util.logging.Logger;

public abstract class AbstractExternalListener
implements ExternalListener {
    private Logger log = Logger.getLogger(AbstractExternalListener.class.getName());
    private ClientProxyEndpoint<? extends ClientProxyEndpointType> clientEndpoint;
    private ExternalServer server;

    public AbstractExternalListener(ClientProxyEndpoint<? extends ClientProxyEndpointType> clientEndpoint, ExternalServer server) throws ESBException {
        this.clientEndpoint = clientEndpoint;
        this.server = server;
        if (this.listenerExit(this)) {
            throw new ESBException("Listener already exist!!! : " + this.clientEndpoint.getReference());
        }
        this.server.addExternalListener(this);
        this.log.info("new service deployed at: " + this.getExposedAddress());
    }

    private boolean listenerExit(ExternalListener listener) throws ESBException {
        boolean res = false;
        for (ExternalListener l : this.server.getExternalListeners()) {
            if (!l.getEndpoint().getReference().equals(listener.getEndpoint().getReference())) continue;
            res = true;
            break;
        }
        return res;
    }

    @Override
    public ClientProxyEndpoint<? extends ClientProxyEndpointType> getEndpoint() {
        return this.clientEndpoint;
    }

    @Override
    public abstract String getExposedAddress() throws ESBException;

    @Override
    public ExternalServer getExternalServer() {
        return this.server;
    }
}

