/*******************************************************************************
 * Copyright (c) 2011 EBM Websourcing.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v2.1
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * 
 * Contributors:
 *     EBM Websourcing - initial API and implementation
 ******************************************************************************/
/**
 * EasyESB: EasyESB Services Platform Copyright (C) 2009 EBM WebSourcing
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or any later version.
 * 
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 * 
 * Initial developer(s): EBM WebSourcing
 */
package com.ebmwebsourcing.easyesb.soa.impl.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

import com.ebmwebsourcing.easyesb.soa.api.ESBException;
import com.ebmwebsourcing.easyesb.soa.api.config.Configuration;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.behaviour.EndpointBehaviour;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.external.ExternalServer;
import com.ebmwebsourcing.easyesb.soa.api.registry.RegistryService;
import com.ebmwebsourcing.easyesb.soa.api.registry.RegistryServiceBehaviour;
import com.ebmwebsourcing.easyesb.soa.api.service.Service;
import com.ebmwebsourcing.easyesb.soa.api.service.ServiceBehaviour;

/**
 * @author chamerling - eBM WebSourcing
 * 
 */
public class ConfigurationImpl implements Configuration {

	private static Logger log = Logger.getLogger(ConfigurationImpl.class.getName());

	private Map<String, String> properties = new ConcurrentHashMap<String, String>();

	private static String CONFIG = "config.properties";


	private List<ExternalServer> externalServers = new ArrayList<ExternalServer>();

	private List<String> endpointInitializationInterceptors = new ArrayList<String>();
	
	private Class<? extends RegistryService> registryServiceClass;
	
	private Class<? extends RegistryServiceBehaviour> registryServiceBehaviourClass;
	
	private Class<? extends Service> adminServiceClass;
	
	private Class<? extends ServiceBehaviour> adminServiceBehaviourClass;
	
	private Class<? extends EndpointBehaviour> adminEndpointBehaviourClass;

	private Class<? extends Service> resourcesServiceClass;
	
	private Class<? extends ServiceBehaviour> resourcesServiceBehaviourClass;
	
	private Class<? extends EndpointBehaviour> resourcesEndpointBehaviourClass;

	
	public ConfigurationImpl() throws ESBException {
		this.properties.put(EXPLORER, DEFAULT_EXPLORER);
		this.properties.put(HOST, DEFAULT_HOST);
		this.properties.put(PORT, DEFAULT_PORT);
		loadConfigurationFile();

	}

	public ConfigurationImpl(Map<String, String> data) throws ESBException {
		this.properties = data;
	}

	public ConfigurationImpl(boolean explorer, String host, int port, ExternalServer... servers) throws ESBException {
		this.properties.put(EXPLORER, String.valueOf(explorer));
		this.properties.put(HOST, String.valueOf(host));
		this.properties.put(PORT, String.valueOf(port));

		for(ExternalServer server: servers) {
			this.externalServers.add(server);
		}
	}

	private void loadConfigurationFile() throws ESBException {
		Properties props = new Properties();
		File f = new File(CONFIG);
		if (log.isLoggable(Level.FINE)) {
			log.fine("Loading config from " + f.getAbsoluteFile());
		}

		InputStream is = null;

		if(f.exists()) {
			try {
				is = new FileInputStream(f);
			} catch (FileNotFoundException e) {
				throw new ESBException(e);
			}
		}

		if (is != null) {
			try {
				props.load(is);
				for (Object k : props.keySet()) {
					// get common interceptor
					if(COMMON_ENDPOINT_INITIALIZATION_INTERCEPTOR.equals(k.toString().trim()))  {
						String interceptorClassName = props.get(k).toString().trim();
						this.endpointInitializationInterceptors.add(interceptorClassName);					
					} else if(REGISTRY_SERVICE_CLASS.equals(k.toString().trim())) {
						String registryServiceClassName = props.get(k).toString().trim();
						Class<? extends RegistryService> registryServiceClass = (Class<? extends RegistryService>) Thread.currentThread().getContextClassLoader().loadClass(registryServiceClassName);
						this.setRegistryServiceClass(registryServiceClass);
					} else if(REGISTRY_SERVICE_BEHAVIOUR_CLASS.equals(k.toString().trim())) {
						String registryServiceBehaviourClassName = props.get(k).toString().trim();
						Class<? extends RegistryServiceBehaviour> registryServiceBehaviourClass = (Class<? extends RegistryServiceBehaviour>) Thread.currentThread().getContextClassLoader().loadClass(registryServiceBehaviourClassName);
						this.setRegistryServiceBehaviourClass(registryServiceBehaviourClass);
					} else if(ADMIN_SERVICE_CLASS.equals(k.toString().trim())) {
						String registryAdminClassName = props.get(k).toString().trim();
						Class<? extends Service> registryAdminClass = (Class<? extends Service>) Thread.currentThread().getContextClassLoader().loadClass(registryAdminClassName);
						this.setAdminServiceClass(registryAdminClass);
					} else if(ADMIN_SERVICE_BEHAVIOUR_CLASS.equals(k.toString().trim())) {
						String adminServiceBehaviourClassName = props.get(k).toString().trim();
						Class<? extends ServiceBehaviour> adminServiceBehaviourClass = (Class<? extends ServiceBehaviour>) Thread.currentThread().getContextClassLoader().loadClass(adminServiceBehaviourClassName);
						this.setAdminServiceBehaviourClass(adminServiceBehaviourClass);
					} else if(ADMIN_ENDPOINT_BEHAVIOUR_CLASS.equals(k.toString().trim())) {
						String adminEndpointBehaviourClassName = props.get(k).toString().trim();
						Class<? extends EndpointBehaviour> adminEndpointBehaviourClass = (Class<? extends EndpointBehaviour>) Thread.currentThread().getContextClassLoader().loadClass(adminEndpointBehaviourClassName);
						this.setAdminEndpointBehaviourClass(adminEndpointBehaviourClass);
					} else if(RESOURCES_SERVICE_CLASS.equals(k.toString().trim())) {
						String registryResourcesClassName = props.get(k).toString().trim();
						Class<? extends Service> registryResourcesClass = (Class<? extends Service>) Thread.currentThread().getContextClassLoader().loadClass(registryResourcesClassName);
						this.setResourcesServiceClass(registryResourcesClass);
					} else if(RESOURCES_SERVICE_BEHAVIOUR_CLASS.equals(k.toString().trim())) {
						String resourcesServiceBehaviourClassName = props.get(k).toString().trim();
						Class<? extends ServiceBehaviour> resourcesServiceBehaviourClass = (Class<? extends ServiceBehaviour>) Thread.currentThread().getContextClassLoader().loadClass(resourcesServiceBehaviourClassName);
						this.setResourcesServiceBehaviourClass(resourcesServiceBehaviourClass);
					} else if(RESOURCES_ENDPOINT_BEHAVIOUR_CLASS.equals(k.toString().trim())) {
						String resourcesEndpointBehaviourClassName = props.get(k).toString().trim();
						Class<? extends EndpointBehaviour> resourcesEndpointBehaviourClass = (Class<? extends EndpointBehaviour>) Thread.currentThread().getContextClassLoader().loadClass(resourcesEndpointBehaviourClassName);
						this.setResourcesEndpointBehaviourClass(resourcesEndpointBehaviourClass);
					}else {
						properties.put(k.toString().trim(), props.get(k).toString()
								.trim());
					}
				}
			} catch (IOException e) {
				throw new ESBException(e);
			} catch (ClassNotFoundException e) {
				throw new ESBException(e);
			} 
		} else {
			log.warning("No configuration file found...");
		}
	}


	/**
	 * @return the data
	 */
	public Map<String, String> getProperties() {
		return properties;
	}

	public void addProperty(String key, String value) {
		this.properties.put(key, value);
	}

	public static String getCONFIG() {
		return CONFIG;
	}

	public static void setCONFIG(String config) {
		CONFIG = config;
	}

	public Integer getPort() {
		return Integer.valueOf(this.getProperties().get(PORT));
	}

	public Boolean getExplorer() {
		return Boolean.valueOf(this.getProperties().get(EXPLORER));
	}

	public String getHost() {
		return String.valueOf(this.getProperties().get(HOST));
	}

	public void setExplorer(boolean explorer) {
		this.properties.put(EXPLORER, String.valueOf(explorer));
	}

	public void setHost(String host) {
		this.properties.put(HOST, String.valueOf(host));
	}

	public void setPort(int port) {
		this.properties.put(PORT, String.valueOf(port));
	}

	public List<ExternalServer> getExternalServers() {
		return externalServers;
	}

	public void addExternalServer(ExternalServer es) {
		this.externalServers.add(es);
	}

	public List<String> getEndpointInitializationInterceptorClassNames() {
		return this.endpointInitializationInterceptors;
	}

	public void addEndpointInitializationInterceptorClassName(
			String eii) {
		this.endpointInitializationInterceptors.add(eii);
	}

	public Class<? extends RegistryService> getRegistryServiceClass() {
		return this.registryServiceClass;
	}

	public void setRegistryServiceClass(
			Class<? extends RegistryService> clazz) {
		this.registryServiceClass = clazz;
	}

	public Class<? extends RegistryServiceBehaviour> getRegistryServiceBehaviourClass() {
		return this.registryServiceBehaviourClass;
	}

	public void setRegistryServiceBehaviourClass(
			Class<? extends RegistryServiceBehaviour> clazz) {
		this.registryServiceBehaviourClass = clazz;
	}

	public Class<? extends Service> getAdminServiceClass() {
		return this.adminServiceClass;
	}

	public void setAdminServiceClass(Class<? extends Service> clazz) {
		this.adminServiceClass = clazz;
	}

	public Class<? extends ServiceBehaviour> getAdminServiceBehaviourClass() {
		return this.adminServiceBehaviourClass;
	}

	public void setAdminServiceBehaviourClass(
			Class<? extends ServiceBehaviour> clazz) {
		this.adminServiceBehaviourClass = clazz;
	}

	public Class<? extends EndpointBehaviour> getAdminEndpointBehaviourClass() {
		return this.adminEndpointBehaviourClass;
	}

	public void setAdminEndpointBehaviourClass(
			Class<? extends EndpointBehaviour> clazz) {
		this.adminEndpointBehaviourClass = clazz;
	}

	@Override
	public Class<? extends Service> getResourcesServiceClass() {
		return this.resourcesServiceClass;
	}

	@Override
	public void setResourcesServiceClass(Class<? extends Service> clazz) {
		this.resourcesServiceClass = clazz;
	}

	@Override
	public Class<? extends ServiceBehaviour> getResourcesServiceBehaviourClass() {
		return this.resourcesServiceBehaviourClass;
	}

	@Override
	public void setResourcesServiceBehaviourClass(
			Class<? extends ServiceBehaviour> clazz) {
		this.resourcesServiceBehaviourClass = clazz;
	}

	@Override
	public Class<? extends EndpointBehaviour> getResourcesEndpointBehaviourClass() {
		return this.resourcesEndpointBehaviourClass;
	}

	@Override
	public void setResourcesEndpointBehaviourClass(
			Class<? extends EndpointBehaviour> clazz) {
		this.resourcesEndpointBehaviourClass = clazz;
	}


}
