/*******************************************************************************
 * Copyright (c) 2011 EBM Websourcing.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v2.1
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * 
 * Contributors:
 *     EBM Websourcing - initial API and implementation
 ******************************************************************************/
package com.ebmwebsourcing.easyesb.soa.impl.endpoint;

import java.util.HashMap;
import java.util.Map;

import javax.xml.namespace.QName;

import org.oasisopen.sca.annotation.PolicySets;
import org.oasisopen.sca.annotation.Scope;
import org.oasisopen.sca.annotation.Service;
import org.petalslink.abslayer.service.api.Description;

import com.ebmwebsourcing.easyesb.soa.api.ESBException;
import com.ebmwebsourcing.easyesb.soa.api.SOAElement;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.ClientProxyEndpoint;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.behaviour.specific.ClientProxyBehaviour;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.external.ExternalListener;
import com.ebmwebsourcing.easyesb.soa10.api.type.ClientProxyEndpointType;

@Scope("COMPOSITE")
@Service(value=ClientProxyEndpoint.class, names="service")
@PolicySets("frascati:scaEasyPrimitive")
public class ClientProxyEndpointImpl<M extends ClientProxyEndpointType> extends ClientEndpointImpl<M> implements ClientProxyEndpoint<M> {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	private Map<String, ExternalListener> listeners = new HashMap<String, ExternalListener>();

	
	public ClientProxyEndpointImpl() {
		super();
	}
	
	public ClientProxyEndpointImpl(M model, SOAElement<?> parent) throws ESBException {
		super(model, parent);
	}


	public Map<String, ExternalListener> getExternalListeners() {
		return this.listeners;
	}


	public QName getProviderEndpointName() {
		return this.model.getProviderEndpointName();
	}

	public void setProviderEndpointName(QName providerQName) {
		this.model.setProviderEndpointName(providerQName);
	}

	public void setExternalListeners(Map<String, ExternalListener> listeners) {
		this.listeners = listeners;
	}


	public String getExternalAddress() {
		return this.model.getExternalAddress();
	}


	public void setExternalAddress(String address) {
		this.model.setExternalAddress(address);
	}

	public Class<M> getModelClass() {
		Class<M> res = null;
		if(model != null) {
			res = (Class<M>) model.getClass();
		} else {
			res = (Class<M>) ClientProxyEndpointType.class;
		}
		return res;
	}

	public QName getProviderServiceName() {
		return this.model.getProviderServiceName();
	}

	public void setProviderServiceName(QName providerQName) {
		this.model.setProviderServiceName(providerQName);
	}

	@Override
	public Description getDescription() {
		if(description == null) {
			ClientProxyBehaviour cpb = this.findBehaviour(ClientProxyBehaviour.class);
			if(cpb != null) {
				description = cpb.getDescription2Provider();
			}
		}
		return description;
	}
	
	
}
