/*******************************************************************************
 * Copyright (c) 2011 EBM Websourcing.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v2.1
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * 
 * Contributors:
 *     EBM Websourcing - initial API and implementation
 ******************************************************************************/
/**
 * EasyESB: EasyESB Services Platform Copyright (C) 2009 EBM WebSourcing
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or any later version.
 * 
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 * 
 * Initial developer(s): EBM WebSourcing
 */
package com.ebmwebsourcing.easyesb.soa.impl.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

import com.ebmwebsourcing.easyesb.soa.api.ESBException;
import com.ebmwebsourcing.easyesb.soa.api.config.Configuration;
import com.ebmwebsourcing.easyesb.soa.api.registry.RegistryService;
import com.ebmwebsourcing.easyesb.soa.api.registry.RegistryServiceBehaviour;

/**
 * @author chamerling - eBM WebSourcing
 * 
 */
public class ConfigurationImpl implements Configuration {

	private static Logger log = Logger.getLogger(ConfigurationImpl.class.getName());

	private Map<String, String> properties = new ConcurrentHashMap<String, String>();

	private static String CONFIG = "config.properties";

	private List<String> endpointInitializationInterceptors = new ArrayList<String>();
	
	public ConfigurationImpl() throws ESBException {
		this.properties.put(HOST, DEFAULT_HOST);
		this.properties.put(PORT, DEFAULT_PORT);
		loadConfigurationFile();

	}

	public ConfigurationImpl(Map<String, String> data) throws ESBException {
		this.properties = data;
	}
	
	public ConfigurationImpl(String host, int port) throws ESBException {
		this.properties.put(HOST, String.valueOf(host));
		this.properties.put(PORT, String.valueOf(port));
	}

	public ConfigurationImpl(String host, int port, Map<String, String> otherproperties) throws ESBException {
		this.properties.put(HOST, String.valueOf(host));
		this.properties.put(PORT, String.valueOf(port));

		this.properties.putAll(otherproperties);
	}

	private void loadConfigurationFile() throws ESBException {
		Properties props = new Properties();
		File f = new File(CONFIG);
		if (log.isLoggable(Level.FINE)) {
			log.fine("Loading config from " + f.getAbsoluteFile());
		}

		InputStream is = null;

		if(f.exists()) {
			try {
				is = new FileInputStream(f);
			} catch (FileNotFoundException e) {
				throw new ESBException(e);
			}
		}

		if (is != null) {
			try {
				props.load(is);
				for (Object k : props.keySet()) {
					// get common interceptor
					if(COMMON_ENDPOINT_INITIALIZATION_INTERCEPTOR.equals(k.toString().trim()))  {
						String interceptorClassName = props.get(k).toString().trim();
						this.endpointInitializationInterceptors.add(interceptorClassName);					
					} else {
						properties.put(k.toString().trim(), props.get(k).toString()
								.trim());
					}
				}
			} catch (IOException e) {
				throw new ESBException(e);
			} 
		} else {
			log.warning("No configuration file found...");
		}
	}


	/**
	 * @return the data
	 */
	public Map<String, String> getProperties() {
		return properties;
	}

	public void addProperty(String key, String value) {
		this.properties.put(key, value);
	}

	public static String getCONFIG() {
		return CONFIG;
	}

	public static void setCONFIG(String config) {
		CONFIG = config;
	}

	public Integer getPort() {
		return Integer.valueOf(this.getProperties().get(PORT));
	}

	public String getHost() {
		return String.valueOf(this.getProperties().get(HOST));
	}

	public void setHost(String host) {
		this.properties.put(HOST, String.valueOf(host));
	}

	public void setPort(int port) {
		this.properties.put(PORT, String.valueOf(port));
	}

	public List<String> getEndpointInitializationInterceptorClassNames() {
		return this.endpointInitializationInterceptors;
	}

	public void addEndpointInitializationInterceptorClassName(
			String eii) {
		this.endpointInitializationInterceptors.add(eii);
	}

}
