/*******************************************************************************
 * Copyright (c) 2011 EBM Websourcing.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v2.1
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * 
 * Contributors:
 *     EBM Websourcing - initial API and implementation
 ******************************************************************************/
package com.ebmwebsourcing.easyesb.soa.impl.transport.listener;

import java.net.URI;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

import org.apache.commons.lang.NotImplementedException;

import com.ebmwebsourcing.easyesb.soa.api.endpoint.Endpoint;
import com.ebmwebsourcing.easyesb.soa.api.transport.listener.Listener;
import com.ebmwebsourcing.easyesb.soa.api.transport.listener.ListenersManager;
import com.ebmwebsourcing.easyesb.soa10.api.type.EndpointType;

public class ListenersManagerImpl implements ListenersManager {

	public static final int DEFAULT_THREAD_COUNTER = 5;
	
	private ScheduledThreadPoolExecutor scheduledThreadPoolExecutor;

	
	public ListenersManagerImpl(int numberOfThreads, Map<URI, Endpoint<? extends EndpointType>> endpoints) {
		if(numberOfThreads <= 0) {
			numberOfThreads = 1;
		}
		
		// create the listener collection
        Collection<Listener> listeners = new HashSet<Listener>();
        for(int i = 0; i < numberOfThreads; i++) {
        	listeners.add(new ListenerImpl(endpoints));
        }
        
        // Start the listeners in the thread worker
        scheduledThreadPoolExecutor = new ScheduledThreadPoolExecutor(
        		numberOfThreads);
        
        for (Listener listener : listeners) {
            scheduledThreadPoolExecutor.scheduleWithFixedDelay(listener, 0, 1,
                TimeUnit.MILLISECONDS);
        }
	}
	
	public void shutdownAllListeners() {
        scheduledThreadPoolExecutor.shutdown();
        try {
            scheduledThreadPoolExecutor.awaitTermination(10, TimeUnit.SECONDS);
        } catch (InterruptedException e1) {
            // do nothing
        	e1.printStackTrace();
        }
	}
	
	public void addListener(Listener listener) {
		throw new NotImplementedException();
	}
	

	public Listener removeListener(Listener listener) {
		throw new NotImplementedException();
	}

}
