/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easyesb.soa.impl.endpoint.behaviour.specific;

import com.ebmwebsourcing.easybox.api.XmlObjectReadException;
import com.ebmwebsourcing.easybox.api.XmlObjectReader;
import com.ebmwebsourcing.easycommons.research.util.SOAException;
import com.ebmwebsourcing.easycommons.research.util.easybox.Framework;
import com.ebmwebsourcing.easycommons.research.util.easybox.SOAUtil;
import com.ebmwebsourcing.easycommons.research.util.esb.ESBUtil;
import com.ebmwebsourcing.easycommons.research.util.esb.EndpointAddress;
import com.ebmwebsourcing.easycommons.xml.XMLPrettyPrinter;
import com.ebmwebsourcing.easyesb.constant.EasyESBFramework;
import com.ebmwebsourcing.easyesb.exchange10.api.element.Exchange;
import com.ebmwebsourcing.easyesb.soa.api.ESBException;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.ProviderEndpoint;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.behaviour.AbstractEndpointBehaviourImpl;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.behaviour.specific.NotificationProducerEndpointBehaviour;
import com.ebmwebsourcing.easyesb.soa.api.util.MessageUtil;
import com.ebmwebsourcing.easyesb.transporter.api.transport.TransportException;
import com.ebmwebsourcing.easywsdl11.api.element.Definitions;
import com.ebmwebsourcing.wsstar.basefaults.datatypes.api.implementor.WsrfbfModelFactory;
import com.ebmwebsourcing.wsstar.basefaults.datatypes.impl.impl.WsrfbfModelFactoryImpl;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.GetCurrentMessage;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.GetCurrentMessageResponse;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.Subscribe;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.SubscribeResponse;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.implementor.WsnbModelFactory;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.refinedabstraction.RefinedWsnbFactory;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.utils.WsnbException;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.impl.impl.WsnbModelFactoryImpl;
import com.ebmwebsourcing.wsstar.resource.datatypes.api.implementor.WsrfrModelFactory;
import com.ebmwebsourcing.wsstar.resource.datatypes.impl.impl.WsrfrModelFactoryImpl;
import com.ebmwebsourcing.wsstar.resourcelifetime.datatypes.api.implementor.WsrfrlModelFactory;
import com.ebmwebsourcing.wsstar.resourcelifetime.datatypes.impl.impl.WsrfrlModelFactoryImpl;
import com.ebmwebsourcing.wsstar.resourceproperties.datatypes.api.implementor.WsrfrpModelFactory;
import com.ebmwebsourcing.wsstar.resourceproperties.datatypes.impl.impl.WsrfrpModelFactoryImpl;
import com.ebmwebsourcing.wsstar.topics.datatypes.api.implementor.WstopModelFactory;
import com.ebmwebsourcing.wsstar.topics.datatypes.impl.impl.WstopModelFactoryImpl;
import com.ebmwebsourcing.wsstar.wsnb.services.INotificationProducer;
import com.ebmwebsourcing.wsstar.wsnb.services.faults.InvalidFilterFault;
import com.ebmwebsourcing.wsstar.wsnb.services.faults.InvalidMessageContentExpressionFault;
import com.ebmwebsourcing.wsstar.wsnb.services.faults.InvalidProducerPropertiesExpressionFault;
import com.ebmwebsourcing.wsstar.wsnb.services.faults.InvalidTopicExpressionFault;
import com.ebmwebsourcing.wsstar.wsnb.services.faults.MultipleTopicsSpecifiedFault;
import com.ebmwebsourcing.wsstar.wsnb.services.faults.NoCurrentMessageOnTopicFault;
import com.ebmwebsourcing.wsstar.wsnb.services.faults.NotifyMessageNotSupportedFault;
import com.ebmwebsourcing.wsstar.wsnb.services.faults.SubscribeCreationFailedFault;
import com.ebmwebsourcing.wsstar.wsnb.services.faults.TopicExpressionDialectUnknownFault;
import com.ebmwebsourcing.wsstar.wsnb.services.faults.TopicNotSupportedFault;
import com.ebmwebsourcing.wsstar.wsnb.services.faults.UnableToDestroySubscriptionFault;
import com.ebmwebsourcing.wsstar.wsnb.services.faults.UnacceptableInitialTerminationTimeFault;
import com.ebmwebsourcing.wsstar.wsnb.services.faults.UnrecognizedPolicyRequestFault;
import com.ebmwebsourcing.wsstar.wsnb.services.faults.UnsupportedPolicyRequestFault;
import com.ebmwebsourcing.wsstar.wsnb.services.impl.engines.NotificationProducerEngine;
import com.ebmwebsourcing.wsstar.wsnb.services.impl.util.Wsnb4ServUtils;
import com.ebmwebsourcing.wsstar.wsrfbf.services.faults.AbsWSStarFault;
import com.ebmwebsourcing.wsstar.wsrfr.services.faults.ResourceUnknownFault;
import java.net.URI;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.petalslink.abslayer.Factory;
import org.petalslink.abslayer.service.api.Binding;
import org.petalslink.abslayer.service.api.Description;
import org.w3c.dom.Document;

public class NotificationProducerEndpointBehaviourImpl
extends AbstractEndpointBehaviourImpl
implements NotificationProducerEndpointBehaviour {
    private static Logger log = Logger.getLogger(NotificationProducerEndpointBehaviourImpl.class.getName());
    private INotificationProducer producer = null;
    private static Binding b;

    static {
        Wsnb4ServUtils.initModelFactories((WsrfbfModelFactory)new WsrfbfModelFactoryImpl(), (WsrfrModelFactory)new WsrfrModelFactoryImpl(), (WsrfrlModelFactory)new WsrfrlModelFactoryImpl(), (WsrfrpModelFactory)new WsrfrpModelFactoryImpl(), (WstopModelFactory)new WstopModelFactoryImpl(), (WsnbModelFactory)new WsnbModelFactoryImpl());
        try {
            Description desc = (Description)Factory.getInstance().wrap(((XmlObjectReader)SOAUtil.getInstance().getReader((Framework)EasyESBFramework.getInstance()).get()).readDocument(Thread.currentThread().getContextClassLoader().getResource("eventservice/wsn-producer.wsdl"), Definitions.class));
            b = (Binding)desc.getBindings().iterator().next();
        }
        catch (XmlObjectReadException e) {
            e.printStackTrace();
            throw new RuntimeException();
        }
    }

    public NotificationProducerEndpointBehaviourImpl(ProviderEndpoint<?> ep) {
        super(ep);
        this.setBinding(b);
    }

    public void execute(Exchange exchange) throws TransportException {
        try {
            log.finest("notification provider BEHAVIOUR FOUND: " + exchange.getOperation());
            log.finest("notification provider BEHAVIOUR FOUND: " + XMLPrettyPrinter.prettyPrint((Document)exchange.getMessageIn().printMessage()));
            if (QName.valueOf(exchange.getOperation()).getLocalPart().equals("GetCurrentMessage") && exchange.getMessageIn().getBody().getPayload() instanceof Document) {
                log.finest("Get Current Message");
                GetCurrentMessage getCurrentMessage = RefinedWsnbFactory.getInstance().getWsnbReader().readGetCurrentMessage(exchange.getMessageIn().getBody().getPayload());
                GetCurrentMessageResponse res = this.getCurrentMessage(getCurrentMessage);
                Document docResp = RefinedWsnbFactory.getInstance().getWsnbWriter().writeGetCurrentMessageResponseAsDOM(res);
                MessageUtil.getInstance().createOutMessageStructure(exchange);
                exchange.getMessageOut().getBody().setPayload(docResp);
            } else if (QName.valueOf(exchange.getOperation()).getLocalPart().equals("Subscribe") && exchange.getMessageIn().getBody().getPayload() instanceof Document) {
                log.finest("SUBSCRIBE");
                Subscribe subscribe = RefinedWsnbFactory.getInstance().getWsnbReader().readSubscribe(exchange.getMessageIn().getBody().getPayload());
                SubscribeResponse res = this.subscribe(subscribe);
                Document docResp = RefinedWsnbFactory.getInstance().getWsnbWriter().writeSubscribeResponseAsDOM(res);
                MessageUtil.getInstance().createOutMessageStructure(exchange);
                exchange.getMessageOut().getBody().setPayload(docResp);
            }
        }
        catch (ResourceUnknownFault e) {
            log.severe("ERROR IN NOTIFICATION PROVIDER ENDPOINT BEHAVIOUR: " + e.getMessage());
            throw new TransportException((Throwable)e);
        }
        catch (UnableToDestroySubscriptionFault e) {
            log.severe("ERROR IN NOTIFICATION PROVIDER ENDPOINT BEHAVIOUR: " + e.getMessage());
            throw new TransportException((Throwable)e);
        }
        catch (TopicNotSupportedFault e) {
            log.severe("ERROR IN NOTIFICATION PROVIDER ENDPOINT BEHAVIOUR: " + e.getMessage());
            throw new TransportException((Throwable)e);
        }
        catch (InvalidTopicExpressionFault e) {
            log.severe("ERROR IN NOTIFICATION PROVIDER ENDPOINT BEHAVIOUR: " + e.getMessage());
            throw new TransportException((Throwable)e);
        }
        catch (UnrecognizedPolicyRequestFault e) {
            log.severe("ERROR IN NOTIFICATION PROVIDER ENDPOINT BEHAVIOUR: " + e.getMessage());
            throw new TransportException((Throwable)e);
        }
        catch (InvalidMessageContentExpressionFault e) {
            log.severe("ERROR IN NOTIFICATION PROVIDER ENDPOINT BEHAVIOUR: " + e.getMessage());
            throw new TransportException((Throwable)e);
        }
        catch (UnsupportedPolicyRequestFault e) {
            log.severe("ERROR IN NOTIFICATION PROVIDER ENDPOINT BEHAVIOUR: " + e.getMessage());
            throw new TransportException((Throwable)e);
        }
        catch (TopicExpressionDialectUnknownFault e) {
            e.printStackTrace();
            log.severe("ERROR IN NOTIFICATION PROVIDER ENDPOINT BEHAVIOUR: " + e.getMessage());
            throw new TransportException((Throwable)e);
        }
        catch (UnacceptableInitialTerminationTimeFault e) {
            log.severe("ERROR IN NOTIFICATION PROVIDER ENDPOINT BEHAVIOUR: " + e.getMessage());
            throw new TransportException((Throwable)e);
        }
        catch (InvalidProducerPropertiesExpressionFault e) {
            log.severe("ERROR IN NOTIFICATION PROVIDER ENDPOINT BEHAVIOUR: " + e.getMessage());
            throw new TransportException((Throwable)e);
        }
        catch (InvalidFilterFault e) {
            log.severe("ERROR IN NOTIFICATION PROVIDER ENDPOINT BEHAVIOUR: " + e.getMessage());
            throw new TransportException((Throwable)e);
        }
        catch (SubscribeCreationFailedFault e) {
            log.severe("ERROR IN NOTIFICATION PROVIDER ENDPOINT BEHAVIOUR: " + e.getMessage());
            throw new TransportException((Throwable)e);
        }
        catch (NotifyMessageNotSupportedFault e) {
            log.severe("ERROR IN NOTIFICATION PROVIDER ENDPOINT BEHAVIOUR: " + e.getMessage());
            throw new TransportException((Throwable)e);
        }
        catch (MultipleTopicsSpecifiedFault e) {
            log.severe("ERROR IN NOTIFICATION PROVIDER ENDPOINT BEHAVIOUR: " + e.getMessage());
            throw new TransportException((Throwable)e);
        }
        catch (NoCurrentMessageOnTopicFault e) {
            log.severe("ERROR IN NOTIFICATION PROVIDER ENDPOINT BEHAVIOUR: " + e.getMessage());
            throw new TransportException((Throwable)e);
        }
        catch (WsnbException e) {
            log.severe("ERROR IN NOTIFICATION PROVIDER ENDPOINT BEHAVIOUR: " + e.getMessage());
            throw new TransportException((Throwable)e);
        }
        catch (AbsWSStarFault e) {
            log.severe("ERROR IN NOTIFICATION PROVIDER ENDPOINT BEHAVIOUR: " + e.getMessage());
            throw new TransportException((Throwable)e);
        }
    }

    public INotificationProducer getNotificationProducer() {
        return this.producer;
    }

    public void setNotificationProducer(INotificationProducer producer) throws ESBException {
        this.producer = producer;
        try {
            EndpointAddress epr = ESBUtil.analyzeURI((URI)this.endpoint.getReference());
            ((NotificationProducerEngine)this.producer).setNotificationProducerEdp(epr.getEndpointname());
            ((NotificationProducerEngine)this.producer).setNotificationProducerInterface(this.getBinding().getInterface().getQName());
            ((NotificationProducerEngine)this.producer).setNotificationProducerService(new QName(epr.getNamespace(), epr.getServicename()));
        }
        catch (SOAException e) {
            throw new ESBException((Throwable)e);
        }
    }

    public GetCurrentMessageResponse getCurrentMessage(GetCurrentMessage request) throws WsnbException, AbsWSStarFault {
        return this.getNotificationProducer().getCurrentMessage(request);
    }

    public SubscribeResponse subscribe(Subscribe subcribe) throws WsnbException, AbsWSStarFault {
        return this.getNotificationProducer().subscribe(subcribe);
    }
}

