package com.ebmwebsourcing.easyesb.soa.impl.endpoint.behaviour.specific;

import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

import org.petalslink.abslayer.service.api.Binding;
import org.petalslink.abslayer.service.api.Description;
import org.w3c.dom.Document;

import com.ebmwebsourcing.easycommons.research.util.esb.ESBUtil;
import com.ebmwebsourcing.easycommons.research.util.esb.EndpointAddress;
import com.ebmwebsourcing.easyesb.exchange10.api.element.Exchange;
import com.ebmwebsourcing.easyesb.soa.api.ESBException;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.ClientProxyEndpoint;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.behaviour.AbstractEndpointBehaviourImpl;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.behaviour.specific.ClientProxyBehaviour;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.external.ExternalListener;
import com.ebmwebsourcing.easyesb.soa10.api.type.ClientProxyEndpointType;
import com.ebmwebsourcing.easyesb.transporter.api.transport.TransportException;

public class ClientProxyBehaviourImpl extends AbstractEndpointBehaviourImpl implements ClientProxyBehaviour {

	private static Logger log = Logger.getLogger(ClientProxyBehaviourImpl.class.getName());
	
	private boolean firstReading = true;

	private Map<URI, Document> imports = null;
	
	private Description desc = null;

	
	public ClientProxyBehaviourImpl(ClientProxyEndpoint<? extends ClientProxyEndpointType> ep) throws ESBException {
		super(ep);
	}


	public void execute(Exchange exchange) throws TransportException {
		try {
			if(((ClientProxyEndpoint)this.endpoint).getExternalListeners().length > 1) {
				log.warning("Sorry but several listeners is not taking into account for the mmoment!!!!");
			}
			this.sendExchange2InternalProviderEndpoint(exchange);
		} catch (TransportException e) {
			throw new TransportException(e);
		}
	}


	@SuppressWarnings("unchecked")
	public Exchange sendExchange2InternalProviderEndpoint(Exchange exchange)
	throws TransportException {
		// set echange
		exchange.setSourceReference(((ClientProxyEndpoint)this.endpoint).getReference());
		EndpointAddress epr = new EndpointAddress(((ClientProxyEndpoint)this.endpoint).getProviderServiceName().getNamespaceURI(), ((ClientProxyEndpoint)this.endpoint).getProviderServiceName().getLocalPart(), ((ClientProxyEndpoint)this.endpoint).getProviderEndpointName());
		URI destinationReference = ESBUtil.generateURI(epr);
		exchange.setDestinationReference(destinationReference);
		exchange.setServiceName(((ClientProxyEndpoint)this.endpoint).getProviderServiceName());
//		exchange.setPattern(PatternType.IN_OUT);

		log.finest("external request send to " + exchange.getDestinationReference()+ " on operation: " + exchange.getOperation());
	
		
		// send exchange
		Exchange ex = ((ClientProxyEndpoint)this.endpoint).sendSync(exchange, 0);
		
		
		return ex;
	}

	@SuppressWarnings("unchecked")
	@Override
	public Description getDescription2Provider() {
		if(firstReading || desc == null) {
			try {
				EndpointAddress epr = new EndpointAddress(((ClientProxyEndpoint)this.endpoint).getProviderServiceName(), ((ClientProxyEndpoint)this.endpoint).getProviderEndpointName());
				URI destinationReference = ESBUtil.generateURI(epr);
				desc = ((ClientProxyEndpoint)this.endpoint).getDescriptionOfProviderEndpoint(destinationReference);
				
//				this.imports = desc.deleteImportedDocumentsInWsdl(new URI(((ClientProxyEndpoint)this.endpoint).getExternalAddress() +"?wsdl="));
				
				this.endpoint.setDescription(desc);
			} catch (ESBException e) {
				e.printStackTrace();
				desc = null;
			} 
			this.firstReading = false;
		}
		return desc;
	}

	@Override
	public Map<URI, Document> getImports() {
		return imports;
	}

	@Override
	public Binding getBinding() {
		return null;
	}

	@Override
	public void setBinding(Binding b) {
		throw new UnsupportedOperationException();
	}

}
