/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easyesb.soa.impl.endpoint;

import com.ebmwebsourcing.easyesb.soa.api.ESBException;
import com.ebmwebsourcing.easyesb.soa.api.SOAElement;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.ClientProxyEndpoint;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.behaviour.specific.ClientProxyBehaviour;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.external.ExternalListener;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.external.ExternalServer;
import com.ebmwebsourcing.easyesb.soa.api.node.NodeBehaviour;
import com.ebmwebsourcing.easyesb.soa.impl.endpoint.AbstractEndpointImpl;
import com.ebmwebsourcing.easyesb.soa.impl.endpoint.ClientEndpointImpl;
import com.ebmwebsourcing.easyesb.soa10.api.type.ClientProxyEndpointType;
import com.ebmwebsourcing.easyesb.soa10.api.type.ListenerInitialisationType;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.oasisopen.sca.annotation.PolicySets;
import org.oasisopen.sca.annotation.Scope;
import org.oasisopen.sca.annotation.Service;
import org.petalslink.abslayer.service.api.Description;

@Scope(value="COMPOSITE")
@Service(value={ClientProxyEndpoint.class}, names={"service"})
@PolicySets(value={"frascati:scaEasyPrimitive"})
public class ClientProxyEndpointImpl<M extends ClientProxyEndpointType>
extends ClientEndpointImpl<M>
implements ClientProxyEndpoint<M> {
    private static final long serialVersionUID = 1L;
    private static Logger log = Logger.getLogger(AbstractEndpointImpl.class.getName());
    private List<ExternalListener> listeners = new ArrayList<ExternalListener>();

    public ClientProxyEndpointImpl() throws ESBException {
    }

    public ClientProxyEndpointImpl(M model, SOAElement<?> parent) throws ESBException {
        super(model, parent);
    }

    @Override
    public void init() throws ESBException {
        super.init();
        try {
            ListenerInitialisationType[] listenerInitialisationTypeArray = ((ClientProxyEndpointType)this.getModel()).getListenerInitialisations();
            int n = listenerInitialisationTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                ListenerInitialisationType listenerInit = listenerInitialisationTypeArray[n2];
                ExternalServer server = this.findServer(listenerInit.getServerName());
                if (server == null) {
                    throw new ESBException("Impossible to find server: " + listenerInit.getServerName());
                }
                ExternalListener listener = this.createExternalListenerFormClass(Class.forName(listenerInit.getClassName()), server);
                this.listeners.add(listener);
                ++n2;
            }
        }
        catch (ClassNotFoundException e) {
            throw new ESBException((Throwable)e);
        }
    }

    private ExternalServer findServer(String serverName) {
        ExternalServer server = ((NodeBehaviour)this.getNode().findBehaviour(NodeBehaviour.class)).getExternalServer(serverName);
        return server;
    }

    protected ExternalListener createExternalListenerFormClass(Class<? extends ExternalListener> behaviourClass, ExternalServer server) throws ESBException {
        ExternalListener res = null;
        if (behaviourClass != null) {
            if (behaviourClass.isInterface()) {
                throw new ESBException("Impossible to add an interface, give the implementation");
            }
            log.fine("create externalListener: " + behaviourClass);
            try {
                Constructor<?> constructor = behaviourClass.getConstructors()[0];
                res = (ExternalListener)constructor.newInstance(new Object[]{this, server});
            }
            catch (IllegalArgumentException e) {
                log.severe("ERROR : " + e.getMessage());
                e.printStackTrace();
                throw new ESBException((Throwable)e);
            }
            catch (InstantiationException e) {
                log.severe("ERROR : " + e.getMessage());
                e.printStackTrace();
                throw new ESBException((Throwable)e);
            }
            catch (IllegalAccessException e) {
                log.severe("ERROR : " + e.getMessage());
                e.printStackTrace();
                throw new ESBException((Throwable)e);
            }
            catch (InvocationTargetException e) {
                log.severe("ERROR : " + e.getMessage());
                e.printStackTrace();
                throw new ESBException((Throwable)e);
            }
            catch (SecurityException e) {
                log.severe("ERROR : " + e.getMessage());
                e.printStackTrace();
                throw new ESBException((Throwable)e);
            }
        }
        return res;
    }

    public String getProviderEndpointName() {
        return ((ClientProxyEndpointType)this.model).getProviderEndpointName();
    }

    public void setProviderEndpointName(String providerQName) {
        ((ClientProxyEndpointType)this.model).setProviderEndpointName(providerQName);
    }

    @Override
    public Class<M> getModelClass() {
        Class res = null;
        res = this.model != null ? ((ClientProxyEndpointType)this.model).getClass() : ClientProxyEndpointType.class;
        return res;
    }

    public QName getProviderServiceName() {
        return ((ClientProxyEndpointType)this.model).getProviderServiceName();
    }

    public void setProviderServiceName(QName providerQName) {
        ((ClientProxyEndpointType)this.model).setProviderServiceName(providerQName);
    }

    @Override
    public Description getDescription() {
        ClientProxyBehaviour cpb;
        if (this.description == null && (cpb = this.findBehaviour(ClientProxyBehaviour.class)) != null) {
            this.description = cpb.getDescription2Provider();
        }
        return this.description;
    }

    public ExternalListener[] getExternalListeners() {
        return this.listeners.toArray(new ExternalListener[this.listeners.size()]);
    }
}

