package com.ebmwebsourcing.easyesb.soa.impl.endpoint.resolver;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.sax.SAXSource;

import org.xml.sax.InputSource;

import com.ebmwebsourcing.easycommons.uri.URIHelper;


public class EasyESBInternalURIResolver implements URIResolver {


    private List<URI> importedURI = Collections.synchronizedList(new ArrayList<URI>());
    
    @Override
    public Source resolve(String href, String base) throws TransformerException {
        Source s = null;
        if(base == null) {
            URI systemId = URI.create(href);
            if(!systemId.isAbsolute() && !"jar".equals(systemId.getScheme())) {
                List<URI> newImportedURIs = new ArrayList<URI>();
                for(URI potentialBaseUri: importedURI) {
                    URI newURI;
                    try {
                        newURI = URIHelper.resolve(potentialBaseUri, href);
                        newImportedURIs.add(newURI);
                        InputStream is = newURI.toURL().openStream();
                        s = new SAXSource(new InputSource());
                        is.close();
                    } catch (MalformedURLException e) {
                        // do nothing
                    } catch (URISyntaxException e) {
                        // do nothing
                    } catch (IOException e) {
                        // do nothing
                    }
                    if(s != null) {
                        break;
                    }
                }
                for(URI uri: newImportedURIs) {
                    this.addImportedURI(uri);
                }
                
                if(s == null) {
                    URL newUrl = Thread.currentThread().getContextClassLoader().getResource(href);
                    try {
                        s  = new SAXSource(new InputSource(newUrl.openStream()));
                    } catch (IOException e) {
                        // do nothing
                    }
                }
            }
        }
        return s;
    }

    public void addImportedURI(URI uri) {
        if(!importedURI.contains(uri)) {
            this.importedURI.add(uri);
        }
    }
    

}
