/*******************************************************************************
 * Copyright (c) 2011 EBM Websourcing.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v2.1
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * 
 * Contributors:
 *     EBM Websourcing - initial API and implementation
 ******************************************************************************/
package com.ebmwebsourcing.easyesb.soa10.api.type;

import java.net.URI;

import javax.xml.namespace.QName;

import com.ebmwebsourcing.easybox.api.XmlObject;
import com.ebmwebsourcing.easyesb.soa10.api.element.BasicNodeInformations;
import com.ebmwebsourcing.easyesb.soa10.api.element.BehavioursList;
import com.ebmwebsourcing.easyesb.soa10.api.element.EndpointInitialContext;

public abstract interface EndpointType extends XmlObject {


	   URI getReference();
	   
	   void setReference(URI value);
	   
	   boolean hasReference();
	   
	   QName getNode();
	   
	   void setNode(QName value);
	   
	   boolean hasNode();
	   
	   String getType();
	   
	   void setType(String value);
	   
	   boolean hasType();
	   
	   BehavioursList getBehavioursList();
	   
	   void setBehavioursList(BehavioursList value);
	   
	   boolean hasBehavioursList();
	   
	   BasicNodeInformations getBasicNodeInformations();
	   
	   void setBasicNodeInformations(BasicNodeInformations value);
	   
	   boolean hasBasicNodeInformations();
	   
	   EndpointInitialContext getEndpointInitialContext();
	   
	   void setEndpointInitialContext(EndpointInitialContext value);
	   
	   boolean hasEndpointInitialContext();
	   
	   Object getModelObject();
}
