/*******************************************************************************
 * Copyright (c) 2011 EBM Websourcing.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v2.1
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * 
 * Contributors:
 *     EBM Websourcing - initial API and implementation
 ******************************************************************************/
package com.ebmwebsourcing.easyesb.soa10.impl;



import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easybox.impl.AbstractJaxbXmlObjectImpl;
import com.ebmwebsourcing.easyesb.soa10.api.type.InitializationInterceptorListType;

import easybox.easyesb.petalslink.com.soa.model.datatype._1.EJaxbInitializationInterceptorListType;


class InitializationInterceptorListTypeImpl extends AbstractJaxbXmlObjectImpl<EJaxbInitializationInterceptorListType> implements
InitializationInterceptorListType {

	protected InitializationInterceptorListTypeImpl(XmlContext xmlContext, EJaxbInitializationInterceptorListType jaxbModel) {
		super(xmlContext, jaxbModel);
	}


	@Override
	protected Class<? extends EJaxbInitializationInterceptorListType> getCompliantModelClass() {
		return EJaxbInitializationInterceptorListType.class;
	}


	@Override
	public String[] getInterceptorClassName() {
		return this.getModelObject().getInterceptorClassName().toArray(new String[this.getModelObject().getInterceptorClassName().size()]);
	}


	@Override
	public void addInterceptorClassName(String c) {
		this.getModelObject().getInterceptorClassName().add(c);
	}


	@Override
	public void removeInterceptorClassName(String c) {
		this.getModelObject().getInterceptorClassName().remove(c);
	}


	@Override
	public void clearInterceptorClassNames() {
		this.getModelObject().getInterceptorClassName().clear();
	}






}
