/*******************************************************************************
 * Copyright (c) 2011 EBM Websourcing.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v2.1
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * 
 * Contributors:
 *     EBM Websourcing - initial API and implementation
 ******************************************************************************/
package com.ebmwebsourcing.easyesb.soa10.impl;



import java.net.URI;

import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easybox.impl.AbstractJaxbXmlObjectImpl;
import com.ebmwebsourcing.easyesb.soa10.api.type.URIListType;

import easybox.easyesb.petalslink.com.soa.model.datatype._1.EJaxbURIListType;


class URIListTypeImpl extends AbstractJaxbXmlObjectImpl<EJaxbURIListType> implements
URIListType {

	protected URIListTypeImpl(XmlContext xmlContext, EJaxbURIListType jaxbModel) {
		super(xmlContext, jaxbModel);
	}


	@Override
	protected Class<? extends EJaxbURIListType> getCompliantModelClass() {
		return EJaxbURIListType.class;
	}


	@Override
	public URI[] getURIs() {
		return (URI[]) this.getModelObject().getName().toArray();
	}


	@Override
	public void addURI(URI nn) {
		this.getModelObject().getName().add(nn.toString());
	}


	@Override
	public void removeURI(URI nn) {
		this.getModelObject().getName().remove(nn.toString());
	}


	@Override
	public void clearURIs() {
		this.getModelObject().getName().clear();
	}


}
