/*******************************************************************************
 * Copyright (c) 2011 EBM Websourcing.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v2.1
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * 
 * Contributors:
 *     EBM Websourcing - initial API and implementation
 ******************************************************************************/
package com.ebmwebsourcing.easyesb.technical.service.admin.impl.service;

import org.oasisopen.sca.annotation.PolicySets;
import org.oasisopen.sca.annotation.Scope;
import org.oasisopen.sca.annotation.Service;

import com.ebmwebsourcing.easyesb.soa.api.ESBException;
import com.ebmwebsourcing.easyesb.soa.api.SOAElement;
import com.ebmwebsourcing.easyesb.soa.impl.service.TechnicalServiceImpl;
import com.ebmwebsourcing.easyesb.soa10.api.type.TechnicalServiceType;
import com.ebmwebsourcing.easyesb.technical.service.admin.api.service.AdminService;

@Scope("COMPOSITE")
@Service(value=AdminService.class, names="service")
@PolicySets("frascati:scaEasyCompositeWithContent")
public class AdminServiceImpl<M extends TechnicalServiceType> extends TechnicalServiceImpl<M> implements AdminService<M> {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	
	public AdminServiceImpl() {
		super();
	}
	
	public AdminServiceImpl(M model, SOAElement<?> parent) throws ESBException {
		super(model, parent);
	}

	public Class<M> getModelClass() {
		Class<M> res = null;
		if(model != null) {
			res = (Class<M>) model.getClass();
		} else {
			res = (Class<M>) TechnicalServiceType.class;
		}
		return res;
	}
}
