/*******************************************************************************
 * Copyright (c) 2011 EBM Websourcing.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v2.1
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * 
 * Contributors:
 *     EBM Websourcing - initial API and implementation
 ******************************************************************************/
package com.ebmwebsourcing.easyesb.technical.service.admin.impl.endpoint;

import java.util.logging.Logger;

import org.oasisopen.sca.annotation.PolicySets;
import org.oasisopen.sca.annotation.Scope;
import org.oasisopen.sca.annotation.Service;

import com.ebmwebsourcing.easyesb.soa.api.ESBException;
import com.ebmwebsourcing.easyesb.soa.api.SOAElement;
import com.ebmwebsourcing.easyesb.soa.impl.endpoint.ProviderEndpointImpl;
import com.ebmwebsourcing.easyesb.soa10.api.type.ProviderEndpointType;
import com.ebmwebsourcing.easyesb.technical.service.admin.api.endpoint.AdminEndpoint;

@Scope("COMPOSITE")
@Service(value=AdminEndpoint.class, names="service")
@PolicySets("frascati:scaEasyPrimitive")
public class AdminEndpointImpl<M extends ProviderEndpointType> extends ProviderEndpointImpl<M> implements AdminEndpoint<M> {
	
	private Logger log = Logger.getLogger(AdminEndpointImpl.class.getName());
	
	private static final long serialVersionUID = 1L;
		
	public AdminEndpointImpl() throws ESBException {
		super();
	}
	
	public AdminEndpointImpl(M model, SOAElement<?> parent) throws ESBException {
		super(model, parent);
	}
	
	public Class<M> getModelClass() {
		Class<M> res = null;
		if(model != null) {
			res = (Class<M>) model.getClass();
		} else {
			res = (Class<M>) ProviderEndpointType.class;
		}
		return res;
	}
	
}
