/*******************************************************************************
 * Copyright (c) 2011 EBM Websourcing.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v2.1
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * 
 * Contributors:
 *     EBM Websourcing - initial API and implementation
 ******************************************************************************/
package com.ebmwebsourcing.easyesb.technical.service.admin.impl.endpoint.behaviour;

import java.net.URL;
import java.util.logging.Logger;

import javax.xml.namespace.QName;

import org.jdom.input.DOMBuilder;
import org.oasis_open.docs.wsn.bw_2.InvalidFilterFault;
import org.oasis_open.docs.wsn.bw_2.InvalidMessageContentExpressionFault;
import org.oasis_open.docs.wsn.bw_2.InvalidProducerPropertiesExpressionFault;
import org.oasis_open.docs.wsn.bw_2.InvalidTopicExpressionFault;
import org.oasis_open.docs.wsn.bw_2.NotifyMessageNotSupportedFault;
import org.oasis_open.docs.wsn.bw_2.SubscribeCreationFailedFault;
import org.oasis_open.docs.wsn.bw_2.TopicExpressionDialectUnknownFault;
import org.oasis_open.docs.wsn.bw_2.TopicNotSupportedFault;
import org.oasis_open.docs.wsn.bw_2.UnableToDestroySubscriptionFault;
import org.oasis_open.docs.wsn.bw_2.UnacceptableInitialTerminationTimeFault;
import org.oasis_open.docs.wsn.bw_2.UnrecognizedPolicyRequestFault;
import org.oasis_open.docs.wsn.bw_2.UnsupportedPolicyRequestFault;
import org.oasis_open.docs.wsrf.rpw_2.InvalidResourcePropertyQNameFault;
import org.oasis_open.docs.wsrf.rw_2.ResourceUnavailableFault;
import org.oasis_open.docs.wsrf.rw_2.ResourceUnknownFault;
import org.petalslink.abslayer.Factory;
import org.petalslink.abslayer.service.api.Binding;
import org.petalslink.abslayer.service.api.Description;
import org.w3c.dom.Document;

import com.ebmwebsourcing.easybox.api.XmlObjectReadException;
import com.ebmwebsourcing.easycommons.research.util.SOAException;
import com.ebmwebsourcing.easycommons.research.util.easybox.SOAUtil;
import com.ebmwebsourcing.easycommons.research.util.jaxb.SOAJAXBContext;
import com.ebmwebsourcing.easycommons.soap.handler.SOAPException;
import com.ebmwebsourcing.easycommons.soap.handler.SOAPHandler;
import com.ebmwebsourcing.easycommons.xml.XMLPrettyPrinter;
import com.ebmwebsourcing.easyesb.constant.EasyESBFramework;
import com.ebmwebsourcing.easyesb.exchange10.api.element.Exchange;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.behaviour.AbstractEndpointBehaviourImpl;
import com.ebmwebsourcing.easyesb.soa.api.util.MessageUtil;
import com.ebmwebsourcing.easyesb.soa10.api.type.ProviderEndpointType;
import com.ebmwebsourcing.easyesb.technical.service.admin.api.endpoint.AdminEndpoint;
import com.ebmwebsourcing.easyesb.technical.service.admin.api.endpoint.behaviour.AdminManagementEndpointBehaviour;
import com.ebmwebsourcing.easyesb.technical.service.admin.api.endpoint.behaviour.BaseAdminEndpointBehaviour;
import com.ebmwebsourcing.easyesb.transporter.api.transport.TransportException;
import com.ebmwebsourcing.easywsdl11.api.element.Definitions;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.utils.WsnbException;
import com.ebmwebsourcing.wsstar.wsnb.services.impl.util.WSNHelper;

import easybox.esstar.petalslink.com.management.model.datatype._1.EJaxbConnectToGovernance;
import easybox.esstar.petalslink.com.management.model.datatype._1.EJaxbConnectToGovernanceResponse;
import easybox.esstar.petalslink.com.management.model.datatype._1.EJaxbDeploy;
import easybox.esstar.petalslink.com.management.model.datatype._1.EJaxbDeployResponse;
import easybox.esstar.petalslink.com.management.model.datatype._1.EJaxbUnconnectToGovernance;
import easybox.esstar.petalslink.com.management.model.datatype._1.EJaxbUnconnectToGovernanceResponse;
import easybox.esstar.petalslink.com.management.model.datatype._1.EJaxbUndeploy;
import easybox.esstar.petalslink.com.management.model.datatype._1.EJaxbUndeployResponse;
import easybox.esstar.petalslink.com.management.model.datatype._1.ObjectFactory;
import easybox.org.oasis_open.docs.wsn.b_2.EJaxbNotify;
import easybox.org.oasis_open.docs.wsn.b_2.EJaxbSubscribe;
import easybox.org.oasis_open.docs.wsn.b_2.EJaxbSubscribeResponse;
import easybox.org.oasis_open.docs.wsn.b_2.EJaxbUnsubscribe;
import easybox.org.oasis_open.docs.wsn.b_2.EJaxbUnsubscribeResponse;
import easybox.org.oasis_open.docs.wsrf.rp_2.EJaxbGetResourcePropertyResponse;
import esstar.petalslink.com.data.management.admin._1.GetAdditionalContent;
import esstar.petalslink.com.data.management.admin._1.GetAdditionalContentResponse;
import esstar.petalslink.com.data.management.admin._1.GetContent;
import esstar.petalslink.com.data.management.admin._1.GetContentResponse;
import esstar.petalslink.com.data.management.admin._1.GetExecutionEnvironmentInformation;
import esstar.petalslink.com.data.management.admin._1.GetExecutionEnvironmentInformationResponse;
import esstar.petalslink.com.data.management.admin._1.GetResourceIdentifiers;
import esstar.petalslink.com.data.management.admin._1.GetResourceIdentifiersResponse;
import esstar.petalslink.com.service.management._1_0.ManagementException;



public class AdminManagementEndpointBehaviourImpl extends AbstractEndpointBehaviourImpl implements AdminManagementEndpointBehaviour {

	private Logger log = Logger.getLogger(AdminManagementEndpointBehaviourImpl.class.getName());

	@SuppressWarnings("unused")
	private ObjectFactory factory = new ObjectFactory();

	private BaseAdminEndpointBehaviour adminEndpointBehaviour = null;

	private static Binding b; 

	static {
		try {
			// ADD ADMIN JAXB FACTORY
			SOAJAXBContext.getInstance().addOtherObjectFactory(ObjectFactory.class, esstar.petalslink.com.data.management.admin._1.ObjectFactory.class);
		} catch (SOAException e) {
			e.printStackTrace();
		}

		try {
			URL url = Thread.currentThread().getContextClassLoader().getResource(DESCRIPTION_URL);
			Description desc = (Description) Factory.getInstance().wrap(SOAUtil.getInstance().getReader(EasyESBFramework.getInstance()).get().readDocument(url, Definitions.class));
			b = desc.getBindings().iterator().next();
		} catch (XmlObjectReadException e) {
			e.printStackTrace();
			throw new RuntimeException();
		} 
	}

	public AdminManagementEndpointBehaviourImpl(AdminEndpoint<? extends ProviderEndpointType> ep) {
		super(ep);
		this.setBinding(b);

	}

	public void execute(Exchange exchange) throws TransportException {
		try {
			if(exchange.getMessageIn().getBody().getPayload() == null) {
				throw new TransportException("the message in cannot be null");
			}

			// convert dom to jdom
			DOMBuilder builder = new DOMBuilder();
			org.jdom.Document doc = builder.build(exchange.getMessageIn().getBody().getPayload());

			if(doc.getRootElement() != null &&
					doc.getRootElement().getName().equals("getExecutionEnvironmentInformation")) {
				log.finest("CREATE getExecutionEnvironmentInformation METHOD");

				GetExecutionEnvironmentInformation request = SOAJAXBContext.getInstance().marshallAnyType(exchange.getMessageIn().getBody().getPayload(), GetExecutionEnvironmentInformation.class);
				GetExecutionEnvironmentInformationResponse response = this.getExecutionEnvironmentInformation(request);

				Document docResp = SOAJAXBContext.getInstance().unmarshallAnyElement(response);

				MessageUtil.getInstance().createOutMessageStructure(exchange);
				exchange.getMessageOut().getBody().setPayload(docResp);
			} else if(doc.getRootElement() != null &&
					doc.getRootElement().getName().equals("getResourceIdentifiers")) {
				log.finest("CREATE getResourceIdentifiers METHOD");

				GetResourceIdentifiers request = SOAJAXBContext.getInstance().marshallAnyType(exchange.getMessageIn().getBody().getPayload(), GetResourceIdentifiers.class);
				GetResourceIdentifiersResponse response = this.getResourceIdentifiers(request);

				Document docResp = SOAJAXBContext.getInstance().unmarshallAnyElement(response);

				MessageUtil.getInstance().createOutMessageStructure(exchange);
				exchange.getMessageOut().getBody().setPayload(docResp);
			} else if(doc.getRootElement() != null &&
					doc.getRootElement().getName().equals("getContent")) {
				log.finest("CREATE getContent METHOD");

				GetContent request = SOAJAXBContext.getInstance().marshallAnyType(exchange.getMessageIn().getBody().getPayload(), GetContent.class);
				GetContentResponse response = this.getContent(request);

				Document docResp = SOAJAXBContext.getInstance().unmarshallAnyElement(response);

				MessageUtil.getInstance().createOutMessageStructure(exchange);
				exchange.getMessageOut().getBody().setPayload(docResp);
			} else if(doc.getRootElement() != null &&
					doc.getRootElement().getName().equals("getAdditionalContent")) {
				log.finest("CREATE getAdditionalContent METHOD");

				GetAdditionalContent request = SOAJAXBContext.getInstance().marshallAnyType(exchange.getMessageIn().getBody().getPayload(), GetAdditionalContent.class);
				GetAdditionalContentResponse response = this.getAdditionalContent(request);

				Document docResp = SOAJAXBContext.getInstance().unmarshallAnyElement(response);

				MessageUtil.getInstance().createOutMessageStructure(exchange);
				exchange.getMessageOut().getBody().setPayload(docResp);
			} else if(doc.getRootElement() != null &&
					doc.getRootElement().getName().equals("deploy")) {
				log.info("DEPLOY");

				EJaxbDeploy deploy = SOAJAXBContext.getInstance().marshallAnyType(exchange.getMessageIn().getBody().getPayload(), EJaxbDeploy.class);
				EJaxbDeployResponse response = this.deploy(deploy);

				Document docResp = SOAJAXBContext.getInstance().unmarshallAnyElement(response);

				MessageUtil.getInstance().createOutMessageStructure(exchange);
				exchange.getMessageOut().getBody().setPayload(docResp);

			}  else if(doc.getRootElement() != null &&
					doc.getRootElement().getName().equals("stop")) {
				log.info("STOP");

				this.stop();
			}  else if(doc.getRootElement() != null &&
					doc.getRootElement().getName().equals("Subscribe")) {
				log.info("SUBSCRIBE");

				EJaxbSubscribe subs = WSNHelper.marshallSubscribe(exchange.getMessageIn().getBody().getPayload());
				EJaxbSubscribeResponse res = this.subscribe(subs);
				Document docResp = SOAJAXBContext.getInstance().unmarshallAnyElement(res);


				MessageUtil.getInstance().createOutMessageStructure(exchange);
				exchange.getMessageOut().getBody().setPayload(docResp);


			}  else if(doc.getRootElement() != null &&
					doc.getRootElement().getName().equals("Unsubscribe")) {
				log.info("UNSUBSCRIBE");

				EJaxbUnsubscribe unsubscribe = SOAJAXBContext.getInstance().marshallAnyType(exchange.getMessageIn().getBody().getPayload(), EJaxbUnsubscribe.class);
				EJaxbUnsubscribeResponse response = this.unsubscribe(unsubscribe);

				Document docResp = SOAJAXBContext.getInstance().unmarshallAnyElement(response);

				MessageUtil.getInstance().createOutMessageStructure(exchange);
				exchange.getMessageOut().getBody().setPayload(docResp);

			}  else if(doc.getRootElement() != null &&
					doc.getRootElement().getName().equals("Notify")) {
				log.info("NOTIFY");

				EJaxbNotify notify =  WSNHelper.marshallNotify(exchange.getMessageIn().getBody().getPayload());
				this.notify(notify);

			}  else if(doc.getRootElement() != null &&
					doc.getRootElement().getName().equals("GetResourceProperty")) {
				log.info("GET_RESOURCE_PROPERTY");

				QName name = SOAJAXBContext.getInstance().marshallAnyType(exchange.getMessageIn().getBody().getPayload(), QName.class);
				EJaxbGetResourcePropertyResponse response = this.getResourceProperty(name);

				Document docResp = SOAJAXBContext.getInstance().unmarshallAnyElement(response);

				MessageUtil.getInstance().createOutMessageStructure(exchange);
				exchange.getMessageOut().getBody().setPayload(docResp);

			} else if(doc.getRootElement() != null &&
					doc.getRootElement().getName().equals("connectToGovernance")) {
				log.finest("CREATE connectToGovernance METHOD");

				EJaxbConnectToGovernance request = SOAJAXBContext.getInstance().marshallAnyType(exchange.getMessageIn().getBody().getPayload(), EJaxbConnectToGovernance.class);
				this.connectToGovernance(request.getAddress());
				EJaxbConnectToGovernanceResponse response = new EJaxbConnectToGovernanceResponse();

				Document docResp = SOAJAXBContext.getInstance().unmarshallAnyElement(response);

				MessageUtil.getInstance().createOutMessageStructure(exchange);
				exchange.getMessageOut().getBody().setPayload(docResp);
			} else if(doc.getRootElement() != null &&
					doc.getRootElement().getName().equals("unconnectToGovernance")) {
				log.finest("CREATE unconnectToGovernance METHOD");

				EJaxbUnconnectToGovernance request = SOAJAXBContext.getInstance().marshallAnyType(exchange.getMessageIn().getBody().getPayload(), EJaxbUnconnectToGovernance.class);
				this.unconnectToGovernance(request.getAddress());
				EJaxbUnconnectToGovernanceResponse response = new EJaxbUnconnectToGovernanceResponse();

				Document docResp = SOAJAXBContext.getInstance().unmarshallAnyElement(response);

				MessageUtil.getInstance().createOutMessageStructure(exchange);
				exchange.getMessageOut().getBody().setPayload(docResp);
			}
		} catch (ManagementException e) {
			try {
				Document docEx = SOAJAXBContext.getInstance().unmarshallAnyElement(e.getFaultInfo());
				Document fault = SOAPHandler.createSoapFault(docEx);
				MessageUtil.getInstance().createErrorMessageStructure(exchange);
				exchange.getMessageError().getBody().setPayload(fault);
				log.severe("ERROR EX: " + XMLPrettyPrinter.prettyPrint(exchange.getMessageError().getBody().getPayload()));
			} catch (SOAException ex) {
				throw new TransportException(ex);
			} catch (SOAPException ex) {
				throw new TransportException(ex);
			}
		} catch (ResourceUnknownFault e) {
			try {
				Document docEx = SOAJAXBContext.getInstance().unmarshallAnyElement(e.getFaultInfo());
				Document fault = SOAPHandler.createSoapFault(docEx);
				MessageUtil.getInstance().createErrorMessageStructure(exchange);
				exchange.getMessageError().getBody().setPayload(fault);
				log.severe("ERROR EX: " + XMLPrettyPrinter.prettyPrint(exchange.getMessageError().getBody().getPayload()));
			} catch (SOAException ex) {
				throw new TransportException(ex);
			} catch (SOAPException ex) {
				throw new TransportException(ex);
			}
		} catch (UnableToDestroySubscriptionFault e) {
			try {
				Document docEx = SOAJAXBContext.getInstance().unmarshallAnyElement(e.getFaultInfo());
				Document fault = SOAPHandler.createSoapFault(docEx);
				MessageUtil.getInstance().createErrorMessageStructure(exchange);
				exchange.getMessageError().getBody().setPayload(fault);
				log.severe("ERROR EX: " + XMLPrettyPrinter.prettyPrint(exchange.getMessageError().getBody().getPayload()));
			} catch (SOAException ex) {
				throw new TransportException(ex);
			} catch (SOAPException ex) {
				throw new TransportException(ex);
			}
		} catch (SOAException e) {
			throw new TransportException(e);
		} catch (TopicNotSupportedFault e) {
			try {
				Document docEx = SOAJAXBContext.getInstance().unmarshallAnyElement(e.getFaultInfo());
				Document fault = SOAPHandler.createSoapFault(docEx);
				MessageUtil.getInstance().createErrorMessageStructure(exchange);
				exchange.getMessageError().getBody().setPayload(fault);
				log.severe("ERROR EX: " + XMLPrettyPrinter.prettyPrint(exchange.getMessageError().getBody().getPayload()));
			} catch (SOAException ex) {
				throw new TransportException(ex);
			} catch (SOAPException ex) {
				throw new TransportException(ex);
			}
		} catch (ResourceUnavailableFault e) {
			try {
				Document docEx = SOAJAXBContext.getInstance().unmarshallAnyElement(e.getFaultInfo());
				Document fault = SOAPHandler.createSoapFault(docEx);
				MessageUtil.getInstance().createErrorMessageStructure(exchange);
				exchange.getMessageError().getBody().setPayload(fault);
				log.severe("ERROR EX: " + XMLPrettyPrinter.prettyPrint(exchange.getMessageError().getBody().getPayload()));
			} catch (SOAException ex) {
				throw new TransportException(ex);
			} catch (SOAPException ex) {
				throw new TransportException(ex);
			}
		} catch (InvalidResourcePropertyQNameFault e) {
			try {
				Document docEx = SOAJAXBContext.getInstance().unmarshallAnyElement(e.getFaultInfo());
				Document fault = SOAPHandler.createSoapFault(docEx);
				MessageUtil.getInstance().createErrorMessageStructure(exchange);
				exchange.getMessageError().getBody().setPayload(fault);
				log.severe("ERROR EX: " + XMLPrettyPrinter.prettyPrint(exchange.getMessageError().getBody().getPayload()));
			} catch (SOAException ex) {
				throw new TransportException(ex);
			} catch (SOAPException ex) {
				throw new TransportException(ex);
			}
		} catch (NotifyMessageNotSupportedFault e) {
			try {
				Document docEx = SOAJAXBContext.getInstance().unmarshallAnyElement(e.getFaultInfo());
				Document fault = SOAPHandler.createSoapFault(docEx);
				MessageUtil.getInstance().createErrorMessageStructure(exchange);
				exchange.getMessageError().getBody().setPayload(fault);
				log.severe("ERROR EX: " + XMLPrettyPrinter.prettyPrint(exchange.getMessageError().getBody().getPayload()));
			} catch (SOAException ex) {
				throw new TransportException(ex);
			} catch (SOAPException ex) {
				throw new TransportException(ex);
			}
		} catch (InvalidFilterFault e) {
			try {
				Document docEx = SOAJAXBContext.getInstance().unmarshallAnyElement(e.getFaultInfo());
				Document fault = SOAPHandler.createSoapFault(docEx);
				MessageUtil.getInstance().createErrorMessageStructure(exchange);
				exchange.getMessageError().getBody().setPayload(fault);
				log.severe("ERROR EX: " + XMLPrettyPrinter.prettyPrint(exchange.getMessageError().getBody().getPayload()));
			} catch (SOAException ex) {
				throw new TransportException(ex);
			} catch (SOAPException ex) {
				throw new TransportException(ex);
			}
		} catch (InvalidTopicExpressionFault e) {
			try {
				Document docEx = SOAJAXBContext.getInstance().unmarshallAnyElement(e.getFaultInfo());
				Document fault = SOAPHandler.createSoapFault(docEx);
				MessageUtil.getInstance().createErrorMessageStructure(exchange);
				exchange.getMessageError().getBody().setPayload(fault);
				log.severe("ERROR EX: " + XMLPrettyPrinter.prettyPrint(exchange.getMessageError().getBody().getPayload()));
			} catch (SOAException ex) {
				throw new TransportException(ex);
			} catch (SOAPException ex) {
				throw new TransportException(ex);
			}
		} catch (TopicExpressionDialectUnknownFault e) {
			try {
				Document docEx = SOAJAXBContext.getInstance().unmarshallAnyElement(e.getFaultInfo());
				Document fault = SOAPHandler.createSoapFault(docEx);
				MessageUtil.getInstance().createErrorMessageStructure(exchange);
				exchange.getMessageError().getBody().setPayload(fault);
				log.severe("ERROR EX: " + XMLPrettyPrinter.prettyPrint(exchange.getMessageError().getBody().getPayload()));
			} catch (SOAException ex) {
				throw new TransportException(ex);
			} catch (SOAPException ex) {
				throw new TransportException(ex);
			}
		} catch (UnsupportedPolicyRequestFault e) {
			try {
				Document docEx = SOAJAXBContext.getInstance().unmarshallAnyElement(e.getFaultInfo());
				Document fault = SOAPHandler.createSoapFault(docEx);
				MessageUtil.getInstance().createErrorMessageStructure(exchange);
				exchange.getMessageError().getBody().setPayload(fault);
				log.severe("ERROR EX: " + XMLPrettyPrinter.prettyPrint(exchange.getMessageError().getBody().getPayload()));
			} catch (SOAException ex) {
				throw new TransportException(ex);
			} catch (SOAPException ex) {
				throw new TransportException(ex);
			}
		} catch (SubscribeCreationFailedFault e) {
			try {
				Document docEx = SOAJAXBContext.getInstance().unmarshallAnyElement(e.getFaultInfo());
				Document fault = SOAPHandler.createSoapFault(docEx);
				MessageUtil.getInstance().createErrorMessageStructure(exchange);
				exchange.getMessageError().getBody().setPayload(fault);
				log.severe("ERROR EX: " + XMLPrettyPrinter.prettyPrint(exchange.getMessageError().getBody().getPayload()));
			} catch (SOAException ex) {
				throw new TransportException(ex);
			} catch (SOAPException ex) {
				throw new TransportException(ex);
			}
		} catch (UnacceptableInitialTerminationTimeFault e) {
			try {
				Document docEx = SOAJAXBContext.getInstance().unmarshallAnyElement(e.getFaultInfo());
				Document fault = SOAPHandler.createSoapFault(docEx);
				MessageUtil.getInstance().createErrorMessageStructure(exchange);
				exchange.getMessageError().getBody().setPayload(fault);
				log.severe("ERROR EX: " + XMLPrettyPrinter.prettyPrint(exchange.getMessageError().getBody().getPayload()));
			} catch (SOAException ex) {
				throw new TransportException(ex);
			} catch (SOAPException ex) {
				throw new TransportException(ex);
			}
		} catch (UnrecognizedPolicyRequestFault e) {
			try {
				Document docEx = SOAJAXBContext.getInstance().unmarshallAnyElement(e.getFaultInfo());
				Document fault = SOAPHandler.createSoapFault(docEx);
				MessageUtil.getInstance().createErrorMessageStructure(exchange);
				exchange.getMessageError().getBody().setPayload(fault);
				log.severe("ERROR EX: " + XMLPrettyPrinter.prettyPrint(exchange.getMessageError().getBody().getPayload()));
			} catch (SOAException ex) {
				throw new TransportException(ex);
			} catch (SOAPException ex) {
				throw new TransportException(ex);
			}
		} catch (InvalidProducerPropertiesExpressionFault e) {
			try {
				Document docEx = SOAJAXBContext.getInstance().unmarshallAnyElement(e.getFaultInfo());
				Document fault = SOAPHandler.createSoapFault(docEx);
				MessageUtil.getInstance().createErrorMessageStructure(exchange);
				exchange.getMessageError().getBody().setPayload(fault);
				log.severe("ERROR EX: " + XMLPrettyPrinter.prettyPrint(exchange.getMessageError().getBody().getPayload()));
			} catch (SOAException ex) {
				throw new TransportException(ex);
			} catch (SOAPException ex) {
				throw new TransportException(ex);
			}
		} catch (InvalidMessageContentExpressionFault e) {
			try {
				Document docEx = SOAJAXBContext.getInstance().unmarshallAnyElement(e.getFaultInfo());
				Document fault = SOAPHandler.createSoapFault(docEx);
				MessageUtil.getInstance().createErrorMessageStructure(exchange);
				exchange.getMessageError().getBody().setPayload(fault);
				log.severe("ERROR EX: " + XMLPrettyPrinter.prettyPrint(exchange.getMessageError().getBody().getPayload()));
			} catch (SOAException ex) {
				throw new TransportException(ex);
			} catch (SOAPException ex) {
				throw new TransportException(ex);
			}
		} catch (WsnbException e) {
			throw new TransportException(e);
		}
	}

	public BaseAdminEndpointBehaviour getAdminEndpointBehaviour() {
		return adminEndpointBehaviour;
	}

	public void setAdminEndpointBehaviour(
			BaseAdminEndpointBehaviour adminEndpointBehaviour) {
		this.adminEndpointBehaviour = adminEndpointBehaviour;
	}

	@Override
	public EJaxbDeployResponse deploy(EJaxbDeploy deploy) throws ManagementException {
		return this.getAdminEndpointBehaviour().deploy(deploy);
	}



	@Override
	public GetAdditionalContentResponse getAdditionalContent(
			GetAdditionalContent addContent) throws ManagementException {
		GetAdditionalContentResponse result = new GetAdditionalContentResponse();
		easyesb.petalslink.com.data.admin._1.GetAdditionalContent request = new easyesb.petalslink.com.data.admin._1.GetAdditionalContent();
		request.setId(addContent.getId());
		request.setResourceIdentifier(addContent.getResourceIdentifier());
		easyesb.petalslink.com.data.admin._1.GetAdditionalContentResponse response = this.getAdminEndpointBehaviour().getAdditionalContent(request);
		result.setAny(response.getAny());

		return result;
	}

	@Override
	public GetContentResponse getContent(GetContent content)
			throws ManagementException {
		GetContentResponse result = new GetContentResponse();
		easyesb.petalslink.com.data.admin._1.GetContent request = new easyesb.petalslink.com.data.admin._1.GetContent();
		request.setResourceIdentifier(content.getResourceIdentifier());
		easyesb.petalslink.com.data.admin._1.GetContentResponse response = this.getAdminEndpointBehaviour().getContent(request);
		result.setAny(response.getAny());
		return result;
	}

	@Override
	public GetExecutionEnvironmentInformationResponse getExecutionEnvironmentInformation(
			GetExecutionEnvironmentInformation env)
					throws ManagementException {
		GetExecutionEnvironmentInformationResponse result = new GetExecutionEnvironmentInformationResponse();
		easyesb.petalslink.com.data.admin._1.GetExecutionEnvironmentInformation request = new easyesb.petalslink.com.data.admin._1.GetExecutionEnvironmentInformation();
		easyesb.petalslink.com.data.admin._1.GetExecutionEnvironmentInformationResponse response = this.getAdminEndpointBehaviour().getExecutionEnvironmentInformation(request);
		result.setExecutionEnvironmentInformation(response.getExecutionEnvironmentInformation());

		return result;
	}

	@Override
	public GetResourceIdentifiersResponse getResourceIdentifiers(
			GetResourceIdentifiers arg0) throws ManagementException {
		GetResourceIdentifiersResponse result = new GetResourceIdentifiersResponse();
		easyesb.petalslink.com.data.admin._1.GetResourceIdentifiers request = new easyesb.petalslink.com.data.admin._1.GetResourceIdentifiers();
		easyesb.petalslink.com.data.admin._1.GetResourceIdentifiersResponse response = this.getAdminEndpointBehaviour().getResourceIdentifiers(request);
		result.getResourceIdentifier().addAll(response.getResourceIdentifier());

		return result;
	}

	@Override
	public void stop() {
		this.adminEndpointBehaviour.stop();
	}

	@Override
	public EJaxbGetResourcePropertyResponse getResourceProperty(QName property)
			throws ResourceUnavailableFault, InvalidResourcePropertyQNameFault,
			ResourceUnknownFault {
		return this.getAdminEndpointBehaviour().getResourceProperty(property);
	}


	@Override
	public EJaxbSubscribeResponse subscribe(EJaxbSubscribe subscribe)
			throws NotifyMessageNotSupportedFault, InvalidFilterFault,
			InvalidTopicExpressionFault, TopicExpressionDialectUnknownFault,
			UnsupportedPolicyRequestFault, SubscribeCreationFailedFault,
			UnacceptableInitialTerminationTimeFault,
			UnrecognizedPolicyRequestFault, TopicNotSupportedFault,
			InvalidProducerPropertiesExpressionFault, ResourceUnknownFault,
			InvalidMessageContentExpressionFault {
		return this.getAdminEndpointBehaviour().subscribe(subscribe);
	}

	@Override
	public EJaxbUnsubscribeResponse unsubscribe(EJaxbUnsubscribe unsubscribe)
			throws UnableToDestroySubscriptionFault, ResourceUnknownFault {
		return this.getAdminEndpointBehaviour().unsubscribe(unsubscribe);
	}

	@Override
	public void notify(EJaxbNotify notify) {
		this.getAdminEndpointBehaviour().notify(notify);
	}

	@Override
	public void connectToGovernance(String address)
			throws ManagementException {
		this.getAdminEndpointBehaviour().connectToGovernance(address);
	}

	@Override
	public void unconnectToGovernance(String address)
			throws ManagementException {
		this.getAdminEndpointBehaviour().unconnectToGovernance(address);
	}

	@Override
	public EJaxbUndeployResponse undeploy(EJaxbUndeploy undeploy)
			throws ManagementException {
		return this.getAdminEndpointBehaviour().undeploy(undeploy);
	}

}





