/*******************************************************************************
 * Copyright (c) 2011 EBM Websourcing.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v2.1
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * 
 * Contributors:
 *     EBM Websourcing - initial API and implementation
 ******************************************************************************/
package com.ebmwebsourcing.easyesb.technical.service.admin.impl.endpoint.behaviour;

import java.io.ByteArrayInputStream;
import java.net.URL;
import java.util.logging.Logger;

import javax.xml.namespace.QName;

import org.jdom.input.DOMBuilder;
import org.oasis_open.docs.wsn.bw_2.InvalidFilterFault;
import org.oasis_open.docs.wsn.bw_2.InvalidMessageContentExpressionFault;
import org.oasis_open.docs.wsn.bw_2.InvalidProducerPropertiesExpressionFault;
import org.oasis_open.docs.wsn.bw_2.InvalidTopicExpressionFault;
import org.oasis_open.docs.wsn.bw_2.NotifyMessageNotSupportedFault;
import org.oasis_open.docs.wsn.bw_2.SubscribeCreationFailedFault;
import org.oasis_open.docs.wsn.bw_2.TopicExpressionDialectUnknownFault;
import org.oasis_open.docs.wsn.bw_2.TopicNotSupportedFault;
import org.oasis_open.docs.wsn.bw_2.UnableToDestroySubscriptionFault;
import org.oasis_open.docs.wsn.bw_2.UnacceptableInitialTerminationTimeFault;
import org.oasis_open.docs.wsn.bw_2.UnrecognizedPolicyRequestFault;
import org.oasis_open.docs.wsn.bw_2.UnsupportedPolicyRequestFault;
import org.oasis_open.docs.wsrf.rpw_2.InvalidResourcePropertyQNameFault;
import org.oasis_open.docs.wsrf.rw_2.ResourceUnavailableFault;
import org.oasis_open.docs.wsrf.rw_2.ResourceUnknownFault;
import org.petalslink.abslayer.Factory;
import org.petalslink.abslayer.service.api.Binding;
import org.petalslink.abslayer.service.api.Description;
import org.w3c.dom.Document;

import com.ebmwebsourcing.easybox.api.XmlObjectReadException;
import com.ebmwebsourcing.easycommons.research.util.SOAException;
import com.ebmwebsourcing.easycommons.research.util.dom.DOMUtil;
import com.ebmwebsourcing.easycommons.research.util.easybox.SOAUtil;
import com.ebmwebsourcing.easycommons.research.util.io.ErrorUtil;
import com.ebmwebsourcing.easycommons.research.util.jaxb.SOAJAXBContext;
import com.ebmwebsourcing.easycommons.soap.handler.SOAPException;
import com.ebmwebsourcing.easycommons.soap.handler.SOAPHandler;
import com.ebmwebsourcing.easycommons.xml.XMLPrettyPrinter;
import com.ebmwebsourcing.easyesb.constant.EasyESBFramework;
import com.ebmwebsourcing.easyesb.exchange10.api.element.Exchange;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.behaviour.AbstractEndpointBehaviourImpl;
import com.ebmwebsourcing.easyesb.soa.api.util.MessageUtil;
import com.ebmwebsourcing.easyesb.soa10.api.type.ProviderEndpointType;
import com.ebmwebsourcing.easyesb.technical.service.admin.api.endpoint.AdminEndpoint;
import com.ebmwebsourcing.easyesb.technical.service.admin.api.endpoint.behaviour.BaseAdminEndpointBehaviour;
import com.ebmwebsourcing.easyesb.technical.service.admin.api.endpoint.behaviour.UserManagementEndpointBehaviour;
import com.ebmwebsourcing.easyesb.transporter.api.transport.TransportException;
import com.ebmwebsourcing.easywsdl11.api.element.Definitions;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.utils.WsnbException;
import com.ebmwebsourcing.wsstar.wsnb.services.impl.util.WSNHelper;

import easybox.esstar.petalslink.com.management.model.datatype._1.EJaxbDeploy;
import easybox.esstar.petalslink.com.management.model.datatype._1.EJaxbDeployResponse;
import easybox.esstar.petalslink.com.management.model.datatype._1.EJaxbUndeploy;
import easybox.esstar.petalslink.com.management.model.datatype._1.EJaxbUndeployResponse;
import easybox.esstar.petalslink.com.management.model.datatype._1.ObjectFactory;
import easybox.org.oasis_open.docs.wsn.b_2.EJaxbNotify;
import easybox.org.oasis_open.docs.wsn.b_2.EJaxbSubscribe;
import easybox.org.oasis_open.docs.wsn.b_2.EJaxbSubscribeResponse;
import easybox.org.oasis_open.docs.wsn.b_2.EJaxbUnsubscribe;
import easybox.org.oasis_open.docs.wsn.b_2.EJaxbUnsubscribeResponse;
import easybox.org.oasis_open.docs.wsrf.rp_2.EJaxbGetResourcePropertyResponse;
import esstar.petalslink.com.data.management.user._1.Bind;
import esstar.petalslink.com.data.management.user._1.BindResponse;
import esstar.petalslink.com.data.management.user._1.Expose;
import esstar.petalslink.com.data.management.user._1.ExposeResponse;
import esstar.petalslink.com.data.management.user._1.Proxify;
import esstar.petalslink.com.data.management.user._1.ProxifyResponse;
import esstar.petalslink.com.service.management._1_0.ManagementException;



public class UserManagementEndpointBehaviourImpl extends AbstractEndpointBehaviourImpl implements UserManagementEndpointBehaviour {

	private Logger log = Logger.getLogger(UserManagementEndpointBehaviourImpl.class.getName());

	@SuppressWarnings("unused")
	private ObjectFactory factory = new ObjectFactory();

	private BaseAdminEndpointBehaviour adminEndpointBehaviour = null;

	private static Binding b; 

	static {
		try {
			// ADD ADMIN JAXB FACTORY
			SOAJAXBContext.getInstance().addOtherObjectFactory(ObjectFactory.class, esstar.petalslink.com.data.management.user._1.ObjectFactory.class);
		} catch (SOAException e) {
			e.printStackTrace();
		}

		try {
			URL url = Thread.currentThread().getContextClassLoader().getResource(DESCRIPTION_URL);
			Description desc = (Description) Factory.getInstance().wrap(SOAUtil.getInstance().getReader(EasyESBFramework.getInstance()).get().readDocument(url, Definitions.class));
			b = desc.getBindings().iterator().next();
		} catch (XmlObjectReadException e) {
			e.printStackTrace();
			throw new RuntimeException();
		} 
	}

	public UserManagementEndpointBehaviourImpl(AdminEndpoint<? extends ProviderEndpointType> ep) {
		super(ep);
		this.setBinding(b);

	}

	public void execute(Exchange exchange) throws TransportException {
		try {
			if(exchange.getMessageIn().getBody().getPayload() == null) {
				throw new TransportException("the message in cannot be null");
			}

			// convert dom to jdom
			DOMBuilder builder = new DOMBuilder();
			org.jdom.Document doc = builder.build(exchange.getMessageIn().getBody().getPayload());

			if(doc.getRootElement() != null &&
					doc.getRootElement().getName().equals("expose")) {
				log.info("EXPOSE ENDPOINT");
				Expose expose = SOAJAXBContext.getInstance().marshallAnyType(exchange.getMessageIn().getBody().getPayload(), Expose.class);
				String res = this.expose(expose.getServiceName(), expose.getEndpointName());

				ExposeResponse exposeResponse = new ExposeResponse();
				exposeResponse.setExternalAddress(res);

				Document docResp = SOAJAXBContext.getInstance().unmarshallAnyElement(exposeResponse);

				MessageUtil.getInstance().createOutMessageStructure(exchange);
				exchange.getMessageOut().getBody().setPayload(docResp);

			} else if(doc.getRootElement() != null &&
					doc.getRootElement().getName().equals("bind")) {
				log.info("BIND ENDPOINT");

				Bind bind = SOAJAXBContext.getInstance().marshallAnyType(exchange.getMessageIn().getBody().getPayload(), Bind.class);

				BindResponse res = this.bind(bind);

				Document docResp = SOAJAXBContext.getInstance().unmarshallAnyElement(res);

				MessageUtil.getInstance().createOutMessageStructure(exchange);
				exchange.getMessageOut().getBody().setPayload(docResp);

			} else if(doc.getRootElement() != null &&
					doc.getRootElement().getName().equals("proxify")) {
				log.info("PROXIFY ENDPOINT");

				Proxify proxify = SOAJAXBContext.getInstance().marshallAnyType(exchange.getMessageIn().getBody().getPayload(), Proxify.class);

				ProxifyResponse response = this.proxify(proxify);

				Document docResp = SOAJAXBContext.getInstance().unmarshallAnyElement(response);

				MessageUtil.getInstance().createOutMessageStructure(exchange);
				exchange.getMessageOut().getBody().setPayload(docResp);

			} else if(doc.getRootElement() != null &&
					doc.getRootElement().getName().equals("deploy")) {
				log.info("DEPLOY");

				EJaxbDeploy deploy = SOAJAXBContext.getInstance().marshallAnyType(exchange.getMessageIn().getBody().getPayload(), EJaxbDeploy.class);
				EJaxbDeployResponse response = this.deploy(deploy);

				Document docResp = SOAJAXBContext.getInstance().unmarshallAnyElement(response);

				MessageUtil.getInstance().createOutMessageStructure(exchange);
				exchange.getMessageOut().getBody().setPayload(docResp);

			}  else if(doc.getRootElement() != null &&
					doc.getRootElement().getName().equals("Subscribe")) {
				log.info("SUBSCRIBE");

				EJaxbSubscribe subs = WSNHelper.marshallSubscribe(exchange.getMessageIn().getBody().getPayload());
				EJaxbSubscribeResponse res = this.subscribe(subs);
				Document docResp = SOAJAXBContext.getInstance().unmarshallAnyElement(res);


				MessageUtil.getInstance().createOutMessageStructure(exchange);
				exchange.getMessageOut().getBody().setPayload(docResp);

			}  else if(doc.getRootElement() != null &&
					doc.getRootElement().getName().equals("Unsubscribe")) {
				log.info("UNSUBSCRIBE");

				EJaxbUnsubscribe unsubscribe = SOAJAXBContext.getInstance().marshallAnyType(exchange.getMessageIn().getBody().getPayload(), EJaxbUnsubscribe.class);
				EJaxbUnsubscribeResponse response = this.unsubscribe(unsubscribe);

				Document docResp = SOAJAXBContext.getInstance().unmarshallAnyElement(response);

				MessageUtil.getInstance().createOutMessageStructure(exchange);
				exchange.getMessageOut().getBody().setPayload(docResp);

			} else if(doc.getRootElement() != null &&
					doc.getRootElement().getName().equals("Notify")) {
				log.info("NOTIFY");

//				if(log.getLevel().equals(Level.FINEST)){
//					log.finest("NOTIFY IN USER MANAGEMENT:" + XMLPrettyPrinter.prettyPrint(exchange.getMessageIn().getBody().getPayload()));
//				}
				EJaxbNotify notify =  WSNHelper.marshallNotify(exchange.getMessageIn().getBody().getPayload());
				this.notify(notify);

			} else if(doc.getRootElement() != null &&
					doc.getRootElement().getName().equals("GetResourceProperty")) {
				log.info("GET_RESOURCE_PROPERTY");

				QName name = SOAJAXBContext.getInstance().marshallAnyType(exchange.getMessageIn().getBody().getPayload(), QName.class);
				EJaxbGetResourcePropertyResponse response = this.getResourceProperty(name);

				Document docResp = SOAJAXBContext.getInstance().unmarshallAnyElement(response);

				MessageUtil.getInstance().createOutMessageStructure(exchange);
				exchange.getMessageOut().getBody().setPayload(docResp);

			} 
		} catch (ManagementException e) {
			try {
				Document docEx = null;
				if(e.getFaultInfo() != null) {
					docEx = SOAJAXBContext.getInstance().unmarshallAnyElement(e.getFaultInfo());
				} else {
					String stack = 
							"<error>\n" +
									"\t<msg><![CDATA[" + e.getMessage() + "]]></msg>\n" +
									"\t<stack>" + ErrorUtil.printStackTrace(e) + "</stack>\n" +
									"</error>";
					docEx = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().parse(new ByteArrayInputStream(stack.getBytes()));
				}
				Document fault = SOAPHandler.createSoapFault(docEx);
				MessageUtil.getInstance().createErrorMessageStructure(exchange);
				exchange.getMessageError().getBody().setPayload(fault);
				log.severe("ERROR EX: " + XMLPrettyPrinter.prettyPrint(exchange.getMessageError().getBody().getPayload()));
			} catch (Exception ex) {
				throw new TransportException(ex);
			}
		} catch (ResourceUnknownFault e) {
			try {
				Document docEx = SOAJAXBContext.getInstance().unmarshallAnyElement(e.getFaultInfo());
				Document fault = SOAPHandler.createSoapFault(docEx);
				MessageUtil.getInstance().createErrorMessageStructure(exchange);
				exchange.getMessageError().getBody().setPayload(fault);
				log.severe("ERROR EX: " + XMLPrettyPrinter.prettyPrint(exchange.getMessageError().getBody().getPayload()));
			} catch (SOAException ex) {
				throw new TransportException(ex);
			} catch (SOAPException ex) {
				throw new TransportException(ex);
			}
		} catch (UnableToDestroySubscriptionFault e) {
			try {
				Document docEx = SOAJAXBContext.getInstance().unmarshallAnyElement(e.getFaultInfo());
				Document fault = SOAPHandler.createSoapFault(docEx);
				MessageUtil.getInstance().createErrorMessageStructure(exchange);
				exchange.getMessageError().getBody().setPayload(fault);
				log.severe("ERROR EX: " + XMLPrettyPrinter.prettyPrint(exchange.getMessageError().getBody().getPayload()));
			} catch (SOAException ex) {
				throw new TransportException(ex);
			} catch (SOAPException ex) {
				throw new TransportException(ex);
			}
		} catch (SOAException e) {
			throw new TransportException(e);
		} catch (TopicNotSupportedFault e) {
			try {
				Document docEx = SOAJAXBContext.getInstance().unmarshallAnyElement(e.getFaultInfo());
				Document fault = SOAPHandler.createSoapFault(docEx);
				MessageUtil.getInstance().createErrorMessageStructure(exchange);
				exchange.getMessageError().getBody().setPayload(fault);
				log.severe("ERROR EX: " + XMLPrettyPrinter.prettyPrint(exchange.getMessageError().getBody().getPayload()));
			} catch (SOAException ex) {
				throw new TransportException(ex);
			} catch (SOAPException ex) {
				throw new TransportException(ex);
			}
		} catch (ResourceUnavailableFault e) {
			try {
				Document docEx = SOAJAXBContext.getInstance().unmarshallAnyElement(e.getFaultInfo());
				Document fault = SOAPHandler.createSoapFault(docEx);
				MessageUtil.getInstance().createErrorMessageStructure(exchange);
				exchange.getMessageError().getBody().setPayload(fault);
				log.severe("ERROR EX: " + XMLPrettyPrinter.prettyPrint(exchange.getMessageError().getBody().getPayload()));
			} catch (SOAException ex) {
				throw new TransportException(ex);
			} catch (SOAPException ex) {
				throw new TransportException(ex);
			}
		} catch (InvalidResourcePropertyQNameFault e) {
			try {
				Document docEx = SOAJAXBContext.getInstance().unmarshallAnyElement(e.getFaultInfo());
				Document fault = SOAPHandler.createSoapFault(docEx);
				MessageUtil.getInstance().createErrorMessageStructure(exchange);
				exchange.getMessageError().getBody().setPayload(fault);
				log.severe("ERROR EX: " + XMLPrettyPrinter.prettyPrint(exchange.getMessageError().getBody().getPayload()));
			} catch (SOAException ex) {
				throw new TransportException(ex);
			} catch (SOAPException ex) {
				throw new TransportException(ex);
			}
		} catch (NotifyMessageNotSupportedFault e) {
			try {
				Document docEx = SOAJAXBContext.getInstance().unmarshallAnyElement(e.getFaultInfo());
				Document fault = SOAPHandler.createSoapFault(docEx);
				MessageUtil.getInstance().createErrorMessageStructure(exchange);
				exchange.getMessageError().getBody().setPayload(fault);
				log.severe("ERROR EX: " + XMLPrettyPrinter.prettyPrint(exchange.getMessageError().getBody().getPayload()));
			} catch (SOAException ex) {
				throw new TransportException(ex);
			} catch (SOAPException ex) {
				throw new TransportException(ex);
			}
		} catch (InvalidFilterFault e) {
			try {
				Document docEx = SOAJAXBContext.getInstance().unmarshallAnyElement(e.getFaultInfo());
				Document fault = SOAPHandler.createSoapFault(docEx);
				MessageUtil.getInstance().createErrorMessageStructure(exchange);
				exchange.getMessageError().getBody().setPayload(fault);
				log.severe("ERROR EX: " + XMLPrettyPrinter.prettyPrint(exchange.getMessageError().getBody().getPayload()));
			} catch (SOAException ex) {
				throw new TransportException(ex);
			} catch (SOAPException ex) {
				throw new TransportException(ex);
			}
		} catch (InvalidTopicExpressionFault e) {
			try {
				Document docEx = SOAJAXBContext.getInstance().unmarshallAnyElement(e.getFaultInfo());
				Document fault = SOAPHandler.createSoapFault(docEx);
				MessageUtil.getInstance().createErrorMessageStructure(exchange);
				exchange.getMessageError().getBody().setPayload(fault);
				log.severe("ERROR EX: " + XMLPrettyPrinter.prettyPrint(exchange.getMessageError().getBody().getPayload()));
			} catch (SOAException ex) {
				throw new TransportException(ex);
			} catch (SOAPException ex) {
				throw new TransportException(ex);
			}
		} catch (TopicExpressionDialectUnknownFault e) {
			try {
				Document docEx = SOAJAXBContext.getInstance().unmarshallAnyElement(e.getFaultInfo());
				Document fault = SOAPHandler.createSoapFault(docEx);
				MessageUtil.getInstance().createErrorMessageStructure(exchange);
				exchange.getMessageError().getBody().setPayload(fault);
				log.severe("ERROR EX: " + XMLPrettyPrinter.prettyPrint(exchange.getMessageError().getBody().getPayload()));
			} catch (SOAException ex) {
				throw new TransportException(ex);
			} catch (SOAPException ex) {
				throw new TransportException(ex);
			}
		} catch (UnsupportedPolicyRequestFault e) {
			try {
				Document docEx = SOAJAXBContext.getInstance().unmarshallAnyElement(e.getFaultInfo());
				Document fault = SOAPHandler.createSoapFault(docEx);
				MessageUtil.getInstance().createErrorMessageStructure(exchange);
				exchange.getMessageError().getBody().setPayload(fault);
				log.severe("ERROR EX: " + XMLPrettyPrinter.prettyPrint(exchange.getMessageError().getBody().getPayload()));
			} catch (SOAException ex) {
				throw new TransportException(ex);
			} catch (SOAPException ex) {
				throw new TransportException(ex);
			}
		} catch (SubscribeCreationFailedFault e) {
			try {
				Document docEx = SOAJAXBContext.getInstance().unmarshallAnyElement(e.getFaultInfo());
				Document fault = SOAPHandler.createSoapFault(docEx);
				MessageUtil.getInstance().createErrorMessageStructure(exchange);
				exchange.getMessageError().getBody().setPayload(fault);
				log.severe("ERROR EX: " + XMLPrettyPrinter.prettyPrint(exchange.getMessageError().getBody().getPayload()));
			} catch (SOAException ex) {
				throw new TransportException(ex);
			} catch (SOAPException ex) {
				throw new TransportException(ex);
			}
		} catch (UnacceptableInitialTerminationTimeFault e) {
			try {
				Document docEx = SOAJAXBContext.getInstance().unmarshallAnyElement(e.getFaultInfo());
				Document fault = SOAPHandler.createSoapFault(docEx);
				MessageUtil.getInstance().createErrorMessageStructure(exchange);
				exchange.getMessageError().getBody().setPayload(fault);
				log.severe("ERROR EX: " + XMLPrettyPrinter.prettyPrint(exchange.getMessageError().getBody().getPayload()));
			} catch (SOAException ex) {
				throw new TransportException(ex);
			} catch (SOAPException ex) {
				throw new TransportException(ex);
			}
		} catch (UnrecognizedPolicyRequestFault e) {
			try {
				Document docEx = SOAJAXBContext.getInstance().unmarshallAnyElement(e.getFaultInfo());
				Document fault = SOAPHandler.createSoapFault(docEx);
				MessageUtil.getInstance().createErrorMessageStructure(exchange);
				exchange.getMessageError().getBody().setPayload(fault);
				log.severe("ERROR EX: " + XMLPrettyPrinter.prettyPrint(exchange.getMessageError().getBody().getPayload()));
			} catch (SOAException ex) {
				throw new TransportException(ex);
			} catch (SOAPException ex) {
				throw new TransportException(ex);
			}
		} catch (InvalidProducerPropertiesExpressionFault e) {
			try {
				Document docEx = SOAJAXBContext.getInstance().unmarshallAnyElement(e.getFaultInfo());
				Document fault = SOAPHandler.createSoapFault(docEx);
				MessageUtil.getInstance().createErrorMessageStructure(exchange);
				exchange.getMessageError().getBody().setPayload(fault);
				log.severe("ERROR EX: " + XMLPrettyPrinter.prettyPrint(exchange.getMessageError().getBody().getPayload()));
			} catch (SOAException ex) {
				throw new TransportException(ex);
			} catch (SOAPException ex) {
				throw new TransportException(ex);
			}
		} catch (InvalidMessageContentExpressionFault e) {
			try {
				Document docEx = SOAJAXBContext.getInstance().unmarshallAnyElement(e.getFaultInfo());
				Document fault = SOAPHandler.createSoapFault(docEx);
				MessageUtil.getInstance().createErrorMessageStructure(exchange);
				exchange.getMessageError().getBody().setPayload(fault);
				log.severe("ERROR EX: " + XMLPrettyPrinter.prettyPrint(exchange.getMessageError().getBody().getPayload()));
			} catch (SOAException ex) {
				throw new TransportException(ex);
			} catch (SOAPException ex) {
				throw new TransportException(ex);
			}
		} catch (WsnbException e) {
			throw new TransportException(e);
		}
	}

	public BaseAdminEndpointBehaviour getAdminEndpointBehaviour() {
		return adminEndpointBehaviour;
	}

	public void setAdminEndpointBehaviour(
			BaseAdminEndpointBehaviour adminEndpointBehaviour) {
		this.adminEndpointBehaviour = adminEndpointBehaviour;
	}




	@Override
	public BindResponse bind(Bind bind) throws ManagementException {
		BindResponse result = new BindResponse();
		String res = this.getAdminEndpointBehaviour().importSoapEndpoint(bind.getExternalAddress(), bind.getWsdl().getUrl().getValue());
		result.setEndpointName(res);
		return result;
	}


	@Override
	public String expose(QName serviceQName, String endpoint)
			throws ManagementException {
		String result = null;
		result = this.getAdminEndpointBehaviour().exposeServiceEndpointInSoap(serviceQName, endpoint);
		return result ;
	}

	@Override
	public ProxifyResponse proxify(Proxify proxify) throws ManagementException {
		ProxifyResponse result = new ProxifyResponse();
		String consumerSoapAddress = this.getAdminEndpointBehaviour().wrapSoapEndpoint(proxify.getExternalAddress(), proxify.getWsdl().getUrl().getValue(), null);
		result.setExternalAddress(consumerSoapAddress);
		return result ;
	}

	@Override
	public EJaxbDeployResponse deploy(EJaxbDeploy deploy) throws ManagementException {
		return this.getAdminEndpointBehaviour().deploy(deploy);
	}

	@Override
	public EJaxbGetResourcePropertyResponse getResourceProperty(QName property)
			throws ResourceUnavailableFault, InvalidResourcePropertyQNameFault,
			ResourceUnknownFault {
		return this.getAdminEndpointBehaviour().getResourceProperty(property);
	}



	@Override
	public EJaxbSubscribeResponse subscribe(EJaxbSubscribe subscribe)
			throws NotifyMessageNotSupportedFault, InvalidFilterFault,
			InvalidTopicExpressionFault, TopicExpressionDialectUnknownFault,
			UnsupportedPolicyRequestFault, SubscribeCreationFailedFault,
			UnacceptableInitialTerminationTimeFault,
			UnrecognizedPolicyRequestFault, TopicNotSupportedFault,
			InvalidProducerPropertiesExpressionFault, ResourceUnknownFault,
			InvalidMessageContentExpressionFault {
		return this.getAdminEndpointBehaviour().subscribe(subscribe);
	}

	@Override
	public EJaxbUnsubscribeResponse unsubscribe(EJaxbUnsubscribe unsubscribe)
			throws UnableToDestroySubscriptionFault, ResourceUnknownFault {
		return this.getAdminEndpointBehaviour().unsubscribe(unsubscribe);
	}

	@Override
	public void notify(EJaxbNotify notify) {
		this.getAdminEndpointBehaviour().notify(notify);
	}

	

	@Override
	public EJaxbUndeployResponse undeploy(EJaxbUndeploy undeploy)
			throws ManagementException {
		return this.getAdminEndpointBehaviour().undeploy(undeploy);
	}


}





