/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easyesb.technical.service.registry;

import com.ebmwebsourcing.easycommons.research.util.SOAException;
import com.ebmwebsourcing.easycommons.research.util.easybox.Framework;
import com.ebmwebsourcing.easycommons.research.util.easybox.SOAUtil;
import com.ebmwebsourcing.easycommons.research.util.jaxb.SOAJAXBContext;
import com.ebmwebsourcing.easyesb.constant.EasyESBFramework;
import com.ebmwebsourcing.easyesb.exchange10.api.ExchangeException;
import com.ebmwebsourcing.easyesb.exchange10.api.element.Exchange;
import com.ebmwebsourcing.easyesb.exchange10.api.type.PatternType;
import com.ebmwebsourcing.easyesb.exchange10.api.type.StatusType;
import com.ebmwebsourcing.easyesb.soa.api.ESBException;
import com.ebmwebsourcing.easyesb.soa.api.config.Configuration;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.ClientEndpoint;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.ProviderEndpoint;
import com.ebmwebsourcing.easyesb.soa.api.node.Node;
import com.ebmwebsourcing.easyesb.soa.api.node.NodeBehaviour;
import com.ebmwebsourcing.easyesb.soa.api.registry.RegistryEndpointBehaviour;
import com.ebmwebsourcing.easyesb.soa.api.service.Service;
import com.ebmwebsourcing.easyesb.soa.api.service.ServiceBehaviour;
import com.ebmwebsourcing.easyesb.soa.api.util.MessageUtil;
import com.ebmwebsourcing.easyesb.soa.impl.config.ConfigurationImpl;
import com.ebmwebsourcing.easyesb.soa.impl.endpoint.ClientProxyEndpointImpl;
import com.ebmwebsourcing.easyesb.soa.impl.endpoint.ProviderEndpointImpl;
import com.ebmwebsourcing.easyesb.soa.impl.endpoint.behaviour.specific.ClientProxyBehaviourImpl;
import com.ebmwebsourcing.easyesb.soa.impl.factory.ESBCoreFactoryImpl;
import com.ebmwebsourcing.easyesb.soa.impl.service.BusinessServiceImpl;
import com.ebmwebsourcing.easyesb.soa10.api.element.EndpointInitialContext;
import com.ebmwebsourcing.easyesb.soa10.api.element.ListenerInitialisation;
import com.ebmwebsourcing.easyesb.soa10.api.element.SenderInitialisation;
import com.ebmwebsourcing.easyesb.soa10.api.type.EndpointType;
import com.ebmwebsourcing.easyesb.soa10.api.type.NodeType;
import com.ebmwebsourcing.easyesb.technical.service.registry.util.EchoBehaviour;
import com.ebmwebsourcing.easyesb.transporter.api.transport.TransportException;
import com.ebmwebsourcing.easyesb.ws.echo.EchoResponse;
import com.ebmwebsourcing.easyesb.ws.echo.Echo_Type;
import com.ebmwebsourcing.easyesb.ws.echo.ObjectFactory;
import easybox.easyesb.petalslink.com.soa.model.datatype._1.EJaxbBasicNodeInformationsType;
import easyesb.ebmwebsourcing.com.soa.model.registry.RegistryFault_Exception;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.LogManager;
import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;
import junit.framework.Assert;
import org.junit.Before;
import org.junit.Test;
import org.w3c.dom.Document;

public class ESBRegistryTest {
    private EndpointInitialContext context = null;

    @Before
    public void setup() throws Exception {
        this.context = (EndpointInitialContext)SOAUtil.getInstance().getXmlContext((Framework)EasyESBFramework.getInstance()).getXmlObjectFactory().create(EndpointInitialContext.class);
        this.context.setNumberOfThreads(5);
    }

    private Node createNode(QName name, String host, int port) throws ESBException {
        ESBCoreFactoryImpl factory = new ESBCoreFactoryImpl(new String[0]);
        ConfigurationImpl conf = new ConfigurationImpl(host, port);
        Node node = factory.createNode(name, (Configuration)conf);
        return node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPoint2PointConnexion() throws ESBException, ExchangeException, ParserConfigurationException, TransportException, InterruptedException, RegistryFault_Exception, SOAException {
        boolean explorer = false;
        Node node1 = this.createNode(new QName("http://com.ebmwebsourcing.easyesb/node1", "node1"), "localhost", 9001);
        Node node2 = this.createNode(new QName("http://com.ebmwebsourcing.easyesb/node2", "node2"), "localhost", 9002);
        try {
            RegistryEndpointBehaviour registryBehaviour = (RegistryEndpointBehaviour)node1.getRegistryEndpoint().findBehaviour(RegistryEndpointBehaviour.class);
            registryBehaviour.addNeighBourNode((EJaxbBasicNodeInformationsType)((NodeType)node2.getModel()).getBasicNodeInformations().getModelObject());
            Service service = ((NodeBehaviour)node2.findBehaviour(NodeBehaviour.class)).createService(new QName("http://com.ebmwebsourcing.easyesb/echo", "echo"), BusinessServiceImpl.class);
            ProviderEndpoint providerEndpoint = ((ServiceBehaviour)service.findBehaviour(ServiceBehaviour.class)).createProviderEndpoint("myEchoEndpoint", ProviderEndpointImpl.class, EchoBehaviour.class, this.context, new SenderInitialisation[0]);
            EndpointType endpoint = ((RegistryEndpointBehaviour)node1.getRegistryEndpoint().findBehaviour(RegistryEndpointBehaviour.class)).getEndpoint(providerEndpoint.getReference());
            Assert.assertNotNull((Object)endpoint);
            ClientEndpoint clientEndpoint = ((NodeBehaviour)node1.findBehaviour(NodeBehaviour.class)).createClientEndpoint(new QName("http://com.ebmwebsourcing.easyesb/echo", "myClientEchoEndpoint"), ClientProxyEndpointImpl.class, ClientProxyBehaviourImpl.class, this.context, new ListenerInitialisation[0]);
            Exchange exchange = clientEndpoint.createExchange();
            exchange.setDestinationReference(providerEndpoint.getReference());
            exchange.setPattern(PatternType.IN_OUT);
            exchange.setStatus(StatusType.ACTIVE);
            exchange.setOperation(new QName("http://com.ebmwebsourcing.easyesb/echo", "echo").toString());
            Echo_Type echo = new Echo_Type();
            echo.setIn("Hello world!!!");
            SOAJAXBContext.getInstance().addOtherObjectFactory(new Class[]{ObjectFactory.class});
            Document payload = SOAJAXBContext.getInstance().unmarshallAnyElement((Object)echo);
            MessageUtil.getInstance().createInMessageStructure(exchange);
            exchange.getMessageIn().getBody().setPayload(payload);
            Exchange response = clientEndpoint.sendSync(exchange, 0L);
            System.out.println("response = " + response.getMessageOut().getBody().getPayload().getDocumentElement().getNodeValue());
            EchoResponse businessReponse = (EchoResponse)SOAJAXBContext.getInstance().marshallAnyType(response.getMessageOut().getBody().getPayload(), EchoResponse.class);
            Assert.assertEquals((String)"Hello world!!!", (String)businessReponse.getOut());
        }
        finally {
            node1.stop();
            node2.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testChainTopology() throws ESBException, ExchangeException, ParserConfigurationException, TransportException, RegistryFault_Exception, SOAException {
        Node node1 = this.createNode(new QName("http://com.ebmwebsourcing.easyesb/node1", "node1"), "localhost", 9001);
        Node node2 = this.createNode(new QName("http://com.ebmwebsourcing.easyesb/node2", "node2"), "localhost", 9002);
        Node node3 = this.createNode(new QName("http://com.ebmwebsourcing.easyesb/node3", "node3"), "localhost", 9003);
        Node node4 = this.createNode(new QName("http://com.ebmwebsourcing.easyesb/node4", "node4"), "localhost", 9004);
        Node node5 = this.createNode(new QName("http://com.ebmwebsourcing.easyesb/node5", "node5"), "localhost", 9005);
        try {
            ((RegistryEndpointBehaviour)node1.getRegistryEndpoint().findBehaviour(RegistryEndpointBehaviour.class)).addNeighBourNode((EJaxbBasicNodeInformationsType)((NodeType)node2.getModel()).getBasicNodeInformations().getModelObject());
            ((RegistryEndpointBehaviour)node2.getRegistryEndpoint().findBehaviour(RegistryEndpointBehaviour.class)).addNeighBourNode((EJaxbBasicNodeInformationsType)((NodeType)node3.getModel()).getBasicNodeInformations().getModelObject());
            ((RegistryEndpointBehaviour)node3.getRegistryEndpoint().findBehaviour(RegistryEndpointBehaviour.class)).addNeighBourNode((EJaxbBasicNodeInformationsType)((NodeType)node4.getModel()).getBasicNodeInformations().getModelObject());
            ((RegistryEndpointBehaviour)node4.getRegistryEndpoint().findBehaviour(RegistryEndpointBehaviour.class)).addNeighBourNode((EJaxbBasicNodeInformationsType)((NodeType)node5.getModel()).getBasicNodeInformations().getModelObject());
            Service service = ((NodeBehaviour)node5.findBehaviour(NodeBehaviour.class)).createService(new QName("http://com.ebmwebsourcing.easyesb/echo", "echo"), BusinessServiceImpl.class);
            ProviderEndpoint providerEndpoint = ((ServiceBehaviour)service.findBehaviour(ServiceBehaviour.class)).createProviderEndpoint("myEchoEndpoint", ProviderEndpointImpl.class, EchoBehaviour.class, this.context, new SenderInitialisation[0]);
            providerEndpoint.addBehaviourClass(EchoBehaviour.class);
            ClientEndpoint clientEndpoint = ((NodeBehaviour)node1.findBehaviour(NodeBehaviour.class)).createClientEndpoint(new QName("http://com.ebmwebsourcing.easyesb/echo", "myClientEchoEndpoint"), ClientProxyEndpointImpl.class, ClientProxyBehaviourImpl.class, this.context, new ListenerInitialisation[0]);
            Exchange exchange = clientEndpoint.createExchange();
            exchange.setDestinationReference(providerEndpoint.getReference());
            exchange.setPattern(PatternType.IN_OUT);
            exchange.setStatus(StatusType.ACTIVE);
            exchange.setOperation(new QName("http://com.ebmwebsourcing.easyesb/echo", "echo").toString());
            Echo_Type echo = new Echo_Type();
            echo.setIn("Hello world!!!");
            SOAJAXBContext.getInstance().addOtherObjectFactory(new Class[]{ObjectFactory.class});
            Document payload = SOAJAXBContext.getInstance().unmarshallAnyElement((Object)echo);
            MessageUtil.getInstance().createInMessageStructure(exchange);
            exchange.getMessageIn().getBody().setPayload(payload);
            Exchange response = clientEndpoint.sendSync(exchange, 0L);
            System.out.println("response = " + response.getMessageOut().getBody().getPayload().getDocumentElement().getNodeValue());
            SOAJAXBContext.getInstance().addOtherObjectFactory(new Class[]{ObjectFactory.class});
            EchoResponse businessReponse = (EchoResponse)SOAJAXBContext.getInstance().marshallAnyType(response.getMessageOut().getBody().getPayload(), EchoResponse.class);
            Assert.assertEquals((String)"Hello world!!!", (String)businessReponse.getOut());
        }
        finally {
            node1.stop();
            node2.stop();
            node3.stop();
            node4.stop();
            node5.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testStarTopology() throws ESBException, ExchangeException, ParserConfigurationException, TransportException, InterruptedException, RegistryFault_Exception, SOAException {
        Node nodeN = this.createNode(new QName("http://com.ebmwebsourcing.easyesb/nodeN", "nodeN"), "localhost", 9001);
        Node nodeNE = this.createNode(new QName("http://com.ebmwebsourcing.easyesb/nodeNE", "nodeNE"), "localhost", 9002);
        Node nodeE = this.createNode(new QName("http://com.ebmwebsourcing.easyesb/nodeE", "nodeE"), "localhost", 9003);
        Node nodeSE = this.createNode(new QName("http://com.ebmwebsourcing.easyesb/nodeSE", "nodeSE"), "localhost", 9004);
        Node nodeS = this.createNode(new QName("http://com.ebmwebsourcing.easyesb/nodeS", "nodeS"), "localhost", 9005);
        Node nodeSO = this.createNode(new QName("http://com.ebmwebsourcing.easyesb/nodeSO", "nodeSO"), "localhost", 9006);
        Node nodeO = this.createNode(new QName("http://com.ebmwebsourcing.easyesb/nodeO", "nodeO"), "localhost", 9007);
        Node nodeNO = this.createNode(new QName("http://com.ebmwebsourcing.easyesb/nodeNO", "nodeNO"), "localhost", 9008);
        Node nodeC = this.createNode(new QName("http://com.ebmwebsourcing.easyesb/nodeC", "nodeC"), "localhost", 9009);
        Thread.sleep(10000L);
        try {
            ((RegistryEndpointBehaviour)nodeN.getRegistryEndpoint().findBehaviour(RegistryEndpointBehaviour.class)).addNeighBourNode((EJaxbBasicNodeInformationsType)((NodeType)nodeC.getModel()).getBasicNodeInformations().getModelObject());
            ((RegistryEndpointBehaviour)nodeNE.getRegistryEndpoint().findBehaviour(RegistryEndpointBehaviour.class)).addNeighBourNode((EJaxbBasicNodeInformationsType)((NodeType)nodeC.getModel()).getBasicNodeInformations().getModelObject());
            ((RegistryEndpointBehaviour)nodeE.getRegistryEndpoint().findBehaviour(RegistryEndpointBehaviour.class)).addNeighBourNode((EJaxbBasicNodeInformationsType)((NodeType)nodeC.getModel()).getBasicNodeInformations().getModelObject());
            ((RegistryEndpointBehaviour)nodeSE.getRegistryEndpoint().findBehaviour(RegistryEndpointBehaviour.class)).addNeighBourNode((EJaxbBasicNodeInformationsType)((NodeType)nodeC.getModel()).getBasicNodeInformations().getModelObject());
            ((RegistryEndpointBehaviour)nodeS.getRegistryEndpoint().findBehaviour(RegistryEndpointBehaviour.class)).addNeighBourNode((EJaxbBasicNodeInformationsType)((NodeType)nodeC.getModel()).getBasicNodeInformations().getModelObject());
            ((RegistryEndpointBehaviour)nodeSO.getRegistryEndpoint().findBehaviour(RegistryEndpointBehaviour.class)).addNeighBourNode((EJaxbBasicNodeInformationsType)((NodeType)nodeC.getModel()).getBasicNodeInformations().getModelObject());
            ((RegistryEndpointBehaviour)nodeO.getRegistryEndpoint().findBehaviour(RegistryEndpointBehaviour.class)).addNeighBourNode((EJaxbBasicNodeInformationsType)((NodeType)nodeC.getModel()).getBasicNodeInformations().getModelObject());
            ((RegistryEndpointBehaviour)nodeNO.getRegistryEndpoint().findBehaviour(RegistryEndpointBehaviour.class)).addNeighBourNode((EJaxbBasicNodeInformationsType)((NodeType)nodeC.getModel()).getBasicNodeInformations().getModelObject());
            ((RegistryEndpointBehaviour)nodeC.getRegistryEndpoint().findBehaviour(RegistryEndpointBehaviour.class)).addNeighBourNode((EJaxbBasicNodeInformationsType)((NodeType)nodeN.getModel()).getBasicNodeInformations().getModelObject());
            ((RegistryEndpointBehaviour)nodeC.getRegistryEndpoint().findBehaviour(RegistryEndpointBehaviour.class)).addNeighBourNode((EJaxbBasicNodeInformationsType)((NodeType)nodeNE.getModel()).getBasicNodeInformations().getModelObject());
            ((RegistryEndpointBehaviour)nodeC.getRegistryEndpoint().findBehaviour(RegistryEndpointBehaviour.class)).addNeighBourNode((EJaxbBasicNodeInformationsType)((NodeType)nodeE.getModel()).getBasicNodeInformations().getModelObject());
            ((RegistryEndpointBehaviour)nodeC.getRegistryEndpoint().findBehaviour(RegistryEndpointBehaviour.class)).addNeighBourNode((EJaxbBasicNodeInformationsType)((NodeType)nodeSE.getModel()).getBasicNodeInformations().getModelObject());
            ((RegistryEndpointBehaviour)nodeC.getRegistryEndpoint().findBehaviour(RegistryEndpointBehaviour.class)).addNeighBourNode((EJaxbBasicNodeInformationsType)((NodeType)nodeS.getModel()).getBasicNodeInformations().getModelObject());
            ((RegistryEndpointBehaviour)nodeC.getRegistryEndpoint().findBehaviour(RegistryEndpointBehaviour.class)).addNeighBourNode((EJaxbBasicNodeInformationsType)((NodeType)nodeSO.getModel()).getBasicNodeInformations().getModelObject());
            ((RegistryEndpointBehaviour)nodeC.getRegistryEndpoint().findBehaviour(RegistryEndpointBehaviour.class)).addNeighBourNode((EJaxbBasicNodeInformationsType)((NodeType)nodeO.getModel()).getBasicNodeInformations().getModelObject());
            ((RegistryEndpointBehaviour)nodeC.getRegistryEndpoint().findBehaviour(RegistryEndpointBehaviour.class)).addNeighBourNode((EJaxbBasicNodeInformationsType)((NodeType)nodeNO.getModel()).getBasicNodeInformations().getModelObject());
            Service service = ((NodeBehaviour)nodeSO.findBehaviour(NodeBehaviour.class)).createService(new QName("http://com.ebmwebsourcing.easyesb/echo", "echo"), BusinessServiceImpl.class);
            ProviderEndpoint providerEndpoint = ((ServiceBehaviour)service.findBehaviour(ServiceBehaviour.class)).createProviderEndpoint("myEchoEndpoint", ProviderEndpointImpl.class, EchoBehaviour.class, this.context, new SenderInitialisation[0]);
            providerEndpoint.addBehaviourClass(EchoBehaviour.class);
            ClientEndpoint clientEndpoint = ((NodeBehaviour)nodeN.findBehaviour(NodeBehaviour.class)).createClientEndpoint(new QName("http://com.ebmwebsourcing.easyesb/echo", "myClientEchoEndpoint"), ClientProxyEndpointImpl.class, ClientProxyBehaviourImpl.class, this.context, new ListenerInitialisation[0]);
            Exchange exchange = clientEndpoint.createExchange();
            exchange.setDestinationReference(providerEndpoint.getReference());
            exchange.setPattern(PatternType.IN_OUT);
            exchange.setStatus(StatusType.ACTIVE);
            exchange.setOperation(new QName("http://com.ebmwebsourcing.easyesb/echo", "echo").toString());
            Echo_Type echo = new Echo_Type();
            echo.setIn("Hello world!!!");
            Document payload = SOAJAXBContext.getInstance().unmarshallAnyElement((Object)echo);
            MessageUtil.getInstance().createInMessageStructure(exchange);
            exchange.getMessageIn().getBody().setPayload(payload);
            Exchange response = clientEndpoint.sendSync(exchange, 0L);
            System.out.println("response = " + response.getMessageOut().getBody().getPayload().getDocumentElement().getNodeValue());
            EchoResponse businessReponse = (EchoResponse)SOAJAXBContext.getInstance().marshallAnyType(response.getMessageOut().getBody().getPayload(), EchoResponse.class);
            Assert.assertEquals((String)"Hello world!!!", (String)businessReponse.getOut());
        }
        finally {
            nodeN.stop();
            nodeNE.stop();
            nodeE.stop();
            nodeSE.stop();
            nodeS.stop();
            nodeSO.stop();
            nodeO.stop();
            nodeNO.stop();
        }
    }

    static {
        try {
            InputStream configFile = Thread.currentThread().getContextClassLoader().getResourceAsStream("easycommons-logging.properties");
            LogManager.getLogManager().readConfiguration(configFile);
        }
        catch (IOException ex) {
            System.err.println("WARNING: Could not open configuration file");
            System.err.println("WARNING: Logging not configured (console output only)");
        }
    }
}

