/*******************************************************************************
 * Copyright (c) 2011 EBM Websourcing.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v2.1
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * 
 * Contributors:
 *     EBM Websourcing - initial API and implementation
 ******************************************************************************/
package com.ebmwebsourcing.easyesb.technical.service.registry;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;

import javax.xml.namespace.QName;

import org.objectweb.fractal.api.NoSuchInterfaceException;

import com.ebmwebsourcing.easycommons.research.util.easybox.SOAUtil;
import com.ebmwebsourcing.easycommons.sca.helper.api.SCAException;
import com.ebmwebsourcing.easycommons.sca.helper.impl.SCAHelper;
import com.ebmwebsourcing.easyesb.constant.EasyESBFramework;
import com.ebmwebsourcing.easyesb.exchange10.api.element.Exchange;
import com.ebmwebsourcing.easyesb.soa.api.ESBException;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.Endpoint;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.ProviderEndpoint;
import com.ebmwebsourcing.easyesb.soa.api.registry.RegistryEndpoint;
import com.ebmwebsourcing.easyesb.soa.api.registry.RegistryService;
import com.ebmwebsourcing.easyesb.soa.api.registry.RegistryServiceBehaviour;
import com.ebmwebsourcing.easyesb.soa.api.service.Service;
import com.ebmwebsourcing.easyesb.soa.impl.service.ServiceBehaviourImpl;
import com.ebmwebsourcing.easyesb.soa.impl.transport.listener.ListenersManagerImpl;
import com.ebmwebsourcing.easyesb.soa10.api.element.BehavioursList;
import com.ebmwebsourcing.easyesb.soa10.api.element.EndpointInitialContext;
import com.ebmwebsourcing.easyesb.soa10.api.element.LocalEndpointsGroupList;
import com.ebmwebsourcing.easyesb.soa10.api.element.Registry;
import com.ebmwebsourcing.easyesb.soa10.api.element.RemoteEndpointsGroupList;
import com.ebmwebsourcing.easyesb.soa10.api.type.EndpointType;
import com.ebmwebsourcing.easyesb.soa10.api.type.RegistryEndpointType;
import com.ebmwebsourcing.easyesb.soa10.api.type.RegistryServiceType;
import com.ebmwebsourcing.easyesb.transporter.api.transport.TransportException;

public class RegistryServiceBehaviourImpl extends ServiceBehaviourImpl implements RegistryServiceBehaviour {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	private static Logger log = Logger.getLogger(RegistryServiceBehaviourImpl.class.getName());
	

	private RegistryEndpoint<? extends RegistryEndpointType> registryEndpoint = null;
	
	
	public RegistryServiceBehaviourImpl(RegistryService<? extends RegistryServiceType> ep) {
		super(ep);
	}
	
	public void execute(Exchange exchange) throws TransportException {
		super.execute(exchange);
		
	}

	@SuppressWarnings("unchecked")
	public RegistryEndpoint<? extends RegistryEndpointType> createRegistryEndpoint(
			String name, EndpointInitialContext initialEndpointContext) throws ESBException {
		if(this.registryEndpoint == null) {
			try {
				Registry model = SOAUtil.getInstance().getXmlContext(EasyESBFramework.getInstance()).getXmlObjectFactory().create(Registry.class);
				model.setName(new QName(this.getEndpoint().getQName().getNamespaceURI(),name));
				model.setBehavioursList(SOAUtil.getInstance().getXmlContext(EasyESBFramework.getInstance()).getXmlObjectFactory().create(BehavioursList.class));
				model.getBehavioursList().addBehaviour(RegistryEndpointBehaviourImpl.class.getName());
				
				Map<String, Object> context = new HashMap<String, Object>();
				context.put("model", model);
				context.put("parent", this.getEndpoint());
				
				org.objectweb.fractal.api.Component providerComponent = SCAHelper.getSCAHelper().createNewComponent(RegistryEndpointImpl.class.getName(), context);
				SCAHelper.getSCAHelper().startComponent(providerComponent);
				if(name != null) {
					SCAHelper.getSCAHelper().changeName(providerComponent, name.toString());
				}
				this.registryEndpoint = (RegistryEndpoint) providerComponent.getFcInterface("service");
				((ProviderEndpoint)this.registryEndpoint).setServiceProvider((Service) this.endpoint);
				
				
				// init
			//	this.registryEndpoint.initFractalComponent(providerComponent);
				this.registryEndpoint.init();
//				this.registryEndpoint.setQName(new QName(this.getEndpoint().getQName().getNamespaceURI(),name));
//				this.registryEndpoint.setBehaviourClass(RegistryEndpointBehaviourImpl.class);

				this.registryEndpoint.setNode(this.getEndpoint().getNode());
				this.registryEndpoint.getModel().setService(this.getEndpoint().getQName());
				this.registryEndpoint.getModel().setEndpointInitialContext(initialEndpointContext);
				this.registryEndpoint.getModel().setLocalEndpointsList(SOAUtil.getInstance().getXmlContext(EasyESBFramework.getInstance()).getXmlObjectFactory().create(LocalEndpointsGroupList.class));
				this.registryEndpoint.getModel().setRemoteEndpointsList(SOAUtil.getInstance().getXmlContext(EasyESBFramework.getInstance()).getXmlObjectFactory().create(RemoteEndpointsGroupList.class));
				
				// add service in registry
//				if((this.getEndpoint().getNode() != null)&&(((NodeBehaviour)this.getEndpoint().getNode().getBehaviour()).getRegistryService() != null)) {
//					((RegistryEndpointBehaviour) ((RegistryServiceBehaviour)((NodeBehaviour)this.getEndpoint().getNode().getBehaviour()).getRegistryService().getBehaviour()).getRegistryEndpoint().getBehaviour()).addEndpoint(this.registryEndpoint);
//				} else {
//					throw new ESBException("Registry cannot be null"); 
//				}
				
				// add component in list
				if(this.getEndpoint().getComponent() != null) {
					SCAHelper.getSCAHelper().addComponent(providerComponent, this.getEndpoint().getComponent(), null);
				}
				
				// create listener or add endpoint in listener node
				if((this.registryEndpoint.getModel().getEndpointInitialContext() != null)&&(this.registryEndpoint.getModel().getEndpointInitialContext().getNumberOfThreads() > 0)) {
					Map<QName, Endpoint<? extends EndpointType>> endpoints = Collections.synchronizedMap(new HashMap<QName, Endpoint<? extends EndpointType>>());
					endpoints.put(this.registryEndpoint.getQName(), this.registryEndpoint);
					this.registryEndpoint.setListenersManager(new ListenersManagerImpl(this.registryEndpoint.getModel().getEndpointInitialContext().getNumberOfThreads(), endpoints));
				} else {
					this.getEndpoint().getNode().getListenedEndpoints().put(this.registryEndpoint.getQName(), this.registryEndpoint);
				}
			} catch (NoSuchInterfaceException e) {
				throw new ESBException(e);
			} catch (SCAException  e) {
				throw new ESBException(e);
			}
			log.fine("registryEndpoint " + name + " created and started");
		}
		return this.registryEndpoint;
	}

	public RegistryEndpoint<? extends RegistryEndpointType> getRegistryEndpoint() {
		return this.registryEndpoint;
	}


}
