/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easyesb.technical.service.registry;

import com.ebmwebsourcing.easycommons.research.util.easybox.Framework;
import com.ebmwebsourcing.easycommons.research.util.easybox.SOAUtil;
import com.ebmwebsourcing.easycommons.sca.helper.api.SCAException;
import com.ebmwebsourcing.easycommons.sca.helper.impl.SCAHelper;
import com.ebmwebsourcing.easyesb.constant.EasyESBFramework;
import com.ebmwebsourcing.easyesb.exchange10.api.element.Exchange;
import com.ebmwebsourcing.easyesb.soa.api.ESBException;
import com.ebmwebsourcing.easyesb.soa.api.registry.RegistryEndpoint;
import com.ebmwebsourcing.easyesb.soa.api.registry.RegistryService;
import com.ebmwebsourcing.easyesb.soa.api.registry.RegistryServiceBehaviour;
import com.ebmwebsourcing.easyesb.soa.api.service.Service;
import com.ebmwebsourcing.easyesb.soa.api.transport.listener.ListenersManager;
import com.ebmwebsourcing.easyesb.soa.impl.service.ServiceBehaviourImpl;
import com.ebmwebsourcing.easyesb.soa.impl.transport.listener.ListenersManagerImpl;
import com.ebmwebsourcing.easyesb.soa10.api.element.BehavioursList;
import com.ebmwebsourcing.easyesb.soa10.api.element.EndpointInitialContext;
import com.ebmwebsourcing.easyesb.soa10.api.element.LocalEndpointsGroupList;
import com.ebmwebsourcing.easyesb.soa10.api.element.Registry;
import com.ebmwebsourcing.easyesb.soa10.api.element.RemoteEndpointsGroupList;
import com.ebmwebsourcing.easyesb.soa10.api.type.RegistryEndpointType;
import com.ebmwebsourcing.easyesb.soa10.api.type.RegistryServiceType;
import com.ebmwebsourcing.easyesb.technical.service.registry.RegistryEndpointBehaviourImpl;
import com.ebmwebsourcing.easyesb.technical.service.registry.RegistryEndpointImpl;
import com.ebmwebsourcing.easyesb.transporter.api.transport.TransportException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.api.NoSuchInterfaceException;

public class RegistryServiceBehaviourImpl
extends ServiceBehaviourImpl
implements RegistryServiceBehaviour {
    private static final long serialVersionUID = 1L;
    private static Logger log = Logger.getLogger(RegistryServiceBehaviourImpl.class.getName());
    private RegistryEndpoint<? extends RegistryEndpointType> registryEndpoint = null;

    public RegistryServiceBehaviourImpl(RegistryService<? extends RegistryServiceType> ep) {
        super(ep);
    }

    public void execute(Exchange exchange) throws TransportException {
        super.execute(exchange);
    }

    public RegistryEndpoint<? extends RegistryEndpointType> createRegistryEndpoint(String name, EndpointInitialContext initialEndpointContext) throws ESBException {
        if (this.registryEndpoint == null) {
            try {
                Registry model = (Registry)SOAUtil.getInstance().getXmlContext((Framework)EasyESBFramework.getInstance()).getXmlObjectFactory().create(Registry.class);
                model.setName(new QName(this.getEndpoint().getQName().getNamespaceURI(), name));
                model.setBehavioursList((BehavioursList)SOAUtil.getInstance().getXmlContext((Framework)EasyESBFramework.getInstance()).getXmlObjectFactory().create(BehavioursList.class));
                model.getBehavioursList().addBehaviour(RegistryEndpointBehaviourImpl.class.getName());
                HashMap<String, Object> context = new HashMap<String, Object>();
                context.put("model", model);
                context.put("parent", this.getEndpoint());
                Component providerComponent = SCAHelper.getSCAHelper().createNewComponent(RegistryEndpointImpl.class.getName(), context);
                SCAHelper.getSCAHelper().startComponent(providerComponent);
                if (name != null) {
                    SCAHelper.getSCAHelper().changeName(providerComponent, name.toString());
                }
                this.registryEndpoint = (RegistryEndpoint)providerComponent.getFcInterface("service");
                this.registryEndpoint.setServiceProvider((Service)this.endpoint);
                this.registryEndpoint.init();
                this.registryEndpoint.setNode(this.getEndpoint().getNode());
                ((RegistryEndpointType)this.registryEndpoint.getModel()).setService(this.getEndpoint().getQName());
                ((RegistryEndpointType)this.registryEndpoint.getModel()).setEndpointInitialContext(initialEndpointContext);
                ((RegistryEndpointType)this.registryEndpoint.getModel()).setLocalEndpointsList((LocalEndpointsGroupList)SOAUtil.getInstance().getXmlContext((Framework)EasyESBFramework.getInstance()).getXmlObjectFactory().create(LocalEndpointsGroupList.class));
                ((RegistryEndpointType)this.registryEndpoint.getModel()).setRemoteEndpointsList((RemoteEndpointsGroupList)SOAUtil.getInstance().getXmlContext((Framework)EasyESBFramework.getInstance()).getXmlObjectFactory().create(RemoteEndpointsGroupList.class));
                if (this.getEndpoint().getComponent() != null) {
                    SCAHelper.getSCAHelper().addComponent(providerComponent, this.getEndpoint().getComponent(), null);
                }
                if (((RegistryEndpointType)this.registryEndpoint.getModel()).getEndpointInitialContext() != null && ((RegistryEndpointType)this.registryEndpoint.getModel()).getEndpointInitialContext().getNumberOfThreads() > 0) {
                    Map<QName, RegistryEndpoint<? extends RegistryEndpointType>> endpoints = Collections.synchronizedMap(new HashMap());
                    endpoints.put(this.registryEndpoint.getQName(), this.registryEndpoint);
                    this.registryEndpoint.setListenersManager((ListenersManager)new ListenersManagerImpl(((RegistryEndpointType)this.registryEndpoint.getModel()).getEndpointInitialContext().getNumberOfThreads(), endpoints));
                } else {
                    this.getEndpoint().getNode().getListenedEndpoints().put(this.registryEndpoint.getQName(), this.registryEndpoint);
                }
            }
            catch (NoSuchInterfaceException e) {
                throw new ESBException((Throwable)e);
            }
            catch (SCAException e) {
                throw new ESBException((Throwable)e);
            }
            log.fine("registryEndpoint " + name + " created and started");
        }
        return this.registryEndpoint;
    }

    public RegistryEndpoint<? extends RegistryEndpointType> getRegistryEndpoint() {
        return this.registryEndpoint;
    }
}

