/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easyesb.cli.impl;

import com.ebmwebsourcing.easycommons.research.util.SOAException;
import com.ebmwebsourcing.easycommons.research.util.jaxb.SOAJAXBContext;
import com.ebmwebsourcing.easyesb.cli.api.Command;
import com.ebmwebsourcing.easyesb.soa.api.ESBException;
import esstar.petalslink.com.data.management.user._1.ObjectFactory;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.SortedMap;
import java.util.StringTokenizer;
import java.util.TreeMap;

public abstract class AbstractCommandManager {
    protected File currentPath;
    protected SortedMap<String, Command> map = new TreeMap<String, Command>();
    protected String connectionAddress;
    private List<String> history = new ArrayList<String>();

    public AbstractCommandManager() throws ESBException {
        this.init(null);
    }

    protected void addCommand(Command command) {
        this.map.put(command.getShortcut(), command);
    }

    public Command findCommand(String shortcut) {
        return (Command)this.map.get(shortcut);
    }

    public void read() {
        BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
        int code = 1;
        while (code > 0) {
            try {
                System.out.println();
                System.out.print("cli:/> ");
                code = this.processCommandLine(br.readLine());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    protected int processCommandLine(String command) {
        int result = 1;
        if (command != null && command.length() > 0) {
            StringTokenizer tokenizer = new StringTokenizer(command, " ");
            ArrayList<String> args = new ArrayList<String>();
            while (tokenizer.hasMoreTokens()) {
                args.add(tokenizer.nextToken());
            }
            String key = (String)args.get(0);
            Command task = this.getTask(key);
            if (task == null) {
                System.out.println("Unrecognized command : " + command + " (tape '-h' for help)");
            } else {
                List arguments = null;
                arguments = args.size() > 1 ? args.subList(1, args.size()) : new ArrayList(0);
                result = task.process(arguments);
                if (result == -2) {
                    System.out.println("Bad arguments : " + arguments + " (tape '-h' for help)");
                } else if (result == -3) {
                    System.out.println("No connection ... Connect first to a esb node with Connect (-c) command.");
                } else if (result == -1) {
                    System.out.println("Error while executing command " + command);
                } else {
                    this.getHistory().add(command);
                }
                result = 1;
            }
        }
        return result;
    }

    public List<String> getHistory() {
        return this.history;
    }

    public void resetHistory() {
        this.history.clear();
    }

    public void printUsage() {
        Iterator<String> iter = this.map.keySet().iterator();
        while (iter.hasNext()) {
            Command command = (Command)this.map.get(iter.next());
            System.out.println(" -" + command.toString());
        }
    }

    private Command getTask(String command) {
        String shortcut;
        Command task = (Command)this.map.get(command);
        if (task == null && (shortcut = this.getShortcutFromCommand(command)) != null) {
            task = (Command)this.map.get(shortcut);
        }
        return task;
    }

    private String getShortcutFromCommand(String command) {
        String result = null;
        boolean found = false;
        Iterator<String> iter = this.map.keySet().iterator();
        while (iter.hasNext() && !found) {
            Command task = (Command)this.map.get(iter.next());
            if (!command.equals(task.getName())) continue;
            result = task.getShortcut();
            found = true;
        }
        return result;
    }

    public String getConnectionAddress() {
        return this.connectionAddress;
    }

    public abstract void init(String var1) throws ESBException;

    public List<String> detectCommand(List<String> command) {
        ArrayList<String> res = new ArrayList<String>();
        String buff = "";
        for (String c : command) {
            if (c == null) continue;
            buff = buff + " " + c;
        }
        List<String> tp = Arrays.asList(buff.split(" -"));
        for (String c : tp) {
            if (c == null || c.trim().length() <= 0) continue;
            res.add(c);
        }
        System.out.println("commands : " + res);
        return res;
    }

    static {
        try {
            SOAJAXBContext.getInstance().addOtherObjectFactory(new Class[]{ObjectFactory.class});
        }
        catch (SOAException e) {
            e.printStackTrace();
        }
    }
}

