/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easyesb.cli.impl.command;

import com.ebmwebsourcing.easyesb.admin.client.api.AdminClient;
import com.ebmwebsourcing.easyesb.admin.client.impl.AdminClientImpl;
import com.ebmwebsourcing.easyesb.cli.impl.AbstractCommand;
import com.ebmwebsourcing.easyesb.soa.api.ESBException;
import easybox.easyesb.petalslink.com.soa.model.datatype._1.EJaxbBasicNodeInformationsType;
import easyesb.petalslink.com.data.admin._1.AddNeighBourNode;
import easyesb.petalslink.com.data.admin._1.GetNodeInformations;
import easyesb.petalslink.com.data.admin._1.GetNodeInformationsResponse;
import java.util.List;

public class AddNeighbourNodeCommand
extends AbstractCommand<AdminClient> {
    public AddNeighbourNodeCommand(AdminClient client) throws ESBException {
        super(client);
        this.setName("AddNeighbourNode");
        this.setShortcut("a");
        this.setDescription("Add a node in the neighbour list of the current node.");
    }

    @Override
    public void execute() {
    }

    @Override
    protected int doProcess(List<String> args) {
        int res = 1;
        try {
            AdminClientImpl clientAdmin2 = new AdminClientImpl(args.get(0));
            GetNodeInformations nodein = new GetNodeInformations();
            GetNodeInformationsResponse nodeout = clientAdmin2.getNodeInformations(nodein);
            EJaxbBasicNodeInformationsType nodeinfo = nodeout.getNode().getBasicNodeInformations();
            AddNeighBourNode parameters = new AddNeighBourNode();
            EJaxbBasicNodeInformationsType value = nodeinfo;
            parameters.setNeighbourNode(value);
            ((AdminClient)this.getClient()).addNeighBourNode(parameters);
            this.setResult("New neighbours (1)" + ((AdminClient)this.getClient()).getAddress() + " and (2)" + args.get(0));
            this.resultCode = res;
        }
        catch (Throwable e) {
            e.printStackTrace();
            this.resultCode = -1;
            this.setResult(e.getMessage());
        }
        return res;
    }

    private String parsePort(String addr) {
        return addr.split("://")[1].split(":")[1];
    }

    private String parseHost(String addr) {
        return addr.split("://")[1].split(":")[0];
    }

    @Override
    protected boolean validateArgs(List<String> args) {
        return args.size() == 1;
    }

    public String toString() {
        return "a <node-admin-url> \t\t\t\t\t {Add a neighbour node to the current node.}";
    }
}

