package com.ebmwebsourcing.easyesb.cli.impl.command;

import java.util.List;

import com.ebmwebsourcing.easyesb.cli.impl.AbstractCommand;
import com.ebmwebsourcing.easyesb.soa.api.ESBException;
import com.ebmwebsourcing.esstar.management.UserManagementClient;

public class ProxifyCommand extends AbstractCommand<UserManagementClient> {


	private String url;

	private String wsdl;

	public ProxifyCommand(UserManagementClient client) throws ESBException{
		super(client);
		this.setShortcut("pr");
		this.setName("Proxify");
		this.setDescription("proxify");
	}

	@Override
	public void execute() {
		try {
			
			String proxifyResult = this.getClient().proxify(url, wsdl);

			this.setResult(proxifyResult);
			this.resultCode = AbstractCommand.OK_CODE;
			
		} catch (Throwable e) {
			this.setResult(e.getLocalizedMessage());
			this.resultCode =AbstractCommand.ERROR_CODE;
			
		} 
	}

	@Override
	protected int doProcess(List<String> args) {
		this.url = args.get(0);
		this.wsdl = args.get(1);
		execute();
		return this.resultCode;
		
	}

	@Override
	protected boolean validateArgs(List<String> args) {
		if(args.size() != 2) return false;
		return true;
	}
	
	
	@Override
	public String toString() {
		return "pr <url> <wsdl> \t\t\t\t\t{Proxify a Web Service (SOAP) (Import WS and re-expose it)}";
	}

}
