package com.ebmwebsourcing.easyesb.cli.impl.command;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;

import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

import com.ebmwebsourcing.easyesb.cli.api.Command;
import com.ebmwebsourcing.easyesb.cli.impl.AbstractCommand;
import com.ebmwebsourcing.easyesb.cli.impl.AbstractCommandManager;
import com.ebmwebsourcing.easyesb.soa.api.ESBException;
import com.ebmwebsourcing.esstar.management.UserManagementClient;
import com.ebmwebsourcing.esstar.management.UserManagementClientSOAP;

public class ExportCommand extends AbstractCommand<UserManagementClientSOAP> {

	private AbstractCommandManager cr;

	private File exportFile;

	public ExportCommand(UserManagementClientSOAP client, AbstractCommandManager cr) throws ESBException {
		super(client);
		this.cr = cr;
		this.setShortcut("ex");
		this.setDescription("Export histo to XML Configuration.");
		this.setName("Export");
	}

	@Override
	public void execute() {
		List<String> histo = cr.getHistory();
		Element rootConfiguration = new Element("Configuration", Command.NAMESPACE_JDOM);
		Document histoDom = new Document(rootConfiguration);
		histoDom.setRootElement(rootConfiguration);

		
		Namespace ns = Namespace.getNamespace("xsi", "http://www.w3.org/2001/XMLSchema-instance");
		rootConfiguration.addNamespaceDeclaration(ns);
		rootConfiguration.setAttribute("schemaLocation", "http://ebmwebsourcing.com/cli/schema conf-schema.xsd", ns);
		Element tmpService = null;
		for(String h : histo){
			if(h.startsWith("p ")) continue;

			if(h.startsWith("c ")){
				Element serviceElement = new Element("Service", Command.NAMESPACE_JDOM);
				String value = h.split("c ")[1].trim();
				serviceElement.setAttribute("url", value);
				rootConfiguration.addContent(serviceElement);

				tmpService = serviceElement;
			}

			if(h.startsWith("b ")){
				String[] split = h.split(" ");
				String url = split[1];
				String wsdl = split[2];

				Element actionElement = new Element("Action", Command.NAMESPACE_JDOM);
				tmpService.addContent(actionElement);

				Element importElement = new Element("Bind", Command.NAMESPACE_JDOM);
				actionElement.addContent(importElement);

				Element urlElement = new Element("Url",Command.NAMESPACE_JDOM);
				urlElement.setText(url);
				importElement.addContent(urlElement);

				Element wsdlElement = new Element("Wsdl", Command.NAMESPACE_JDOM);
				wsdlElement.setText(wsdl);
				importElement.addContent(wsdlElement);
			}

			if(h.startsWith("pr ")){
				String[] split = h.split(" ");
				String url = split[1];
				String wsdl = split[2];

				Element actionElement = new Element("Action", Command.NAMESPACE_JDOM);
				tmpService.addContent(actionElement);

				Element proxifyElement = new Element("Proxify", Command.NAMESPACE_JDOM);
				actionElement.addContent(proxifyElement);


				Element urlElement = new Element("Url",Command.NAMESPACE_JDOM);
				urlElement.setText(url);
				proxifyElement.addContent(urlElement);

				Element wsdlElement = new Element("Wsdl", Command.NAMESPACE_JDOM);
				wsdlElement.setText(wsdl);
				proxifyElement.addContent(wsdlElement);
			}

			if(h.startsWith("e ")){
				String[] split = h.split(" ");
				String serviceNamespace = split[1];
				String serviceLocalpart = split[2];
				String endpointName = split[3];

				Element actionElement = new Element("Action", Command.NAMESPACE_JDOM);
				tmpService.addContent(actionElement);

				Element exposeElement = new Element("Expose", Command.NAMESPACE_JDOM);
				actionElement.addContent(exposeElement);

				Element serviceNamespaceElement = new Element("ServiceNamespace", Command.NAMESPACE_JDOM);
				serviceNamespaceElement.setText(serviceNamespace);
				exposeElement.addContent(serviceNamespaceElement);

				Element serviceLocalPartElement = new Element("ServiceName", Command.NAMESPACE_JDOM);
				serviceLocalPartElement.setText(serviceLocalpart);
				exposeElement.addContent(serviceLocalPartElement);

				Element endpointElement = new Element("EndpointName", Command.NAMESPACE_JDOM);
				endpointElement.setText(endpointName);
				exposeElement.addContent(endpointElement);


			}

			if(h.startsWith("d ")){
				String[] split = h.split(" ");
				String mainResource = split[1];
				List<String> args = new ArrayList<String>();
				for(int i=2 ; i<split.length ; i++){
					args.add(split[i]);
				}

				Element actionElement = new Element("Action", Command.NAMESPACE_JDOM);
				tmpService.addContent(actionElement);

				Element deployElement = new Element("Deploy", Command.NAMESPACE_JDOM);
				actionElement.addContent(deployElement);

				Element mainResourceElement = new Element("MainResource", Command.NAMESPACE_JDOM);
				mainResourceElement.setText(mainResource);
				deployElement.addContent(mainResourceElement);

				for(String s : args){
					Element resElement = new Element("Resource", Command.NAMESPACE_JDOM);
					resElement.setText(s);
					deployElement.addContent(resElement);
				}
			}
		}

		
		XMLOutputter outputter = new XMLOutputter();
		Format format = Format.getPrettyFormat();
		outputter.setFormat(format);
		try {
			FileWriter fw = new FileWriter(this.exportFile);
			outputter.output(histoDom, fw);        
			this.resultCode = AbstractCommand.OK_CODE;
			this.setResult("Export Complete to "+this.exportFile.getAbsolutePath());
		}
		catch (IOException e) {
			System.err.println(e);
			this.resultCode = AbstractCommand.ERROR_CODE;
			this.setResult(e.getLocalizedMessage());
		}

	}

	@Override
	protected int doProcess(List<String> args) {
		this.resultCode = AbstractCommand.OK_CODE;

		String exportPath = args.get(0);
		boolean isabsolute;
		try{
			isabsolute = false;
			URI uri = URI.create(exportPath);
			if(uri.isAbsolute()){
				isabsolute = true;
			}else{
				isabsolute = false;
			}
		}catch (Exception e) {
			isabsolute = false;
		}
		if(isabsolute){
			this.exportFile = new File(exportPath);
		}else{
			this.exportFile = new File(new File("."), exportPath);
		}

		try {
			if(exportFile != null && exportFile.createNewFile() && this.exportFile.canWrite()){

				execute();

			}else{
				this.resultCode = AbstractCommand.ERROR_CODE;
			}
		} catch (IOException e) {
			this.setResult(e.getMessage());
			this.resultCode = AbstractCommand.ERROR_CODE;
		}

		return this.resultCode;
	}

	@Override
	public int process(List<String> args) {
		int res = super.process(args);
		if(res == NO_CONNECTION){
			res = doProcess(args);
		}

		System.out.println(this.getResult());
		return res;
	}

	@Override
	protected boolean validateArgs(List<String> args) {
		if(args.size() == 1) return true;
		return false;
	}

	@Override
	public String toString() {
		return "ex <file-path> \t\t\t\t\t {Export history of the console to XML Configuration}";
	}

}
