package com.ebmwebsourcing.easyesb.cli.impl.command;

import java.io.ByteArrayInputStream;
import java.util.List;

import org.w3c.dom.Document;

import com.ebmwebsourcing.easycommons.research.util.dom.DOMUtil;
import com.ebmwebsourcing.easycommons.soap.handler.SOAPSender;
import com.ebmwebsourcing.easycommons.xml.XMLPrettyPrinter;
import com.ebmwebsourcing.easyesb.cli.impl.AbstractCommand;
import com.ebmwebsourcing.easyesb.soa.api.ESBException;
import com.ebmwebsourcing.esstar.management.UserManagementClient;
import com.ebmwebsourcing.esstar.management.UserManagementClientSOAP;


public class SendSoapRequestCommand extends AbstractCommand<UserManagementClientSOAP> {

	private String soapAction;

	private String request;

	private SOAPSender sender = new SOAPSender();

	public SendSoapRequestCommand(UserManagementClientSOAP client) throws ESBException {
		super(client);
		this.setName("SendSoapRequest");
		this.setDescription("Send Soap Request");
		this.setShortcut("ss");
	}

	@Override
	public void execute() {
		try {
			Document doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().parse(new ByteArrayInputStream(request.getBytes()));
			System.out.println("Soap request sent to: " + this.getClient().getAddress());
			System.out.println("Soap request to send:\n" + XMLPrettyPrinter.prettyPrint(doc));
			Document res = this.sender.sendSoapRequest(doc, this.getClient().getAddress(), this.soapAction);
			System.out.println("-------------- res = " + res);
			if(res != null) {
				setResult(XMLPrettyPrinter.prettyPrint(res));
			}
			this.resultCode = AbstractCommand.OK_CODE;

		} catch (Throwable e) {
			e.printStackTrace();
			setResult(e.getLocalizedMessage());
			this.resultCode = AbstractCommand.ERROR_CODE;

		}

	}

	@Override
	protected int doProcess(List<String> args) {
		this.request = args.get(0);
		this.soapAction = args.get(1);
		execute();
		return this.resultCode;

	}

	@Override
	protected boolean validateArgs(List<String> args) {
		if(args.size() == 2){
			return true;
		}
		return false;
	}

	@Override
	public String toString() {
		return "ss <request> <soapAction> \t\t\t\t\t{Send Soap Request}";
	}

}
