/*******************************************************************************
 * Copyright (c) 2011 EBM Websourcing.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v2.1
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * 
 * Contributors:
 *     EBM Websourcing - initial API and implementation
 ******************************************************************************/
package com.ebmwebsourcing.mycomponent;

import java.io.ByteArrayInputStream;

import org.w3c.dom.Document;

import com.ebmwebsourcing.easycommons.research.util.dom.DOMUtil;
import com.ebmwebsourcing.easycommons.xml.XMLPrettyPrinter;
import com.ebmwebsourcing.easyesb.exchange10.api.element.Exchange;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.Endpoint;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.behaviour.AbstractEndpointBehaviourImpl;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.behaviour.EndpointBehaviour;
import com.ebmwebsourcing.easyesb.soa.api.util.MessageUtil;
import com.ebmwebsourcing.easyesb.soa10.api.type.EndpointType;
import com.ebmwebsourcing.easyesb.transporter.api.transport.TransportException;

public class EchoBehaviour extends AbstractEndpointBehaviourImpl implements EndpointBehaviour {




	public EchoBehaviour(Endpoint<? extends EndpointType> ep) {
		super(ep);
	}

	public void execute(Exchange exchange) throws TransportException {
		try {
			// get request
			Document request = exchange.getMessageIn().getBody().getPayload();
			System.out.println("INPUT MESSAGE: \n" + XMLPrettyPrinter.prettyPrint(request));

			// set response in exchange
			MessageUtil.getInstance().createOutMessageStructure(exchange);
			exchange.getMessageOut().getBody().setPayload(DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().parse(new ByteArrayInputStream("<text>Thank you!!!</text>".getBytes())));
		} catch (Exception e) {
			throw new TransportException(e);
		}		
	}

}
