/*******************************************************************************
 * Copyright (c) 2011 EBM Websourcing.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v2.1
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * 
 * Contributors:
 *     EBM Websourcing - initial API and implementation
 ******************************************************************************/
package com.ebmwebsourcing.mycomponent;

import com.ebmwebsourcing.easyesb.cdk.ESBHelper;
import com.ebmwebsourcing.easyesb.soa.api.ESBException;
import com.ebmwebsourcing.easyesb.soa.api.component.Component;
import com.ebmwebsourcing.easyesb.soa.api.config.Configuration;
import com.ebmwebsourcing.easyesb.soa.api.factory.ESBCoreFactory;
import com.ebmwebsourcing.easyesb.soa.api.factory.creation.AbstractComponentCreationFactory;
import com.ebmwebsourcing.easyesb.soa.api.node.Node;

public class MyComponentCreationFactory extends AbstractComponentCreationFactory {
	
	
	@Override
	public String getId() {
		return "MyComponent-factory";
	}

	@SuppressWarnings({ "unchecked", "rawtypes" })
	public Component<?> createComponent(ESBCoreFactory factory, Node node, Configuration conf) throws ESBException {
		final Component<?> myComponent = ESBHelper.createComponent(node, "MyComponent", MyComponentBehaviourImpl.class);
					
		// Expose component as WS
		String externalEndpoint = ESBHelper.exposeAsWS(node, myComponent);
		System.out.println(myComponent.getQName() + " is exposed at: " + externalEndpoint);
		
		return myComponent;
	}

	
}
