package com.ebmwebsourcing.easyesb.mojo;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Properties;
import java.util.logging.Logger;

import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;

import com.ebmwebsourcing.easycommons.research.util.io.FileUtil;


/**
 * @goal generate-component
 * @phase generate-sources
 * @description Generate component for EasyESB
 * @requiresDependencyResolution test
 */
public class CreationComponentArchetypeMojo extends AbstractMojo {

	static Logger LOG = Logger.getLogger(CreationComponentArchetypeMojo.class.getName());


	List<String> resourcesRootList = Arrays.asList("/src/main/resources", "src/test/resources");

	/**
	 * Path where the sources should be placed
	 */
	String sourceRoot = "/src/main/java";

	/**
	 * Path where the test sources should be placed
	 */
	String testsourceRoot = "/src/test/java";

	/**
	 * 
	 */
	String generatedTestSourceRoot = "/target/generated-test-sources/";

	/**
	 * Path where the generated sources should be placed
	 * 
	 */
	public static String DEFAULT_GENERATESOURCE_ROOT = "/target/generated-sources/";
	String generatedSourceRoot = "";

	URI basedir = new File(".").toURI();

	/**
	 * @parameter expression="${project}"
	 * @required
	 */
	MavenProject project;

	/**
	 * @parameter
	 */
	String packageName = "com.ebmwebsourcing.mycomponent";

	/**
	 * @parameter
	 */
	String componentName = "mycomponent";

	String version = "1.0-SNAPSHOT";

	File sourceRootFile = null;
	File testsourceRootFile = null;
	File generatedTestSourceRootFile = null;
	File generatedSourceRootFile = null;



	public void execute() throws MojoExecutionException {


		sourceRootFile = new File(URI.create(basedir.toString() + sourceRoot));
		testsourceRootFile = new File(URI.create(basedir.toString() + testsourceRoot));
		generatedTestSourceRootFile = new File(URI.create(basedir.toString() + generatedTestSourceRoot));
		generatedSourceRootFile = new File(URI.create(basedir.toString() + generatedSourceRoot));

		this.componentName = cleanComponentName(this.componentName);
		
		File project = new File(generatedSourceRootFile, componentName.toLowerCase());
		File projectSrcMainJava = new File(project, "src/main/java");
		File projectSrcMainResources = new File(project, "src/main/resources");
		File projectTestMainJava = new File(project, "src/test/java");
		File projectTestMainResources = new File(project, "src/test/resources");
		File packageSrc = new File(projectSrcMainJava, packageName.replace(".", "/"));
		File packageTest = new File(projectTestMainJava, packageName.replace(".", "/"));
		File packageMetaInfSPI = new File(projectSrcMainResources, "META-INF/services");

		packageSrc.mkdirs();
		packageMetaInfSPI.mkdirs();
		packageTest.mkdirs();
		projectTestMainResources.mkdirs();

		try {

			String easyVersion = getVersionInSetVersionPropertiesFile();
			if(easyVersion == null) {
				throw new Exception("The easyVersion cannot be null!!!");
			}
			
			

			// copy pom
			Map<String, String> map = new HashMap<String, String>();
			map.put("${easy.version}", easyVersion);
			map.put("${artifactId}", componentName);
			map.put("${groupId}", packageName);
			map.put("${version}", version);
			modifyFile(Thread.currentThread().getContextClassLoader().getResource("archetype-resources/pom.xml"), new File(project, "pom.xml"), map);

			// copy source java files
			map = new HashMap<String, String>();
			map.put("MyComponent", this.componentName);
			map.put("package com.ebmwebsourcing.mycomponent;", "package " + this.packageName + ";");
			modifyFile(Thread.currentThread().getContextClassLoader().getResource("archetype-resources/com/ebmwebsourcing/mycomponent/Main.java"), new File(projectSrcMainJava, packageName.replace(".", "/") + "/Main.java"), map);
			
			modifyFile(Thread.currentThread().getContextClassLoader().getResource("archetype-resources/com/ebmwebsourcing/mycomponent/EchoBehaviour.java"), new File(projectSrcMainJava, packageName.replace(".", "/") + "/" + "EchoBehaviour.java"), map);
			modifyFile(Thread.currentThread().getContextClassLoader().getResource("archetype-resources/com/ebmwebsourcing/mycomponent/MyComponentBehaviourImpl.java"), new File(projectSrcMainJava, packageName.replace(".", "/") + "/" + this.componentName + "BehaviourImpl.java"), map);
			modifyFile(Thread.currentThread().getContextClassLoader().getResource("archetype-resources/com/ebmwebsourcing/mycomponent/MyComponentCreationFactory.java"), new File(projectSrcMainJava, packageName.replace(".", "/") + "/" + this.componentName + "CreationFactory.java"), map);
			modifyFile(Thread.currentThread().getContextClassLoader().getResource("archetype-resources/com/ebmwebsourcing/mycomponent/MyComponentLauncher.java"), new File(projectSrcMainJava, packageName.replace(".", "/") + "/" + this.componentName + "Launcher.java"), map);

			// copy test java files
			modifyFile(Thread.currentThread().getContextClassLoader().getResource("archetype-resources/com/ebmwebsourcing/mycomponent/MyComponentTest.java"), new File(projectTestMainJava, packageName.replace(".", "/") + "/" + this.componentName + "Test.java"), map);

			// copy spi files
			map = new HashMap<String, String>();
			map.put("com.ebmwebsourcing.mycomponent.MyComponentCreationFactory", this.packageName + "." + this.componentName + "CreationFactory");
			modifyFile(Thread.currentThread().getContextClassLoader().getResource("META-INF/services/com.ebmwebsourcing.easyesb.soa.api.factory.creation.AbstractComponentCreationFactory"), new File(projectSrcMainResources, "META-INF/services/com.ebmwebsourcing.easyesb.soa.api.factory.creation.AbstractComponentCreationFactory"), map);
		} catch (Exception e) {
			throw new MojoExecutionException(e.getMessage(), e);
		}
	}

	private String cleanComponentName(String cn) {
		String res = cn.replace(".", "_").replace("-", "_");
		res = res.substring(0, 1).toUpperCase() + res.substring(1);
		return res;
	}

	public void modifyFile(URL input, File output, Map<String, String> map) throws Exception {
		BufferedReader br = new BufferedReader(new InputStreamReader(input.openStream()));
		String buffer = "";
		String line = null;
		while ((line=br.readLine())!=null){
			buffer = buffer + line + "\n";
		}
		br.close();
		for(Entry<String, String> entry: map.entrySet()) {
			buffer = buffer.replace(entry.getKey(), entry.getValue());	
		}

		FileUtil.copy(new ByteArrayInputStream(buffer.getBytes()), new FileOutputStream(output));
	}

	public String getVersionInSetVersionPropertiesFile() throws IOException {
		Properties props = new Properties();
		props.load(Thread.currentThread().getContextClassLoader().getResource("setVersion.properties").openStream());
		return (String) props.get("easy.version");
	}

	public String getSourceRoot() {
		return sourceRoot;
	}

	public void setSourceRoot(String sourceRoot) {
		this.sourceRoot = sourceRoot;
	}

	public String getTestsourceRoot() {
		return testsourceRoot;
	}

	public void setTestsourceRoot(String testsourceRoot) {
		this.testsourceRoot = testsourceRoot;
	}

	public String getGeneratedTestSourceRoot() {
		return generatedTestSourceRoot;
	}

	public void setGeneratedTestSourceRoot(String generatedTestSourceRoot) {
		this.generatedTestSourceRoot = generatedTestSourceRoot;
	}

	public String getGeneratedSourceRoot() {
		return generatedSourceRoot;
	}

	public void setGeneratedSourceRoot(String generatedSourceRoot) {
		this.generatedSourceRoot = generatedSourceRoot;
	}

	public void setPackageName(String packageName) {
		this.packageName = packageName;
	}

	public void setComponentName(String componentName) {
		this.componentName = componentName;
	}
	
	public String getPackageName() {
		return packageName;
	}

	public String getComponentName() {
		return componentName;
	}
}
